/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.Analytics$;
import io.gatling.app.RunResult;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.app.SimulationClass;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.GatlingVersion;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.inject.ScenarioFlows;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005]c!\u0002\u0006\f\u00015\t\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u00111\u0002!\u0011!Q\u0001\n5B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)q\t\u0001C\u0001\u0011\"1q\n\u0001C\u0003\u0017ACQ\u0001\u0018\u0001\u0005\u0012uCa\u0001\u001e\u0001\u0005\u00125)\bbBA'\u0001\u0011E\u0011q\n\u0002\u0007%Vtg.\u001a:\u000b\u00051i\u0011aA1qa*\u0011abD\u0001\bO\u0006$H.\u001b8h\u0015\u0005\u0001\u0012AA5p'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012\u0001D:dC2\fGn\\4hS:<'BA\u000f\u001f\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0010\u0002\u0007\r|W.\u0003\u0002\"5\ti1\u000b\u001e:jGRdunZ4j]\u001e\faa]=ti\u0016l7\u0001\u0001\t\u0003K)j\u0011A\n\u0006\u0003O!\nQ!Y2u_JT\u0011!K\u0001\u0005C.\\\u0017-\u0003\u0002,M\tY\u0011i\u0019;peNK8\u000f^3n\u00039)g/\u001a8u\u0019>|\u0007o\u0012:pkB\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u000f\rD\u0017M\u001c8fY*\u0011!gD\u0001\u0006]\u0016$H/_\u0005\u0003i=\u0012a\"\u0012<f]Rdun\u001c9He>,\b/A\u0003dY>\u001c7\u000e\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!Q\u000f^5m\u0015\tYT\"A\u0004d_6lwN\\:\n\u0005uB$!B\"m_\u000e\\\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u000611m\u001c8gS\u001eT!\u0001R\u0007\u0002\t\r|'/Z\u0005\u0003\r\u0006\u0013AcR1uY&twmQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0003J\u00172ke\n\u0005\u0002K\u00015\t1\u0002C\u0003#\u000b\u0001\u0007A\u0005C\u0003-\u000b\u0001\u0007Q\u0006C\u00036\u000b\u0001\u0007a\u0007C\u0003?\u000b\u0001\u0007q(A\u0002sk:$\"!\u0015+\u0011\u0005)\u0013\u0016BA*\f\u0005%\u0011VO\u001c*fgVdG\u000fC\u0003V\r\u0001\u0007a+A\u000bg_J\u001cW\rZ*j[Vd\u0017\r^5p]\u000ec\u0017m]:\u0011\u0007M9\u0016,\u0003\u0002Y)\t1q\n\u001d;j_:\u0004\"A\u0013.\n\u0005m[!aD*j[Vd\u0017\r^5p]\u000ec\u0017m]:\u0002\u001d9,wo\u0015;biN,enZ5oKR\u0019a\f\u001a7\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\u001c\u0015!B:uCR\u001c\u0018BA2a\u0005-\u0019F/\u0019;t\u000b:<\u0017N\\3\t\u000b\u0015<\u0001\u0019\u00014\u0002!MLW.\u001e7bi&|g\u000eU1sC6\u001c\bCA4k\u001b\u0005A'BA5D\u0003!\u00198-\u001a8be&|\u0017BA6i\u0005A\u0019\u0016.\\;mCRLwN\u001c)be\u0006l7\u000fC\u0003n\u000f\u0001\u0007a.\u0001\u0006sk:lUm]:bO\u0016\u0004\"a\u001c:\u000e\u0003AT!!\u001d1\u0002\r]\u0014\u0018\u000e^3s\u0013\t\u0019\bO\u0001\u0006Sk:lUm]:bO\u0016\fQa\u001d;beR$rA^A\b\u0003#\t\t\u0005\r\u0002x}B\u0019\u0001P\u001f?\u000e\u0003eT!!\u000f\u000b\n\u0005mL(a\u0001+ssB\u0011QP \u0007\u0001\t)y\b\"!A\u0001\u0002\u000b\u0005\u0011\u0011\u0001\u0002\u0004?\u0012\n\u0014\u0003BA\u0002\u0003\u0013\u00012aEA\u0003\u0013\r\t9\u0001\u0006\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u00121B\u0005\u0004\u0003\u001b!\"aA!os\")Q\r\u0003a\u0001M\"9\u00111\u0003\u0005A\u0002\u0005U\u0011!D:dK:\f'/[8GY><8\u000f\u0005\u0005\u0002\u0018\u0005\u0005\u0012QEA\u001e\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011AB5oU\u0016\u001cGOC\u0002\u0002 \r\u000b!bY8oiJ|G\u000e\\3s\u0013\u0011\t\u0019#!\u0007\u0003\u001bM\u001bWM\\1sS>4En\\<t!\u0011\t9#!\u000e\u000f\t\u0005%\u0012\u0011\u0007\t\u0004\u0003W!RBAA\u0017\u0015\r\tycI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005MB#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tID\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g!\u0002cA4\u0002>%\u0019\u0011q\b5\u0003\u0011M\u001bWM\\1sS>Dq!a\u0011\t\u0001\u0004\t)%\u0001\bd_J,7i\\7q_:,g\u000e^:\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0002\u0007&\u0019\u00111J\"\u0003\u001d\r{'/Z\"p[B|g.\u001a8ug\u0006)B-[:qY\u0006Lh+\u001a:tS>tw+\u0019:oS:<GCAA)!\r\u0019\u00121K\u0005\u0004\u0003+\"\"\u0001B+oSR\u0004")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public final RunResult run(Option<SimulationClass> forcedSimulationClass) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        this.displayVersionWarning();
        Predef$.MODULE$._configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(forcedSimulationClass, this.configuration);
        if (this.configuration.data().enableAnalytics()) {
            Analytics$.MODULE$.send(selection.simulationClass(), (Option<String>)this.configuration.data().launcher(), (Option<String>)this.configuration.data().buildToolVersion());
        }
        SimulationParams simulationParams = selection.simulationClass().params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        simulationParams.before().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hook executed");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), GatlingVersion$.MODULE$.ThisVersion().fullVersion());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Option throttler = Throttler$.MODULE$.newThrottler(this.system, simulationParams);
        ActorRef injector = Injector$.MODULE$.apply(this.system, this.eventLoopGroup, statsEngine, this.clock);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, injector, throttler, simulationParams), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(injector);
        CoreComponents coreComponents = new CoreComponents(this.system, this.eventLoopGroup, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ScenarioFlows scenarioFlows = simulationParams.scenarioFlows(coreComponents);
        Try<?> try_ = this.start(simulationParams, (ScenarioFlows<String, Scenario>)scenarioFlows, coreComponents);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulationParams.after().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hook executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunResult runResult = new RunResult(runMessage.runId(), simulationParams.assertions().nonEmpty());
        return runResult;
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.configuration);
    }

    public Try<?> start(SimulationParams simulationParams, ScenarioFlows<String, Scenario> scenarioFlows, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)new StringBuilder(22).append("Simulation ").append(simulationParams.name()).append(" started...").toString());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarioFlows);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)new StringBuilder(33).append("Simulation ").append(simulationParams.name()).append(" completed in ").append((coreComponents.clock().nowMillis() - start) / 1000L).append(" seconds").toString());
        return runDone;
    }

    public void displayVersionWarning() {
        GatlingVersion$.MODULE$.LatestRelease().foreach((Function1 & Serializable)latest -> {
            Runner.$anonfun$displayVersionWarning$1(latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$displayVersionWarning$1(GatlingVersion latest) {
        block0: {
            String string = latest.fullVersion();
            String string2 = GatlingVersion$.MODULE$.ThisVersion().fullVersion();
            if (!(string == null ? string2 != null : !string.equals(string2)) || !latest.releaseDate().isAfter(GatlingVersion$.MODULE$.ThisVersion().releaseDate())) break block0;
            scala.Predef$.MODULE$.println((Object)new StringBuilder(38).append("Gatling ").append(latest.fullVersion()).append(" is available! (you're using ").append(GatlingVersion$.MODULE$.ThisVersion().fullVersion()).append(")").toString());
        }
    }

    public Runner(ActorSystem system, EventLoopGroup eventLoopGroup, Clock clock, GatlingConfiguration configuration) {
        this.system = system;
        this.eventLoopGroup = eventLoopGroup;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

