/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.GroupedCount;
import io.gatling.charts.component.RequestStatistics;
import io.gatling.charts.component.Statistics;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.GroupContainer$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.template.ConsoleTemplate$;
import io.gatling.charts.template.GlobalStatsJsonTemplate;
import io.gatling.charts.template.StatsJsTemplate;
import io.gatling.commons.stats.GeneralStats;
import io.gatling.commons.stats.Group;
import io.gatling.commons.stats.GroupStatsPath;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.RequestStatsPath;
import io.gatling.commons.stats.StatsPath;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.NumberHelper;
import io.gatling.commons.util.NumberHelper$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.package$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t3Q!\u0001\u0002\u0001\t)\u0011Ac\u0015;biN\u0014V\r]8si\u001e+g.\u001a:bi>\u0014(BA\u0002\u0005\u0003\u0019\u0011X\r]8si*\u0011QAB\u0001\u0007G\"\f'\u000f^:\u000b\u0005\u001dA\u0011aB4bi2Lgn\u001a\u0006\u0002\u0013\u0005\u0011\u0011n\\\n\u0004\u0001-\t\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0005\u0002\u001335\t1C\u0003\u0002\u0015+\u0005a1oY1mC2|wmZ5oO*\u0011acF\u0001\tif\u0004Xm]1gK*\t\u0001$A\u0002d_6L!AG\n\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0011!a\u0002A!A!\u0002\u0013q\u0012a\u0006:fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]&s\u0007/\u001e;t\u0007\u0001\u0001\"a\b\u0011\u000e\u0003\tI!!\t\u0002\u0003/I+\u0007o\u001c:ug\u001e+g.\u001a:bi&|g.\u00138qkR\u001c\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002!\r|W\u000e]8oK:$H*\u001b2sCJL\bCA\u0013)\u001b\u00051#BA\u0014\u0005\u0003%\u0019w.\u001c9p]\u0016tG/\u0003\u0002*M\t\u00012i\\7q_:,g\u000e\u001e'jEJ\f'/\u001f\u0005\tW\u0001\u0011\t\u0011)A\u0006Y\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\r\r|gNZ5h\u0015\t\td!\u0001\u0003d_J,\u0017BA\u001a/\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")Q\u0007\u0001C\u0001m\u00051A(\u001b8jiz\"2a\u000e\u001e<)\tA\u0014\b\u0005\u0002 \u0001!)1\u0006\u000ea\u0002Y!)A\u0004\u000ea\u0001=!)1\u0005\u000ea\u0001I!)Q\b\u0001C\u0001}\u0005Aq-\u001a8fe\u0006$X\rF\u0001@!\ta\u0001)\u0003\u0002B\u001b\t!QK\\5u\u0001")
public class StatsReportGenerator
implements StrictLogging {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final GatlingConfiguration configuration;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void generate() {
        GroupContainer rootContainer = GroupContainer$.MODULE$.root(this.computeRequestStats$1(ChartsFiles$.MODULE$.GlobalPageName(), (Option)None$.MODULE$, (Option)None$.MODULE$));
        List<StatsPath> statsPaths = this.reportsGenerationInputs.logFileReader().statsPaths();
        Map groupsByHierarchy = (Map)((List)statsPaths.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                Option option;
                Object object;
                A1 A1 = x1;
                if (A1 instanceof GroupStatsPath) {
                    Group group;
                    GroupStatsPath groupStatsPath = (GroupStatsPath)A1;
                    object = group = groupStatsPath.group();
                } else if (A1 instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)A1).group()) instanceof Some) {
                    Group group;
                    Some some = (Some)option;
                    object = group = (Group)some.value();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(StatsPath x1) {
                RequestStatsPath requestStatsPath;
                Option option;
                StatsPath statsPath = x1;
                boolean bl = statsPath instanceof GroupStatsPath ? true : statsPath instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)statsPath).group()) instanceof Some;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)group -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group.hierarchy().reverse()), group), package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        HashSet seenGroups = HashSet$.MODULE$.empty();
        List requestStatsPaths = (List)statsPaths.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                A1 A1 = x2;
                Object object = A1 instanceof RequestStatsPath ? (requestStatsPath = (RequestStatsPath)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(StatsPath x2) {
                StatsPath statsPath = x2;
                boolean bl = statsPath instanceof RequestStatsPath;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
        requestStatsPaths.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            StatsReportGenerator.$anonfun$generate$13(this, rootContainer, groupsByHierarchy, seenGroups, x0$3);
            return BoxedUnit.UNIT;
        });
        new TemplateWriter(ChartsFiles$.MODULE$.statsJsFile(this.reportsGenerationInputs.reportFolderName(), this.configuration)).writeToFile(new StatsJsTemplate(rootContainer, false).getOutput(this.configuration.core().charset()), this.configuration);
        new TemplateWriter(ChartsFiles$.MODULE$.statsJsonFile(this.reportsGenerationInputs.reportFolderName(), this.configuration)).writeToFile(new StatsJsTemplate(rootContainer, true).getOutput(this.configuration.core().charset()), this.configuration);
        new TemplateWriter(ChartsFiles$.MODULE$.globalStatsJsonFile(this.reportsGenerationInputs.reportFolderName(), this.configuration)).writeToFile(new GlobalStatsJsonTemplate(rootContainer.stats(), true).getOutput(), this.configuration);
        Predef$.MODULE$.println((Object)ConsoleTemplate$.MODULE$.println(rootContainer.stats(), this.reportsGenerationInputs.logFileReader().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)));
    }

    private static final Statistics percentiles$1(double rank, Function1 title, GeneralStats total, GeneralStats ok, GeneralStats ko) {
        return new Statistics<Integer>((String)title.apply((Object)BoxesRunTime.boxToDouble((double)rank)), BoxesRunTime.boxToInteger((int)total.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ok.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ko.percentile().apply$mcID$sp(rank)), (Numeric<Integer>)Numeric.IntIsIntegral$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$generate$1(double rank) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response time ", " percentile"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(rank))}));
    }

    private final RequestStatistics computeRequestStats$1(String name, Option requestName, Option group2) {
        String string;
        GeneralStats total = this.reportsGenerationInputs.logFileReader().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)None$.MODULE$);
        GeneralStats ok = this.reportsGenerationInputs.logFileReader().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)OK$.MODULE$));
        GeneralStats ko = this.reportsGenerationInputs.logFileReader().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)KO$.MODULE$));
        Statistics<Object> numberOfRequestsStatistics = new Statistics<Object>("request count", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
        Statistics<Object> minResponseTimeStatistics = new Statistics<Object>("min response time", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Statistics<Object> maxResponseTimeStatistics = new Statistics<Object>("max response time", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Statistics<Object> meanResponseTimeStatistics = new Statistics<Object>("mean response time", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Statistics<Object> stdDeviationStatistics = new Statistics<Object>("std deviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Function1 & Serializable & scala.Serializable percentilesTitle = (Function1 & Serializable & scala.Serializable)rank -> StatsReportGenerator.$anonfun$generate$1(BoxesRunTime.unboxToDouble((Object)rank));
        Statistics percentiles1 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile1(), percentilesTitle, total, ok, ko);
        Statistics percentiles2 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile2(), percentilesTitle, total, ok, ko);
        Statistics percentiles3 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile3(), percentilesTitle, total, ok, ko);
        Statistics percentiles4 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile4(), percentilesTitle, total, ok, ko);
        Statistics<Object> meanNumberOfRequestsPerSecondStatistics = new Statistics<Object>("mean requests/sec", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$);
        Seq groupedCounts = (Seq)this.reportsGenerationInputs.logFileReader().numberOfRequestInResponseTimeRange((Option<String>)requestName, (Option<Group>)group2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rangeName = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            GroupedCount groupedCount = new GroupedCount(rangeName, count, total.count());
            return groupedCount;
        }, Seq$.MODULE$.canBuildFrom());
        Option option = requestName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String n = (String)some.value();
            string = RequestPath$.MODULE$.path(n, (Option<Group>)group2);
        } else if (None$.MODULE$.equals(option)) {
            string = (String)group2.map((Function1 & Serializable & scala.Serializable)group -> RequestPath$.MODULE$.path((Group)group)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        } else {
            throw new MatchError((Object)option);
        }
        String path = string;
        return new RequestStatistics(name, path, numberOfRequestsStatistics, minResponseTimeStatistics, maxResponseTimeStatistics, meanResponseTimeStatistics, stdDeviationStatistics, percentiles1, percentiles2, percentiles3, percentiles4, (Seq<GroupedCount>)groupedCounts, meanNumberOfRequestsPerSecondStatistics);
    }

    private final Function2 groupStatsFunction$1() {
        Function2 & Serializable & scala.Serializable intersect;
        if (this.configuration.charting().useGroupDurationMetric()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group duration stats.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            intersect = (Function2 & Serializable & scala.Serializable)(group, status) -> $this.reportsGenerationInputs.logFileReader().groupDurationGeneralStats((Group)group, (Option<Status>)status);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group cumulated response time stats.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            intersect = (Function2 & Serializable & scala.Serializable)(group, status) -> $this.reportsGenerationInputs.logFileReader().groupCumulatedResponseTimeGeneralStats((Group)group, (Option<Status>)status);
        }
        return intersect;
    }

    public static final /* synthetic */ String $anonfun$generate$7(double x$1) {
        return "percentiles1";
    }

    public static final /* synthetic */ String $anonfun$generate$8(double x$2) {
        return "percentiles2";
    }

    public static final /* synthetic */ String $anonfun$generate$9(double x$3) {
        return "percentiles3";
    }

    public static final /* synthetic */ String $anonfun$generate$10(double x$4) {
        return "percentiles4";
    }

    private final RequestStatistics computeGroupStats$1(String name, Group group) {
        GeneralStats total = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)None$.MODULE$);
        GeneralStats ok = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)OK$.MODULE$));
        GeneralStats ko = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)KO$.MODULE$));
        Statistics<Object> numberOfRequestsStatistics = new Statistics<Object>("numberOfRequests", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
        Statistics<Object> minResponseTimeStatistics = new Statistics<Object>("minResponseTime", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Statistics<Object> maxResponseTimeStatistics = new Statistics<Object>("maxResponseTime", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Statistics<Object> meanResponseTimeStatistics = new Statistics<Object>("meanResponseTime", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Statistics<Object> stdDeviationStatistics = new Statistics<Object>("stdDeviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Statistics percentiles1 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile1(), (Function1 & Serializable & scala.Serializable)x$1 -> StatsReportGenerator.$anonfun$generate$7(BoxesRunTime.unboxToDouble((Object)x$1)), total, ok, ko);
        Statistics percentiles2 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile2(), (Function1 & Serializable & scala.Serializable)x$2 -> StatsReportGenerator.$anonfun$generate$8(BoxesRunTime.unboxToDouble((Object)x$2)), total, ok, ko);
        Statistics percentiles3 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile3(), (Function1 & Serializable & scala.Serializable)x$3 -> StatsReportGenerator.$anonfun$generate$9(BoxesRunTime.unboxToDouble((Object)x$3)), total, ok, ko);
        Statistics percentiles4 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile4(), (Function1 & Serializable & scala.Serializable)x$4 -> StatsReportGenerator.$anonfun$generate$10(BoxesRunTime.unboxToDouble((Object)x$4)), total, ok, ko);
        Statistics<Object> meanNumberOfRequestsPerSecondStatistics = new Statistics<Object>("meanNumberOfRequestsPerSecond", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$);
        Seq groupedCounts = (Seq)this.reportsGenerationInputs.logFileReader().numberOfRequestInResponseTimeRange((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rangeName = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            GroupedCount groupedCount = new GroupedCount(rangeName, count, total.count());
            return groupedCount;
        }, Seq$.MODULE$.canBuildFrom());
        String path = RequestPath$.MODULE$.path(group);
        return new RequestStatistics(name, path, numberOfRequestsStatistics, minResponseTimeStatistics, maxResponseTimeStatistics, meanResponseTimeStatistics, stdDeviationStatistics, percentiles1, percentiles2, percentiles3, percentiles4, (Seq<GroupedCount>)groupedCounts, meanNumberOfRequestsPerSecondStatistics);
    }

    private final void addGroupsRec$1(List hierarchy, GroupContainer rootContainer$1, Map groupsByHierarchy$1, HashSet seenGroups$1) {
        block2: {
            .colon.colon colon2;
            List tail;
            if (seenGroups$1.contains((Object)hierarchy)) break block2;
            seenGroups$1.$plus$eq((Object)hierarchy);
            List list = hierarchy;
            if (list instanceof .colon.colon && (tail = (colon2 = (.colon.colon)list).tl$access$1()).nonEmpty()) {
                this.addGroupsRec$1(tail, rootContainer$1, groupsByHierarchy$1, seenGroups$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Group group = (Group)groupsByHierarchy$1.apply((Object)hierarchy);
            RequestStatistics stats = this.computeGroupStats$1(group.name(), group);
            rootContainer$1.addGroup(group, stats);
        }
    }

    public static final /* synthetic */ void $anonfun$generate$13(StatsReportGenerator $this, GroupContainer rootContainer$1, Map groupsByHierarchy$1, HashSet seenGroups$1, RequestStatsPath x0$3) {
        RequestStatsPath requestStatsPath = x0$3;
        if (requestStatsPath == null) {
            throw new MatchError((Object)requestStatsPath);
        }
        String request = requestStatsPath.request();
        Option group2 = requestStatsPath.group();
        group2.foreach((Function1 & Serializable & scala.Serializable)group -> {
            $this.addGroupsRec$1(group.hierarchy().reverse(), rootContainer$1, groupsByHierarchy$1, seenGroups$1);
            return BoxedUnit.UNIT;
        });
        RequestStatistics stats = $this.computeRequestStats$1(request, (Option)new Some((Object)request), group2);
        rootContainer$1.addRequest((Option<Group>)group2, request, stats);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StatsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ComponentLibrary componentLibrary, GatlingConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
    }
}

