/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats;

import boopickle.Default$;
import boopickle.UnpickleState$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.stats.ErrorRecord;
import io.gatling.charts.stats.ErrorRecordParser$;
import io.gatling.charts.stats.GroupRecord;
import io.gatling.charts.stats.GroupRecordParser;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.LogFileReader$;
import io.gatling.charts.stats.RequestRecord;
import io.gatling.charts.stats.RequestRecordParser;
import io.gatling.charts.stats.ResultsHolder;
import io.gatling.charts.stats.RunInfo;
import io.gatling.charts.stats.StatsHelper$;
import io.gatling.charts.stats.UserRecord;
import io.gatling.charts.stats.UserRecordParser$;
import io.gatling.commons.stats.assertion.Assertion;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.writer.DataWriterMessageSerializer$;
import io.gatling.core.stats.writer.RawAssertionRecord$;
import io.gatling.core.stats.writer.RawErrorRecord$;
import io.gatling.core.stats.writer.RawGroupRecord$;
import io.gatling.core.stats.writer.RawRequestRecord$;
import io.gatling.core.stats.writer.RawRunRecord$;
import io.gatling.core.stats.writer.RawUserRecord$;
import io.gatling.core.stats.writer.RunMessage;
import io.gatling.shared.model.assertion.AssertionPicklers$;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005=sA\u0002\t\u0012\u0011\u0003)\u0012D\u0002\u0004\u001c#!\u0005Q\u0003\b\u0005\u0006[\u0005!\ta\f\u0005\ba\u0005\u0011\r\u0011\"\u00032\u0011\u0019)\u0014\u0001)A\u0005e!9a'\u0001b\u0001\n\u00139\u0004BB\u001e\u0002A\u0003%\u0001\bC\u0003=\u0003\u0011\u0005QHB\u0003\u001c#\t)r\b\u0003\u0005A\u0011\t\u0005\t\u0015!\u0003B\u0011!A\u0005B!A!\u0002\u0013I\u0005\"B\u0017\t\t\u0003\t\u0006\"\u0002+\t\t\u0003)\u0006\"B-\t\t\u0013Q\u0006bBA\u0001\u0011\u0011%\u00111\u0001\u0005\b\u0003\u001fAA\u0011BA\t\u00035aun\u001a$jY\u0016\u0014V-\u00193fe*\u0011!cE\u0001\u0006gR\fGo\u001d\u0006\u0003)U\taa\u00195beR\u001c(B\u0001\f\u0018\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001G\u0001\u0003S>\u0004\"AG\u0001\u000e\u0003E\u0011Q\u0002T8h\r&dWMU3bI\u0016\u00148cA\u0001\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005!J\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003)\n1aY8n\u0013\taSEA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0011$A\u0004M_\u001e\u001cF/\u001a9\u0016\u0003I\u0002\"AH\u001a\n\u0005Qz\"aA%oi\u0006AAj\\4Ti\u0016\u0004\b%\u0001\tTK\u000el\u0015\u000e\u001c7jg\u0016\u001c'+\u0019;j_V\t\u0001\b\u0005\u0002\u001fs%\u0011!h\b\u0002\u0007\t>,(\r\\3\u0002#M+7-T5mY&\u001cXm\u0019*bi&|\u0007%A\u0003baBd\u0017\u0010F\u0004?\u0003k\tI$!\u0014\u0011\u0005iA1c\u0001\u0005\u001eG\u00059An\\4GS2,\u0007C\u0001\"G\u001b\u0005\u0019%B\u0001\rE\u0015\u0005)\u0015\u0001\u00026bm\u0006L!aR\"\u0003\t\u0019KG.Z\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005){U\"A&\u000b\u00051k\u0015AB2p]\u001aLwM\u0003\u0002O+\u0005!1m\u001c:f\u0013\t\u00016J\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u000b\u0004}I\u001b\u0006\"\u0002!\f\u0001\u0004\t\u0005\"\u0002%\f\u0001\u0004I\u0015\u0001\u0002:fC\u0012$\u0012A\u0016\t\u00035]K!\u0001W\t\u0003\u00171{wMR5mK\u0012\u000bG/Y\u0001\ra\u0006\u00148/\u001a'pO\u001aKG.Z\u000b\u00037z#\"\u0001X4\u0011\u0005usF\u0002\u0001\u0003\u0006?6\u0011\r\u0001\u0019\u0002\u0002)F\u0011\u0011\r\u001a\t\u0003=\tL!aY\u0010\u0003\u000f9{G\u000f[5oOB\u0011a$Z\u0005\u0003M~\u00111!\u00118z\u0011\u0015AW\u00021\u0001j\u0003\u00051\u0007\u0003\u0002\u0010kYrK!a[\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA7vq:\u0011an\u001d\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003c:\na\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005Q|\u0012a\u00029bG.\fw-Z\u0005\u0003m^\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003i~\u0001\"!_?\u000f\u0005i\\\bCA8 \u0013\tax$\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001? \u0003%1\u0017N]:u!\u0006\u001c8\u000f\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001\u000e\u0002\b%\u0019\u0011\u0011B\t\u0003\u000fI+h.\u00138g_\"1\u0011Q\u0002\bA\u00021\fqA]3d_J$7/\u0001\u0006tK\u000e|g\u000e\u001a)bgN$\"\"a\u0005\u0002\u001a\u0005u\u0011qEA\u001a!\rQ\u0012QC\u0005\u0004\u0003/\t\"!\u0004*fgVdGo\u001d%pY\u0012,'\u000fC\u0004\u0002\u001c=\u0001\r!!\u0002\u0002\u000fI,h.\u00138g_\"9\u0011qD\bA\u0002\u0005\u0005\u0012a\u00022vG.,Go\u001d\t\u0005=\u0005\r\"'C\u0002\u0002&}\u0011Q!\u0011:sCfDq!!\u000b\u0010\u0001\u0004\tY#\u0001\bck\u000e\\W\r\u001e$v]\u000e$\u0018n\u001c8\u0011\u000byQ\u0017Q\u0006\u001a\u0011\u0007y\ty#C\u0002\u00022}\u0011A\u0001T8oO\"1\u0011QB\bA\u00021Da!a\u000e\b\u0001\u0004A\u0018a\u0002:v]V+\u0018\u000e\u001a\u0005\b\u0003w9\u0001\u0019AA\u001f\u0003A\u0011Xm];miN$\u0015N]3di>\u0014\u0018\u0010\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\t\u0019LG.\u001a\u0006\u0004\u0003\u000f\"\u0015a\u00018j_&!\u00111JA!\u0005\u0011\u0001\u0016\r\u001e5\t\u000b!;\u0001\u0019A%")
public final class LogFileReader
implements StrictLogging {
    private final File logFile;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public static LogFileReader apply(String runUuid, Path resultsDirectory, GatlingConfiguration configuration) {
        return LogFileReader$.MODULE$.apply(runUuid, resultsDirectory, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public LogFileData read() {
        RunInfo runInfo = (RunInfo)this.parseLogFile((Function1 & Serializable)records -> this.firstPass((Iterator<String>)records));
        double step = StatsHelper$.MODULE$.step((int)package$.MODULE$.floor((double)runInfo.injectStart() / LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$SecMillisecRatio()), (int)package$.MODULE$.ceil((double)runInfo.injectEnd() / LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$SecMillisecRatio()), this.configuration.reports().maxPlotsPerSeries()) * LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$SecMillisecRatio();
        int[] buckets = StatsHelper$.MODULE$.buckets(0L, runInfo.injectEnd() - runInfo.injectStart(), step);
        Function1<Object, Object> bucketFunction = StatsHelper$.MODULE$.timeToBucketNumber(runInfo.injectStart(), step, buckets.length);
        ResultsHolder resultsHolder = (ResultsHolder)this.parseLogFile((Function1 & Serializable)x$1 -> this.secondPass(runInfo, buckets, bucketFunction, (Iterator<String>)x$1));
        return new LogFileData(runInfo, resultsHolder, step);
    }

    private <T> T parseLogFile(Function1<Iterator<String>, T> f) {
        return (T)Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(this.logFile, Codec$.MODULE$.charset2codec(this.configuration.core().charset())), (Function1 & Serializable)source -> f.apply((Object)source.getLines()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private RunInfo firstPass(Iterator<String> records) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("First pass");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        IntRef count = IntRef.create((int)0);
        LongRef injectStart = LongRef.create((long)Long.MAX_VALUE);
        LongRef injectEnd = LongRef.create((long)Long.MIN_VALUE);
        ListBuffer runMessages = ListBuffer$.MODULE$.empty();
        LinkedHashSet assertions = LinkedHashSet$.MODULE$.empty();
        records.foreach((Function1 & Serializable)line -> {
            Option option;
            Option option2;
            Option option3;
            Option option4;
            Option option5;
            Option option6;
            BoxedUnit boxedUnit;
            ++count$1.elem;
            if (count$1.elem % LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$LogStep() == 0) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("First pass, read {} lines", (Object)BoxesRunTime.boxToInteger((int)count$1.elem));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String[] stringArray = line.split(DataWriterMessageSerializer$.MODULE$.Separator());
            if (stringArray != null && !(option6 = RawRequestRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option6.get();
                LogFileReader.updateInjectStart$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3])), injectStart);
                LogFileReader.updateInjectEnd$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[4])), injectEnd);
                return BoxedUnit.UNIT;
            }
            if (stringArray != null && !(option5 = RawUserRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option5.get();
                long timestamp = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3]));
                String string = array[2];
                String string2 = MessageEvent.Start$.MODULE$.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    LogFileReader.updateInjectStart$1(timestamp, injectStart);
                }
                LogFileReader.updateInjectEnd$1(timestamp, injectEnd);
                return BoxedUnit.UNIT;
            }
            if (stringArray != null && !(option4 = RawGroupRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option4.get();
                LogFileReader.updateInjectStart$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[2])), injectStart);
                LogFileReader.updateInjectEnd$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3])), injectEnd);
                return BoxedUnit.UNIT;
            }
            if (stringArray != null && !(option3 = RawRunRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option3.get();
                return runMessages.$plus$eq((Object)new RunMessage(array[1], array[2], StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3])), array[4].trim(), array[5].trim(), $this.configuration.data().zoneId()));
            }
            if (stringArray != null && !(option2 = RawAssertionRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option2.get();
                String base64String = array[1];
                byte[] bytes = Base64.getDecoder().decode(base64String);
                Assertion assertion = (Assertion)Default$.MODULE$.Unpickle().apply(AssertionPicklers$.MODULE$.AssertionPickler()).fromBytes(ByteBuffer.wrap(bytes), UnpickleState$.MODULE$.unpickleStateSpeed());
                return assertions.$plus$eq((Object)assertion);
            }
            if (stringArray != null && !(option = RawErrorRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                return BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Record broken on line {}: {}", new Object[]{BoxesRunTime.boxToInteger((int)count$1.elem), line});
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("First pass done: read {} lines", (Object)BoxesRunTime.boxToInteger((int)count.elem));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunMessage runMessage = (RunMessage)runMessages.headOption().getOrElse((Function0 & Serializable)() -> {
            throw new UnsupportedOperationException("Log file " + $this.logFile + " don't contain any valid run record");
        });
        Predef$.MODULE$.assert(injectStart.elem != Long.MAX_VALUE, (Function0 & Serializable)() -> "Undefined run start");
        Predef$.MODULE$.assert(injectEnd.elem != Long.MIN_VALUE, (Function0 & Serializable)() -> "Undefined run end");
        Predef$.MODULE$.assert(injectEnd.elem > injectStart.elem, (Function0 & Serializable)() -> "Run didn't last");
        return new RunInfo(injectStart.elem, injectEnd.elem, runMessage.simulationClassName(), runMessage.runId(), runMessage.runDescription(), (List<Assertion>)assertions.toList());
    }

    private ResultsHolder secondPass(RunInfo runInfo, int[] buckets, Function1<Object, Object> bucketFunction, Iterator<String> records) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Second pass");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ResultsHolder resultsHolder = new ResultsHolder(runInfo.injectStart(), runInfo.injectEnd(), buckets, this.configuration.reports().indicators().lowerBound(), this.configuration.reports().indicators().higherBound());
        IntRef count = IntRef.create((int)0);
        RequestRecordParser requestRecordParser = new RequestRecordParser(bucketFunction);
        GroupRecordParser groupRecordParser = new GroupRecordParser(bucketFunction);
        records.foreach((Function1 & Serializable)line -> {
            LogFileReader.$anonfun$secondPass$1(this, count, requestRecordParser, resultsHolder, groupRecordParser, line);
            return BoxedUnit.UNIT;
        });
        resultsHolder.endDandlingStartedUser();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Second pass: read {} lines", (Object)BoxesRunTime.boxToInteger((int)count.elem));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return resultsHolder;
    }

    private static final void updateInjectStart$1(long eventStart, LongRef injectStart$1) {
        injectStart$1.elem = package$.MODULE$.min(injectStart$1.elem, eventStart);
    }

    private static final void updateInjectEnd$1(long eventEnd, LongRef injectEnd$1) {
        injectEnd$1.elem = package$.MODULE$.max(injectEnd$1.elem, eventEnd);
    }

    public static final /* synthetic */ void $anonfun$secondPass$1(LogFileReader $this, IntRef count$2, RequestRecordParser requestRecordParser$1, ResultsHolder resultsHolder$1, GroupRecordParser groupRecordParser$1, String line) {
        Option<ErrorRecord> option;
        Option<UserRecord> option2;
        Option<GroupRecord> option3;
        Option<RequestRecord> option4;
        BoxedUnit boxedUnit;
        ++count$2.elem;
        if (count$2.elem % LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$LogStep() == 0) {
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Second pass, read {} lines", (Object)BoxesRunTime.boxToInteger((int)count$2.elem));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] stringArray = line.split(DataWriterMessageSerializer$.MODULE$.Separator());
        if (stringArray != null && !(option4 = requestRecordParser$1.unapply(stringArray)).isEmpty()) {
            RequestRecord record = (RequestRecord)option4.get();
            resultsHolder$1.addRequestRecord(record);
            return;
        }
        if (stringArray != null && !(option3 = groupRecordParser$1.unapply(stringArray)).isEmpty()) {
            GroupRecord record = (GroupRecord)option3.get();
            resultsHolder$1.addGroupRecord(record);
            return;
        }
        if (stringArray != null && !(option2 = UserRecordParser$.MODULE$.unapply(stringArray)).isEmpty()) {
            UserRecord record = (UserRecord)option2.get();
            resultsHolder$1.addUserRecord(record);
            return;
        }
        if (stringArray != null && !(option = ErrorRecordParser$.MODULE$.unapply(stringArray)).isEmpty()) {
            ErrorRecord record = (ErrorRecord)option.get();
            resultsHolder$1.addErrorRecord(record);
            return;
        }
    }

    public LogFileReader(File logFile, GatlingConfiguration configuration) {
        this.logFile = logFile;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

