/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.DetailsStatsTableComponent;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PieSlice;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.RequestStatsPath;
import io.gatling.charts.stats.Series;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.stats.StatsPath;
import io.gatling.charts.template.RequestDetailsPageTemplate;
import io.gatling.charts.util.Color;
import io.gatling.charts.util.Color$Requests$;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005-3Q\u0001C\u0005\u0001\u0017EA\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\t7\u0001\u0011\t\u0011)A\u00059!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"B\u001e\u0001\t\u0003a\u0004\"B\"\u0001\t\u0003!%!\b*fcV,7\u000f\u001e#fi\u0006LGn\u001d*fa>\u0014HoR3oKJ\fGo\u001c:\u000b\u0005)Y\u0011A\u0002:fa>\u0014HO\u0003\u0002\r\u001b\u000511\r[1siNT!AD\b\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0001#\u0001\u0002j_N\u0011\u0001A\u0005\t\u0003'Qi\u0011!C\u0005\u0003+%\u0011qBU3q_J$x)\u001a8fe\u0006$xN]\u0001\u0018e\u0016\u0004xN\u001d;t\u000f\u0016tWM]1uS>t\u0017J\u001c9viN\u001c\u0001\u0001\u0005\u0002\u00143%\u0011!$\u0003\u0002\u0018%\u0016\u0004xN\u001d;t\u000f\u0016tWM]1uS>t\u0017J\u001c9viN\f1b\u00195beR\u001ch)\u001b7fgB\u0011Q\u0004I\u0007\u0002=)\u0011qdC\u0001\u0007G>tg-[4\n\u0005\u0005r\"aC\"iCJ$8OR5mKN\f\u0001cY8na>tWM\u001c;MS\n\u0014\u0018M]=\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019Z\u0011!C2p[B|g.\u001a8u\u0013\tASE\u0001\tD_6\u0004xN\\3oi2K'M]1ss\u000691\r[1sg\u0016$\bCA\u00162\u001b\u0005a#BA\u0015.\u0015\tqs&A\u0002oS>T\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023Y\t91\t[1sg\u0016$\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u00026s5\taG\u0003\u0002 o)\u0011\u0001(D\u0001\u0005G>\u0014X-\u0003\u0002;m\t!\"+\u001a9peR\u001c8i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDCB\u001f?\u007f\u0001\u000b%\t\u0005\u0002\u0014\u0001!)aC\u0002a\u00011!)1D\u0002a\u00019!)!E\u0002a\u0001G!)\u0011F\u0002a\u0001U!)1G\u0002a\u0001i\u0005Aq-\u001a8fe\u0006$X\rF\u0001F!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0011)f.\u001b;")
public class RequestDetailsReportGenerator
extends ReportGenerator {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    @Override
    public void generate() {
        this.reportsGenerationInputs.logFileData().statsPaths().foreach((Function1 & Serializable)x0$1 -> {
            RequestDetailsReportGenerator.$anonfun$generate$10(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final Component responseTimeDistributionChartComponent$1(String requestName$1, Option group$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileData().responseTimeDistribution(100, (Option<String>)new Some((Object)requestName$1), (Option<Group>)group$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Seq okDistribution2 = (Seq)tuple22._1();
        Seq koDistribution2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> okDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)okDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> koDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)koDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Response Time", "Requests", okDistributionSeries, koDistributionSeries);
    }

    private final Component responseTimeChartComponent$1(String requestName$1, Option group$1) {
        return this.percentilesChartComponent$1((Function3 & Serializable)(status, requestName, group) -> $this.reportsGenerationInputs.logFileData().responseTimePercentilesOverTime((Status)status, (Option<String>)requestName, (Option<Group>)group), (Function2 & Serializable)(x$2, x$3) -> this.componentLibrary.getPercentilesOverTimeComponent("Response Time", BoxesRunTime.unboxToLong((Object)x$2), x$3), "Response Time Percentiles over Time", requestName$1, group$1);
    }

    private final Component percentilesChartComponent$1(Function3 dataSource, Function2 componentFactory, String title, String requestName$1, Option group$1) {
        Iterable successData = (Iterable)dataSource.apply((Object)OK$.MODULE$, (Object)new Some((Object)requestName$1), (Object)group$1);
        Series successSeries = new Series(title + " (" + Series$.MODULE$.OK() + ")", successData, Color$Requests$.MODULE$.Percentiles());
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileData().runInfo().injectStart()), successSeries);
    }

    private final Component requestsChartComponent$1(String requestName$1, Option group$1) {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileData().numberOfRequestsPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getRequestsComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries), requestName$1, group$1);
    }

    private final Component responsesChartComponent$1(String requestName$1, Option group$1) {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileData().numberOfResponsesPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getResponsesComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries), requestName$1, group$1);
    }

    private final Component countsChartComponent$1(Function2 dataSource, Function3 componentFactory, String requestName$1, Option group$1) {
        Seq counts = (Seq)((SeqOps)dataSource.apply((Object)new Some((Object)requestName$1), (Object)group$1)).sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.time()), (Ordering)Ordering.Int$.MODULE$);
        Series countsSeries = new Series("", counts, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.All(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$))));
        PieSlice okPieSlice = new PieSlice(Series$.MODULE$.OK(), this.count((Seq<CountsVsTimePlot>)counts, (Status)OK$.MODULE$));
        PieSlice koPieSlice = new PieSlice(Series$.MODULE$.KO(), this.count((Seq<CountsVsTimePlot>)counts, (Status)KO$.MODULE$));
        Series pieRequestsSeries = new Series(Series$.MODULE$.Distribution(), new .colon.colon((Object)okPieSlice, (List)new .colon.colon((Object)koPieSlice, (List)Nil$.MODULE$)), (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$)));
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileData().runInfo().injectStart()), countsSeries, pieRequestsSeries);
    }

    private final Component responseTimeScatterChartComponent$1(String requestName$1, Option group$1) {
        return RequestDetailsReportGenerator.scatterChartComponent$1((Function3 & Serializable)(status, requestName, group) -> $this.reportsGenerationInputs.logFileData().responseTimeAgainstGlobalNumberOfRequestsPerSec((Status)status, (String)requestName, (Option<Group>)group), (Function2 & Serializable)(successData, failuresData) -> $this.componentLibrary.getResponseTimeScatterComponent((Series<IntVsTimePlot>)successData, (Series<IntVsTimePlot>)failuresData), requestName$1, group$1);
    }

    private static final Component scatterChartComponent$1(Function3 dataSource, Function2 componentFactory, String requestName$1, Option group$1) {
        Seq scatterPlotSuccessData = (Seq)dataSource.apply((Object)OK$.MODULE$, (Object)requestName$1, (Object)group$1);
        Seq scatterPlotFailuresData = (Seq)dataSource.apply((Object)KO$.MODULE$, (Object)requestName$1, (Object)group$1);
        Series scatterPlotSuccessSeries = new Series(Series$.MODULE$.OK(), scatterPlotSuccessData, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series scatterPlotFailuresSeries = new Series(Series$.MODULE$.KO(), scatterPlotFailuresData, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return (Component)componentFactory.apply(scatterPlotSuccessSeries, scatterPlotFailuresSeries);
    }

    private final void generateDetailPage$1(String path, String requestName, Option group) {
        RequestDetailsPageTemplate template = new RequestDetailsPageTemplate(this.reportsGenerationInputs.logFileData().runInfo(), path, requestName, (Option<Group>)group, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("Response Time Ranges", "requests", true), new DetailsStatsTableComponent(this.configuration.indicators())})), new ErrorsTableComponent(this.reportsGenerationInputs.logFileData().errors((Option<String>)new Some((Object)requestName), (Option<Group>)group)), this.responseTimeDistributionChartComponent$1(requestName, group), this.responseTimeChartComponent$1(requestName, group), this.requestsChartComponent$1(requestName, group), this.responsesChartComponent$1(requestName, group), this.responseTimeScatterChartComponent$1(requestName, group)}));
        new TemplateWriter(this.chartsFiles.requestFile(path)).writeToFile(template.getOutput(), this.charset);
    }

    public static final /* synthetic */ void $anonfun$generate$10(RequestDetailsReportGenerator $this, StatsPath x0$1) {
        StatsPath statsPath = x0$1;
        if (statsPath instanceof RequestStatsPath) {
            RequestStatsPath requestStatsPath = (RequestStatsPath)statsPath;
            String request = requestStatsPath.request();
            Option<Group> group = requestStatsPath.group();
            $this.generateDetailPage$1(RequestPath$.MODULE$.path(request, group), request, group);
            return;
        }
    }

    public RequestDetailsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, Charset charset, ReportsConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.charset = charset;
        this.configuration = configuration;
    }
}

