/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.component;

import io.gatling.charts.component.Component;
import io.gatling.charts.util.HtmlHelper$;
import io.gatling.charts.util.HtmlHelper$HtmlRichString$;
import io.gatling.commons.stats.assertion.Assertion;
import io.gatling.shared.model.assertion.AssertionMessage$;
import io.gatling.shared.model.assertion.AssertionResult;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A3Qa\u0002\u0005\u0003\u0015AA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006\u0003\u0002!IA\u0011\u0005\u0006\u0015\u0002!\t\u0001\u000f\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0002\u0019\u0003N\u001cXM\u001d;j_:\u001cH+\u00192mK\u000e{W\u000e]8oK:$(BA\u0005\u000b\u0003%\u0019w.\u001c9p]\u0016tGO\u0003\u0002\f\u0019\u000511\r[1siNT!!\u0004\b\u0002\u000f\u001d\fG\u000f\\5oO*\tq\"\u0001\u0002j_N\u0019\u0001!E\f\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tA\u0012$D\u0001\t\u0013\tQ\u0002BA\u0005D_6\u0004xN\\3oi\u0006\u0001\u0012m]:feRLwN\u001c*fgVdGo]\u0002\u0001!\rqb%\u000b\b\u0003?\u0011r!\u0001I\u0012\u000e\u0003\u0005R!A\t\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012BA\u0013\u0014\u0003\u001d\u0001\u0018mY6bO\u0016L!a\n\u0015\u0003\t1K7\u000f\u001e\u0006\u0003KM\u0001\"AK\u0019\u000e\u0003-R!\u0001L\u0017\u0002\u0013\u0005\u001c8/\u001a:uS>t'B\u0001\u00180\u0003\u0015iw\u000eZ3m\u0015\t\u0001D\"\u0001\u0004tQ\u0006\u0014X\rZ\u0005\u0003e-\u0012q\"Q:tKJ$\u0018n\u001c8SKN,H\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U2\u0004C\u0001\r\u0001\u0011\u0015Y\"\u00011\u0001\u001e\u0003\tQ7/F\u0001:!\tQdH\u0004\u0002<yA\u0011\u0001eE\u0005\u0003{M\ta\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011QhE\u0001\u0005Y&tW\rF\u0002:\u0007\u0016CQ\u0001\u0012\u0003A\u0002%\nq\"Y:tKJ$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006\r\u0012\u0001\raR\u0001\u0006S:$W\r\u001f\t\u0003%!K!!S\n\u0003\u0007%sG/\u0001\u0003ii6d\u0017a\u00026t\r&dWm]\u000b\u0002\u001bB\u0019aDT\u001d\n\u0005=C#aA*fc\u0002")
public final class AssertionsTableComponent
implements Component {
    private final List<AssertionResult> assertionResults;

    @Override
    public String js() {
        return "\n\t    $$('#container_exceptions').sortable('#container_exceptions');\n    ";
    }

    private String line(AssertionResult assertionResult, int index) {
        String string;
        AssertionResult assertionResult2 = assertionResult;
        if (assertionResult2 instanceof AssertionResult.Resolved) {
            AssertionResult.Resolved resolved = (AssertionResult.Resolved)assertionResult2;
            Assertion assertion = resolved.assertion();
            string = AssertionMessage$.MODULE$.message(assertion);
        } else if (assertionResult2 instanceof AssertionResult.ResolutionError) {
            String error;
            AssertionResult.ResolutionError resolutionError = (AssertionResult.ResolutionError)assertionResult2;
            string = error = resolutionError.error();
        } else {
            throw new MatchError((Object)assertionResult2);
        }
        String message = string;
        String resultStyle = assertionResult.success() ? "ok" : "ko";
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |<tr>\n       |  <td class=\"error-col-1 " + resultStyle + " total\">\n       |    " + HtmlHelper$HtmlRichString$.MODULE$.htmlEscape$extension(HtmlHelper$.MODULE$.HtmlRichString(message)) + "\n       |    <span class=\"value\" style=\"display:none\">" + index + "</span>\n       |  </td>\n       |  <td class=\"error-col-2 value " + resultStyle + " total\">" + (assertionResult.success() ? "OK" : "KO") + "</td>\n       |</tr>"));
    }

    @Override
    public String html() {
        if (this.assertionResults.isEmpty()) {
            return "";
        }
        return "<div class=\"statistics extensible-geant collapsed\">\n    <div class=\"title\">\n        Assertions\n    </div>\n    <table id=\"container_assertions\" class=\"statistics-in extensible-geant\">\n        <thead>\n            <tr>\n                <th id=\"assert-col-1\" class=\"header sortable\"><span>Assertion</span></th>\n                <th id=\"assert-col-2\" class=\"header sortable\"><span>Status</span></th>\n            </tr>\n        </thead>\n\t\t<tbody>\n\t\t    " + ((List)this.assertionResults.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                AssertionResult assertionResult = (AssertionResult)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return this.line(assertionResult, index);
            }
            throw new MatchError((Object)tuple2);
        }).mkString() + "\n\t\t</tbody>\n    </table>\n</div>\n";
    }

    @Override
    public Seq<String> jsFiles() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public AssertionsTableComponent(List<AssertionResult> assertionResults) {
        this.assertionResults = assertionResults;
    }
}

