/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.component.ComponentLibrary$;
import io.gatling.charts.component.RequestStatistics;
import io.gatling.charts.component.Stats;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.AllSessionsReportGenerator;
import io.gatling.charts.report.GlobalReportGenerator;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.GroupContainer$;
import io.gatling.charts.report.GroupDetailsReportGenerator;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.RequestDetailsReportGenerator;
import io.gatling.charts.stats.GeneralStats;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.GroupStatsPath;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.RequestStatsPath;
import io.gatling.charts.stats.StatsPath;
import io.gatling.charts.template.ConsoleTemplate;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import io.gatling.shared.util.NumberHelper;
import io.gatling.shared.util.NumberHelper$;
import io.gatling.shared.util.ScanHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}a!B\u0005\u000b\u00059\u0011\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)Q\t\u0001C\u0001\r\")Q\n\u0001C\u0001\u001d\")A\u000b\u0001C\u0005+\"9\u0011q\u0001\u0001\u0005\n\u0005%!\u0001\u0005*fa>\u0014Ho]$f]\u0016\u0014\u0018\r^8s\u0015\tYA\"\u0001\u0004sKB|'\u000f\u001e\u0006\u0003\u001b9\taa\u00195beR\u001c(BA\b\u0011\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!E\u0001\u0003S>\u001c2\u0001A\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011!$I\u0007\u00027)\u0011A$H\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003=}\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002A\u0005\u00191m\\7\n\u0005\tZ\"!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0004{_:,\u0017\nZ\u0002\u0001!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003uS6,'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aAW8oK&#\u0017aB2iCJ\u001cX\r\u001e\t\u0003_Mj\u0011\u0001\r\u0006\u0003[ER!AM\u0015\u0002\u00079Lw.\u0003\u00025a\t91\t[1sg\u0016$\u0018\u0001\u0005:fgVdGo\u001d#je\u0016\u001cGo\u001c:z!\t9$(D\u00019\u0015\tI\u0014'\u0001\u0003gS2,\u0017BA\u001e9\u0005\u0011\u0001\u0016\r\u001e5\u0002)I,\u0007o\u001c:ug\u000e{gNZ5hkJ\fG/[8o!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u0005:\tAaY8sK&\u0011Ai\u0010\u0002\u0015%\u0016\u0004xN\u001d;t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u00159\u0015JS&M!\tA\u0005!D\u0001\u000b\u0011\u0015\u0019S\u00011\u0001&\u0011\u0015iS\u00011\u0001/\u0011\u0015)T\u00011\u00017\u0011\u0015aT\u00011\u0001>\u0003-9WM\\3sCR,gi\u001c:\u0015\u0005Yz\u0005\"\u0002)\u0007\u0001\u0004\t\u0016a\u0006:fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]&s\u0007/\u001e;t!\tA%+\u0003\u0002T\u0015\t9\"+\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8J]B,Ho]\u0001\fa\u0016\u00148-\u001a8uS2,7\u000fF\u0004W?\u0012$x0a\u0001\u0011\u0007]SF,D\u0001Y\u0015\tIF\"A\u0005d_6\u0004xN\\3oi&\u00111\f\u0017\u0002\u0006'R\fGo\u001d\t\u0003)uK!AX\u000b\u0003\u0007%sG\u000fC\u0003a\u000f\u0001\u0007\u0011-\u0001\u0003sC:\\\u0007C\u0001\u000bc\u0013\t\u0019WC\u0001\u0004E_V\u0014G.\u001a\u0005\u0006K\u001e\u0001\rAZ\u0001\u0006i&$H.\u001a\t\u0005)\u001d\f\u0017.\u0003\u0002i+\tIa)\u001e8di&|g.\r\t\u0003UFt!a[8\u0011\u00051,R\"A7\u000b\u00059$\u0013A\u0002\u001fs_>$h(\u0003\u0002q+\u00051\u0001K]3eK\u001aL!A]:\u0003\rM#(/\u001b8h\u0015\t\u0001X\u0003C\u0003v\u000f\u0001\u0007a/A\u0003u_R\fG\u000eE\u0002\u0015ofL!\u0001_\u000b\u0003\r=\u0003H/[8o!\tQX0D\u0001|\u0015\taH\"A\u0003ti\u0006$8/\u0003\u0002\u007fw\naq)\u001a8fe\u0006d7\u000b^1ug\"1\u0011\u0011A\u0004A\u0002Y\f!a\\6\t\r\u0005\u0015q\u00011\u0001w\u0003\tYw.\u0001\u000bd_6\u0004X\u000f^3S_>$8i\u001c8uC&tWM\u001d\u000b\u0007\u0003\u0017\t\t\"a\u0007\u0011\u0007!\u000bi!C\u0002\u0002\u0010)\u0011ab\u0012:pkB\u001cuN\u001c;bS:,'\u000fC\u0004\u0002\u0014!\u0001\r!!\u0006\u0002\u00171|wMR5mK\u0012\u000bG/\u0019\t\u0004u\u0006]\u0011bAA\rw\nYAj\\4GS2,G)\u0019;b\u0011\u0019\ti\u0002\u0003a\u0001{\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004")
public final class ReportsGenerator
implements StrictLogging {
    private final ZoneId zoneId;
    private final Charset charset;
    private final Path resultsDirectory;
    private final ReportsConfiguration reportsConfiguration;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Path generateFor(ReportsGenerationInputs reportsGenerationInputs) {
        ChartsFiles chartsFiles = new ChartsFiles(reportsGenerationInputs.reportFolderName(), this.resultsDirectory);
        if (!ReportsGenerator.hasAtLeastOneRequestReported$1(reportsGenerationInputs)) {
            throw new UnsupportedOperationException("There were no requests sent during the simulation, reports won't be generated");
        }
        GroupContainer rootContainer = this.computeRootContainer(reportsGenerationInputs.logFileData(), this.reportsConfiguration);
        .colon.colon reportGenerators = new .colon.colon((Object)new AllSessionsReportGenerator(reportsGenerationInputs.logFileData(), chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.charset), (List)new .colon.colon((Object)new GlobalReportGenerator(reportsGenerationInputs.logFileData(), reportsGenerationInputs.assertionResults(), rootContainer, chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.zoneId, this.charset, this.reportsConfiguration), (List)new .colon.colon((Object)new RequestDetailsReportGenerator(reportsGenerationInputs.logFileData(), rootContainer, chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.charset, this.reportsConfiguration), (List)new .colon.colon((Object)new GroupDetailsReportGenerator(reportsGenerationInputs.logFileData(), rootContainer, chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.charset, this.reportsConfiguration), (List)Nil$.MODULE$))));
        ReportsGenerator.copyAssets$1(chartsFiles);
        reportGenerators.foreach((Function1 & Serializable)x$2 -> {
            x$2.generate();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new ConsoleTemplate(rootContainer.stats(), reportsGenerationInputs.logFileData().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)).getOutput());
        return chartsFiles.globalFile();
    }

    private Stats<Object> percentiles(double rank, Function1<Object, String> title, Option<GeneralStats> total, Option<GeneralStats> ok, Option<GeneralStats> ko) {
        return new Stats<Object>((String)title.apply((Object)BoxesRunTime.boxToDouble((double)rank)) + " (ms)", (Option<Object>)total.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ReportsGenerator.$anonfun$percentiles$1(rank, x$3))), (Option<Object>)ok.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)ReportsGenerator.$anonfun$percentiles$2(rank, x$4))), (Option<Object>)ko.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ReportsGenerator.$anonfun$percentiles$3(rank, x$5))), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
    }

    private GroupContainer computeRootContainer(LogFileData logFileData, ReportsConfiguration configuration) {
        GroupContainer rootContainer = GroupContainer$.MODULE$.root(this.computeRequestStats$1((Option)None$.MODULE$, (Option)None$.MODULE$, logFileData, configuration));
        List<StatsPath> statsPaths = logFileData.statsPaths();
        Map groupsByHierarchy = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                Option<Group> option;
                A1 A1 = x1;
                if (A1 instanceof GroupStatsPath) {
                    GroupStatsPath groupStatsPath = (GroupStatsPath)A1;
                    Group group = groupStatsPath.group();
                    return (B1)group;
                }
                if (A1 instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)A1).group()) instanceof Some) {
                    Some some = (Some)option;
                    Group group = (Group)some.value();
                    return (B1)group;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(StatsPath x1) {
                RequestStatsPath requestStatsPath;
                Option<Group> option;
                StatsPath statsPath = x1;
                if (statsPath instanceof GroupStatsPath) {
                    return true;
                }
                return statsPath instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)statsPath).group()) instanceof Some;
            }
        }).map((Function1 & Serializable)group -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group.hierarchy().reverse()), group)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashSet seenGroups = HashSet$.MODULE$.empty();
        List requestStatsPaths = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof RequestStatsPath) {
                    RequestStatsPath requestStatsPath = (RequestStatsPath)A1;
                    return (B1)requestStatsPath;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(StatsPath x2) {
                StatsPath statsPath = x2;
                return statsPath instanceof RequestStatsPath;
            }
        });
        requestStatsPaths.foreach((Function1 & Serializable)x0$1 -> {
            ReportsGenerator.$anonfun$computeRootContainer$45(this, rootContainer, logFileData, configuration, seenGroups, groupsByHierarchy, x0$1);
            return BoxedUnit.UNIT;
        });
        return rootContainer;
    }

    public static final /* synthetic */ boolean $anonfun$generateFor$1(StatsPath x$1) {
        return x$1 instanceof RequestStatsPath;
    }

    private static final boolean hasAtLeastOneRequestReported$1(ReportsGenerationInputs reportsGenerationInputs$1) {
        return reportsGenerationInputs$1.logFileData().statsPaths().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReportsGenerator.$anonfun$generateFor$1(x$1)));
    }

    private static final void copyAssets$1(ChartsFiles chartsFiles$1) {
        ScanHelper$.MODULE$.deepCopyPackageContent(ChartsFiles$.MODULE$.GatlingAssetsStylePackage(), chartsFiles$1.styleDirectory());
        ScanHelper$.MODULE$.deepCopyPackageContent(ChartsFiles$.MODULE$.GatlingAssetsJsPackage(), chartsFiles$1.jsDirectory());
    }

    public static final /* synthetic */ int $anonfun$percentiles$1(double rank$1, GeneralStats x$3) {
        return x$3.percentile().apply$mcID$sp(rank$1);
    }

    public static final /* synthetic */ int $anonfun$percentiles$2(double rank$1, GeneralStats x$4) {
        return x$4.percentile().apply$mcID$sp(rank$1);
    }

    public static final /* synthetic */ int $anonfun$percentiles$3(double rank$1, GeneralStats x$5) {
        return x$5.percentile().apply$mcID$sp(rank$1);
    }

    public static final /* synthetic */ String $anonfun$computeRootContainer$1(double rank) {
        return "response time " + NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(rank)) + " percentile";
    }

    private final RequestStatistics computeRequestStats$1(Option requestName, Option group, LogFileData logFileData$1, ReportsConfiguration configuration$1) {
        Option<GeneralStats> total = logFileData$1.requestGeneralStats((Option<String>)requestName, (Option<Group>)group, (Option<Status>)None$.MODULE$);
        Option<GeneralStats> ok = logFileData$1.requestGeneralStats((Option<String>)requestName, (Option<Group>)group, (Option<Status>)new Some((Object)OK$.MODULE$));
        Option<GeneralStats> ko = logFileData$1.requestGeneralStats((Option<String>)requestName, (Option<Group>)group, (Option<Status>)new Some((Object)KO$.MODULE$));
        Function1 & Serializable percentilesTitle = (Function1 & Serializable)rank -> ReportsGenerator.$anonfun$computeRootContainer$1(BoxesRunTime.unboxToDouble((Object)rank));
        return new RequestStatistics(new Stats<Object>("request count", (Option<Object>)total.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.count())), (Option<Object>)ok.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.count())), (Option<Object>)ko.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.count())), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$), new Stats<Object>("min response time (ms)", (Option<Object>)total.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.min())), (Option<Object>)ok.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.min())), (Option<Object>)ko.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.min())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("max response time (ms)", (Option<Object>)total.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.max())), (Option<Object>)ok.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.max())), (Option<Object>)ko.map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.max())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("mean response time (ms)", (Option<Object>)total.map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.mean())), (Option<Object>)ok.map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.mean())), (Option<Object>)ko.map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.mean())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("response time std deviation (ms)", (Option<Object>)total.map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.stdDev())), (Option<Object>)ok.map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.stdDev())), (Option<Object>)ko.map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.stdDev())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), this.percentiles(configuration$1.indicators().percentile1(), (Function1<Object, String>)percentilesTitle, total, ok, ko), this.percentiles(configuration$1.indicators().percentile2(), (Function1<Object, String>)percentilesTitle, total, ok, ko), this.percentiles(configuration$1.indicators().percentile3(), (Function1<Object, String>)percentilesTitle, total, ok, ko), this.percentiles(configuration$1.indicators().percentile4(), (Function1<Object, String>)percentilesTitle, total, ok, ko), logFileData$1.numberOfRequestInResponseTimeRanges((Option<String>)requestName, (Option<Group>)group), new Stats<Object>("mean throughput (rps)", (Option<Object>)total.map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToDouble((double)x$21.meanRequestsPerSec())), (Option<Object>)ok.map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22.meanRequestsPerSec())), (Option<Object>)ko.map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToDouble((double)x$23.meanRequestsPerSec())), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final Function2 groupStatsFunction$1(ReportsConfiguration configuration$1, LogFileData logFileData$1) {
        BoxedUnit boxedUnit;
        if (configuration$1.useGroupDurationMetric()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group duration stats.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return (Function2 & Serializable)(group, status) -> logFileData$1.groupDurationGeneralStats((Group)group, (Option<Status>)status);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Use group cumulated response time stats.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Function2 & Serializable)(group, status) -> logFileData$1.groupCumulatedResponseTimeGeneralStats((Group)group, (Option<Status>)status);
    }

    public static final /* synthetic */ String $anonfun$computeRootContainer$37(double x$39) {
        return "percentiles1";
    }

    public static final /* synthetic */ String $anonfun$computeRootContainer$38(double x$40) {
        return "percentiles2";
    }

    public static final /* synthetic */ String $anonfun$computeRootContainer$39(double x$41) {
        return "percentiles3";
    }

    public static final /* synthetic */ String $anonfun$computeRootContainer$40(double x$42) {
        return "percentiles4";
    }

    private final RequestStatistics computeGroupStats$1(Group group, ReportsConfiguration configuration$1, LogFileData logFileData$1) {
        Option total = (Option)this.groupStatsFunction$1(configuration$1, logFileData$1).apply((Object)group, (Object)None$.MODULE$);
        Option ok = (Option)this.groupStatsFunction$1(configuration$1, logFileData$1).apply((Object)group, (Object)new Some((Object)OK$.MODULE$));
        Option ko = (Option)this.groupStatsFunction$1(configuration$1, logFileData$1).apply((Object)group, (Object)new Some((Object)KO$.MODULE$));
        return new RequestStatistics(new Stats<Object>("numberOfRequests", (Option<Object>)total.map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)x$24.count())), (Option<Object>)ok.map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.count())), (Option<Object>)ko.map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)x$26.count())), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$), new Stats<Object>("minResponseTime", (Option<Object>)total.map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToInteger((int)x$27.min())), (Option<Object>)ok.map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToInteger((int)x$28.min())), (Option<Object>)ko.map((Function1 & Serializable)x$29 -> BoxesRunTime.boxToInteger((int)x$29.min())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("maxResponseTime", (Option<Object>)total.map((Function1 & Serializable)x$30 -> BoxesRunTime.boxToInteger((int)x$30.max())), (Option<Object>)ok.map((Function1 & Serializable)x$31 -> BoxesRunTime.boxToInteger((int)x$31.max())), (Option<Object>)ko.map((Function1 & Serializable)x$32 -> BoxesRunTime.boxToInteger((int)x$32.max())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("meanResponseTime", (Option<Object>)total.map((Function1 & Serializable)x$33 -> BoxesRunTime.boxToInteger((int)x$33.mean())), (Option<Object>)ok.map((Function1 & Serializable)x$34 -> BoxesRunTime.boxToInteger((int)x$34.mean())), (Option<Object>)ko.map((Function1 & Serializable)x$35 -> BoxesRunTime.boxToInteger((int)x$35.mean())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("stdDeviation", (Option<Object>)total.map((Function1 & Serializable)x$36 -> BoxesRunTime.boxToInteger((int)x$36.stdDev())), (Option<Object>)ok.map((Function1 & Serializable)x$37 -> BoxesRunTime.boxToInteger((int)x$37.stdDev())), (Option<Object>)ko.map((Function1 & Serializable)x$38 -> BoxesRunTime.boxToInteger((int)x$38.stdDev())), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), this.percentiles(configuration$1.indicators().percentile1(), (Function1<Object, String>)(Function1 & Serializable)x$39 -> ReportsGenerator.$anonfun$computeRootContainer$37(BoxesRunTime.unboxToDouble((Object)x$39)), (Option<GeneralStats>)total, (Option<GeneralStats>)ok, (Option<GeneralStats>)ko), this.percentiles(configuration$1.indicators().percentile2(), (Function1<Object, String>)(Function1 & Serializable)x$40 -> ReportsGenerator.$anonfun$computeRootContainer$38(BoxesRunTime.unboxToDouble((Object)x$40)), (Option<GeneralStats>)total, (Option<GeneralStats>)ok, (Option<GeneralStats>)ko), this.percentiles(configuration$1.indicators().percentile3(), (Function1<Object, String>)(Function1 & Serializable)x$41 -> ReportsGenerator.$anonfun$computeRootContainer$39(BoxesRunTime.unboxToDouble((Object)x$41)), (Option<GeneralStats>)total, (Option<GeneralStats>)ok, (Option<GeneralStats>)ko), this.percentiles(configuration$1.indicators().percentile4(), (Function1<Object, String>)(Function1 & Serializable)x$42 -> ReportsGenerator.$anonfun$computeRootContainer$40(BoxesRunTime.unboxToDouble((Object)x$42)), (Option<GeneralStats>)total, (Option<GeneralStats>)ok, (Option<GeneralStats>)ko), logFileData$1.numberOfRequestInResponseTimeRanges((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group)), new Stats<Object>("meanNumberOfRequestsPerSecond", (Option<Object>)total.map((Function1 & Serializable)x$43 -> BoxesRunTime.boxToDouble((double)x$43.meanRequestsPerSec())), (Option<Object>)ok.map((Function1 & Serializable)x$44 -> BoxesRunTime.boxToDouble((double)x$44.meanRequestsPerSec())), (Option<Object>)ko.map((Function1 & Serializable)x$45 -> BoxesRunTime.boxToDouble((double)x$45.meanRequestsPerSec())), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final void addGroupsRec$1(List hierarchy, HashSet seenGroups$1, Map groupsByHierarchy$1, GroupContainer rootContainer$1, ReportsConfiguration configuration$1, LogFileData logFileData$1) {
        if (!seenGroups$1.contains((Object)hierarchy)) {
            .colon.colon colon2;
            List tail;
            seenGroups$1.$plus$eq((Object)hierarchy);
            List list = hierarchy;
            if (list instanceof .colon.colon && (tail = (colon2 = (.colon.colon)list).next$access$1()).nonEmpty()) {
                this.addGroupsRec$1(tail, seenGroups$1, groupsByHierarchy$1, rootContainer$1, configuration$1, logFileData$1);
            }
            Group group = (Group)groupsByHierarchy$1.apply((Object)hierarchy);
            RequestStatistics stats = this.computeGroupStats$1(group, configuration$1, logFileData$1);
            rootContainer$1.addGroup(group, stats);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$computeRootContainer$45(ReportsGenerator $this, GroupContainer rootContainer$1, LogFileData logFileData$1, ReportsConfiguration configuration$1, HashSet seenGroups$1, Map groupsByHierarchy$1, RequestStatsPath x0$1) {
        RequestStatsPath requestStatsPath = x0$1;
        if (requestStatsPath != null) {
            String request = requestStatsPath.request();
            Option<Group> group2 = requestStatsPath.group();
            group2.foreach((Function1 & Serializable)group -> {
                $this.addGroupsRec$1(group.hierarchy().reverse(), seenGroups$1, groupsByHierarchy$1, rootContainer$1, configuration$1, logFileData$1);
                return BoxedUnit.UNIT;
            });
            RequestStatistics stats = $this.computeRequestStats$1((Option)new Some((Object)request), group2, logFileData$1, configuration$1);
            rootContainer$1.addRequest(group2, request, stats);
            return;
        }
        throw new MatchError((Object)requestStatsPath);
    }

    public ReportsGenerator(ZoneId zoneId, Charset charset, Path resultsDirectory, ReportsConfiguration reportsConfiguration) {
        this.zoneId = zoneId;
        this.charset = charset;
        this.resultsDirectory = resultsDirectory;
        this.reportsConfiguration = reportsConfiguration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

