/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.AssertionsTableComponent;
import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.component.GlobalStatsTableComponent;
import io.gatling.charts.component.SimulationCardComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.stats.PieSlice;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.stats.Series;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.template.GlobalPageTemplate;
import io.gatling.charts.util.Color;
import io.gatling.charts.util.Color$Requests$;
import io.gatling.charts.util.Color$Users$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.core.config.ReportsConfiguration;
import io.gatling.shared.model.assertion.AssertionResult;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.ZoneId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ud!B\t\u0013\u0005QQ\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u000b=\u0004A\u0011\u00019\t\u000bi\u0004A\u0011B>\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\u001d\u0001\t\u0003\t)HA\u000bHY>\u0014\u0017\r\u001c*fa>\u0014HoR3oKJ\fGo\u001c:\u000b\u0005M!\u0012A\u0002:fa>\u0014HO\u0003\u0002\u0016-\u000511\r[1siNT!a\u0006\r\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011$\u0001\u0002j_N\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u00113%D\u0001\u0013\u0013\t!#CA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003-awn\u001a$jY\u0016$\u0015\r^1\u0004\u0001A\u0011\u0001fK\u0007\u0002S)\u0011!\u0006F\u0001\u0006gR\fGo]\u0005\u0003Y%\u00121\u0002T8h\r&dW\rR1uC\u0006\u0001\u0012m]:feRLwN\u001c*fgVdGo\u001d\t\u0004_]RdB\u0001\u00196\u001d\t\tD'D\u00013\u0015\t\u0019d%\u0001\u0004=e>|GOP\u0005\u0002=%\u0011a'H\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014H\u0001\u0003MSN$(B\u0001\u001c\u001e!\tY$)D\u0001=\u0015\tid(A\u0005bgN,'\u000f^5p]*\u0011q\bQ\u0001\u0006[>$W\r\u001c\u0006\u0003\u0003Z\taa\u001d5be\u0016$\u0017BA\"=\u0005=\t5o]3si&|gNU3tk2$\u0018!\u0004:p_R\u001cuN\u001c;bS:,'\u000f\u0005\u0002#\r&\u0011qI\u0005\u0002\u000f\u000fJ|W\u000f]\"p]R\f\u0017N\\3s\u0003-\u0019\u0007.\u0019:ug\u001aKG.Z:\u0011\u0005)kU\"A&\u000b\u00051#\u0012AB2p]\u001aLw-\u0003\u0002O\u0017\nY1\t[1siN4\u0015\u000e\\3t\u0003A\u0019w.\u001c9p]\u0016tG\u000fT5ce\u0006\u0014\u0018\u0010\u0005\u0002R)6\t!K\u0003\u0002T)\u0005I1m\\7q_:,g\u000e^\u0005\u0003+J\u0013\u0001cQ8na>tWM\u001c;MS\n\u0014\u0018M]=\u0002\ri|g.Z%e!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003uS6,'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013aAW8oK&#\u0017aB2iCJ\u001cX\r\u001e\t\u0003C\u0016l\u0011A\u0019\u0006\u0003?\u000eT!\u0001Z.\u0002\u00079Lw.\u0003\u0002gE\n91\t[1sg\u0016$\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002j[6\t!N\u0003\u0002MW*\u0011ANF\u0001\u0005G>\u0014X-\u0003\u0002oU\n!\"+\u001a9peR\u001c8i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtD#C9sgR,ho\u001e=z!\t\u0011\u0003\u0001C\u0003&\u0013\u0001\u0007q\u0005C\u0003.\u0013\u0001\u0007a\u0006C\u0003E\u0013\u0001\u0007Q\tC\u0003I\u0013\u0001\u0007\u0011\nC\u0003P\u0013\u0001\u0007\u0001\u000bC\u0003W\u0013\u0001\u0007q\u000bC\u0003`\u0013\u0001\u0007\u0001\rC\u0003h\u0013\u0001\u0007\u0001.\u0001\u000fbGRLg/Z*fgNLwN\\:DQ\u0006\u0014HoQ8na>tWM\u001c;\u0015\u0005q|\bCA)~\u0013\tq(KA\u0005D_6\u0004xN\\3oi\")QE\u0003a\u0001O\u00051#/Z:q_:\u001cX\rV5nK\u0012K7\u000f\u001e:jEV$\u0018n\u001c8DQ\u0006\u0014HoQ8na>tWM\u001c;\u0015\u0007q\f)\u0001C\u0003&\u0017\u0001\u0007q%\u0001\u000esKN\u0004xN\\:f)&lWm\u00115beR\u001cu.\u001c9p]\u0016tG\u000fF\u0002}\u0003\u0017AQ!\n\u0007A\u0002\u001d\naC]3rk\u0016\u001cHo]\"iCJ$8i\\7q_:,g\u000e\u001e\u000b\u0004y\u0006E\u0001\"B\u0013\u000e\u0001\u00049\u0013a\u0006:fgB|gn]3t\u0007\"\f'\u000f^\"p[B|g.\u001a8u)\ra\u0018q\u0003\u0005\u0006K9\u0001\raJ\u0001\u0015G>,h\u000e^:DQ\u0006\u0014HoQ8na>tWM\u001c;\u0015\u000fq\fi\"!\u0015\u0002p!9\u0011qD\bA\u0002\u0005\u0005\u0012A\u00033bi\u0006\u001cv.\u001e:dKBIA$a\t\u0002(\u0005u\u0012QI\u0005\u0004\u0003Ki\"!\u0003$v]\u000e$\u0018n\u001c83!\u0015a\u0012\u0011FA\u0017\u0013\r\tY#\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0012q\u0007\b\u0005\u0003c\t\u0019\u0004\u0005\u00022;%\u0019\u0011QG\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\r\t)$\b\t\u00069\u0005%\u0012q\b\t\u0004Q\u0005\u0005\u0013bAA\"S\t)qI]8vaB)q&a\u0012\u0002L%\u0019\u0011\u0011J\u001d\u0003\u0007M+\u0017\u000fE\u0002)\u0003\u001bJ1!a\u0014*\u0005A\u0019u.\u001e8ugZ\u001bH+[7f!2|G\u000fC\u0004\u0002T=\u0001\r!!\u0016\u0002!\r|W\u000e]8oK:$h)Y2u_JL\bC\u0003\u000f\u0002X\u0005m\u0013\u0011MA4y&\u0019\u0011\u0011L\u000f\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004c\u0001\u000f\u0002^%\u0019\u0011qL\u000f\u0003\t1{gn\u001a\t\u0006Q\u0005\r\u00141J\u0005\u0004\u0003KJ#AB*fe&,7\u000fE\u0003)\u0003G\nI\u0007E\u0002)\u0003WJ1!!\u001c*\u0005!\u0001\u0016.Z*mS\u000e,\u0007bBA9\u001f\u0001\u0007\u00111L\u0001\fS:TWm\u0019;Ti\u0006\u0014H/\u0001\u0005hK:,'/\u0019;f)\t\t9\bE\u0002\u001d\u0003sJ1!a\u001f\u001e\u0005\u0011)f.\u001b;")
public final class GlobalReportGenerator
implements ReportGenerator {
    private final LogFileData logFileData;
    private final List<AssertionResult> assertionResults;
    private final GroupContainer rootContainer;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final ZoneId zoneId;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    private Component activeSessionsChartComponent(LogFileData logFileData) {
        List seriesColors = package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> Color$Users$.MODULE$.Base()).flatten(Predef$.MODULE$.$conforms()).take(logFileData.scenarioNames().size()).toList();
        List activeSessionsSeries = ((List)logFileData.scenarioNames().map((Function1 & Serializable)scenarioName -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(scenarioName), logFileData.numberOfActiveSessionsPerSecond((Option<String>)new Some(scenarioName)))).reverse().zip((IterableOnce)seriesColors)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Color color = (Color)tuple2._2();
                if (tuple22 != null) {
                    String scenarioName = (String)tuple22._1();
                    Seq data = (Seq)tuple22._2();
                    return new Series(scenarioName, data, (List<Color>)new .colon.colon((Object)color, (List)Nil$.MODULE$));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return this.componentLibrary.getActiveSessionsComponent(logFileData.runInfo().injectStart(), (Seq<Series<IntVsTimePlot>>)activeSessionsSeries);
    }

    private Component responseTimeDistributionChartComponent(LogFileData logFileData) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = logFileData.responseTimeDistribution(100, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Seq okDistribution2 = (Seq)tuple22._1();
        Seq koDistribution2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> okDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)okDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> koDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)koDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Response Time", "Requests", okDistributionSeries, koDistributionSeries);
    }

    private Component responseTimeChartComponent(LogFileData logFileData) {
        Iterable<PercentilesVsTimePlot> successData = logFileData.responseTimePercentilesOverTime((Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        Series<PercentilesVsTimePlot> successSeries = new Series<PercentilesVsTimePlot>("Response Time Percentiles over Time (" + Series$.MODULE$.OK() + ")", successData, Color$Requests$.MODULE$.Percentiles());
        return this.componentLibrary.getPercentilesOverTimeComponent("Response Time", logFileData.runInfo().injectStart(), successSeries);
    }

    private Component requestsChartComponent(LogFileData logFileData) {
        return this.countsChartComponent((Function2<Option<String>, Option<Group>, Seq<CountsVsTimePlot>>)(Function2 & Serializable)(requestName, group) -> logFileData.numberOfRequestsPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3<Object, Series<CountsVsTimePlot>, Series<PieSlice>, Component>)(Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getRequestsComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries), logFileData.runInfo().injectStart());
    }

    private Component responsesChartComponent(LogFileData logFileData) {
        return this.countsChartComponent((Function2<Option<String>, Option<Group>, Seq<CountsVsTimePlot>>)(Function2 & Serializable)(requestName, group) -> logFileData.numberOfResponsesPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3<Object, Series<CountsVsTimePlot>, Series<PieSlice>, Component>)(Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getResponsesComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries), logFileData.runInfo().injectStart());
    }

    private Component countsChartComponent(Function2<Option<String>, Option<Group>, Seq<CountsVsTimePlot>> dataSource, Function3<Object, Series<CountsVsTimePlot>, Series<PieSlice>, Component> componentFactory, long injectStart) {
        Seq counts = (Seq)((SeqOps)dataSource.apply((Object)None$.MODULE$, (Object)None$.MODULE$)).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.time()), (Ordering)Ordering.Int$.MODULE$);
        Series countsSeries = new Series("", counts, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.All(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$))));
        Series pieRequestsSeries = new Series(Series$.MODULE$.Distribution(), new .colon.colon((Object)new PieSlice(Series$.MODULE$.OK(), BoxesRunTime.unboxToDouble((Object)Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable((Iterable)counts), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.oks()), (Numeric)Numeric.DoubleIsFractional$.MODULE$))), (List)new .colon.colon((Object)new PieSlice(Series$.MODULE$.KO(), BoxesRunTime.unboxToDouble((Object)Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable((Iterable)counts), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.kos()), (Numeric)Numeric.DoubleIsFractional$.MODULE$))), (List)Nil$.MODULE$)), (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$)));
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)injectStart), countsSeries, pieRequestsSeries);
    }

    @Override
    public void generate() {
        Ranges ranges = this.logFileData.numberOfRequestInResponseTimeRanges((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        GlobalPageTemplate template = new GlobalPageTemplate(this.logFileData.runInfo(), this.rootContainer, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("Response Time Ranges", "requests", ranges, false), this.componentLibrary.getRequestCountPolarComponent(this.rootContainer), new SimulationCardComponent(this.logFileData.runInfo(), this.zoneId)})), new AssertionsTableComponent(this.assertionResults), new GlobalStatsTableComponent(this.rootContainer, this.configuration.indicators()), new ErrorsTableComponent(this.logFileData.errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)), this.activeSessionsChartComponent(this.logFileData), this.responseTimeDistributionChartComponent(this.logFileData), this.responseTimeChartComponent(this.logFileData), this.requestsChartComponent(this.logFileData), this.responsesChartComponent(this.logFileData)}));
        new TemplateWriter(this.chartsFiles.globalFile()).writeToFile(template.getOutput(), this.charset);
    }

    public GlobalReportGenerator(LogFileData logFileData, List<AssertionResult> assertionResults, GroupContainer rootContainer, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, ZoneId zoneId, Charset charset, ReportsConfiguration configuration) {
        this.logFileData = logFileData;
        this.assertionResults = assertionResults;
        this.rootContainer = rootContainer;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.zoneId = zoneId;
        this.charset = charset;
        this.configuration = configuration;
    }
}

