/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.DetailsStatsTableComponent;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.Series;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.template.DetailsPageTemplate;
import io.gatling.charts.util.Color;
import io.gatling.charts.util.Color$Requests$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]3Q!\u0003\u0006\u0001\u0019IA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b%\u0003A\u0011\u0001&\t\u000bI\u0003A\u0011A*\u00037\u001d\u0013x.\u001e9EKR\f\u0017\u000e\\:SKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0015\tYA\"\u0001\u0004sKB|'\u000f\u001e\u0006\u0003\u001b9\taa\u00195beR\u001c(BA\b\u0011\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!E\u0001\u0003S>\u001c2\u0001A\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011!dG\u0007\u0002\u0015%\u0011AD\u0003\u0002\u0010%\u0016\u0004xN\u001d;HK:,'/\u0019;pe\u0006YAn\\4GS2,G)\u0019;b\u0007\u0001\u0001\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0007\u0002\u000bM$\u0018\r^:\n\u0005\u0011\n#a\u0003'pO\u001aKG.\u001a#bi\u0006\fQB]8pi\u000e{g\u000e^1j]\u0016\u0014\bC\u0001\u000e(\u0013\tA#B\u0001\bHe>,\boQ8oi\u0006Lg.\u001a:\u0002\u0017\rD\u0017M\u001d;t\r&dWm\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[1\taaY8oM&<\u0017BA\u0018-\u0005-\u0019\u0005.\u0019:ug\u001aKG.Z:\u0002!\r|W\u000e]8oK:$H*\u001b2sCJL\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\r\u0003%\u0019w.\u001c9p]\u0016tG/\u0003\u00027g\t\u00012i\\7q_:,g\u000e\u001e'jEJ\f'/_\u0001\bG\"\f'o]3u!\tIt(D\u0001;\u0015\t94H\u0003\u0002={\u0005\u0019a.[8\u000b\u0003y\nAA[1wC&\u0011\u0001I\u000f\u0002\b\u0007\"\f'o]3u\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u00111iR\u0007\u0002\t*\u0011Q&\u0012\u0006\u0003\r:\tAaY8sK&\u0011\u0001\n\u0012\u0002\u0015%\u0016\u0004xN\u001d;t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u001dYE*\u0014(P!F\u0003\"A\u0007\u0001\t\u000bu9\u0001\u0019A\u0010\t\u000b\u0015:\u0001\u0019\u0001\u0014\t\u000b%:\u0001\u0019\u0001\u0016\t\u000bA:\u0001\u0019A\u0019\t\u000b]:\u0001\u0019\u0001\u001d\t\u000b\u0005;\u0001\u0019\u0001\"\u0002\u0011\u001d,g.\u001a:bi\u0016$\u0012\u0001\u0016\t\u0003)UK!AV\u000b\u0003\tUs\u0017\u000e\u001e")
public class GroupDetailsReportGenerator
implements ReportGenerator {
    private final LogFileData logFileData;
    private final GroupContainer rootContainer;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    @Override
    public void generate() {
        this.generateDetailPageRec$1(this.rootContainer.groups().values());
    }

    private final Component cumulatedResponseTimeChartComponent$1(GroupContainer groupContainer$1) {
        Iterable<PercentilesVsTimePlot> dataSuccess = this.logFileData.groupCumulatedResponseTimePercentilesOverTime((Status)OK$.MODULE$, groupContainer$1.group());
        Series<PercentilesVsTimePlot> seriesSuccess = new Series<PercentilesVsTimePlot>("Group Cumulated Response Time Percentiles over Time (OK)", dataSuccess, Color$Requests$.MODULE$.Percentiles());
        return this.componentLibrary.getPercentilesOverTimeComponent("Cumulated Response Time", this.logFileData.runInfo().injectStart(), seriesSuccess);
    }

    private final Component cumulatedResponseTimeDistributionChartComponent$1(GroupContainer groupContainer$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.logFileData.groupCumulatedResponseTimeDistribution(100, groupContainer$1.group());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq distributionSuccess = (Seq)tuple2._1();
        Seq distributionFailure = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distributionSuccess, (Object)distributionFailure);
        Seq distributionSuccess2 = (Seq)tuple22._1();
        Seq distributionFailure2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> distributionSeriesSuccess = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)distributionSuccess2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> distributionSeriesFailure = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)distributionFailure2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Group Cumulated Response Time", "Groups", distributionSeriesSuccess, distributionSeriesFailure);
    }

    private final Component durationChartComponent$1(GroupContainer groupContainer$1) {
        Iterable<PercentilesVsTimePlot> dataSuccess = this.logFileData.groupDurationPercentilesOverTime((Status)OK$.MODULE$, groupContainer$1.group());
        Series<PercentilesVsTimePlot> seriesSuccess = new Series<PercentilesVsTimePlot>("Group Duration Percentiles over Time (OK)", dataSuccess, Color$Requests$.MODULE$.Percentiles());
        return this.componentLibrary.getPercentilesOverTimeComponent("Duration", this.logFileData.runInfo().injectStart(), seriesSuccess);
    }

    private final Component durationDistributionChartComponent$1(GroupContainer groupContainer$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.logFileData.groupDurationDistribution(100, groupContainer$1.group());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq distributionSuccess = (Seq)tuple2._1();
        Seq distributionFailure = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distributionSuccess, (Object)distributionFailure);
        Seq distributionSuccess2 = (Seq)tuple22._1();
        Seq distributionFailure2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> distributionSeriesSuccess = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)distributionSuccess2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> distributionSeriesFailure = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)distributionFailure2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Group Duration", "Groups", distributionSeriesSuccess, distributionSeriesFailure);
    }

    private final void generateDetailPage$1(GroupContainer groupContainer) {
        Ranges ranges = this.logFileData.numberOfRequestInResponseTimeRanges((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)groupContainer.group()));
        String path = RequestPath$.MODULE$.path(groupContainer.group());
        DetailsPageTemplate template = new DetailsPageTemplate(this.logFileData.runInfo(), path, groupContainer, this.rootContainer, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("Group Duration Ranges", "groups", ranges, true), new DetailsStatsTableComponent(groupContainer.stats(), this.configuration.indicators())})), new ErrorsTableComponent(this.logFileData.errors((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)groupContainer.group()))), this.durationDistributionChartComponent$1(groupContainer), this.durationChartComponent$1(groupContainer), this.cumulatedResponseTimeDistributionChartComponent$1(groupContainer), this.cumulatedResponseTimeChartComponent$1(groupContainer)}));
        new TemplateWriter(this.chartsFiles.groupFile(path)).writeToFile(template.getOutput(), this.charset);
    }

    public static final /* synthetic */ void $anonfun$generate$1(GroupDetailsReportGenerator $this, GroupContainer groupContainer) {
        $this.generateDetailPage$1(groupContainer);
        $this.generateDetailPageRec$1(groupContainer.groups().values());
    }

    private final void generateDetailPageRec$1(Iterable groupContainers) {
        groupContainers.foreach((Function1 & Serializable)groupContainer -> {
            GroupDetailsReportGenerator.$anonfun$generate$1(this, groupContainer);
            return BoxedUnit.UNIT;
        });
    }

    public GroupDetailsReportGenerator(LogFileData logFileData, GroupContainer rootContainer, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, Charset charset, ReportsConfiguration configuration) {
        this.logFileData = logFileData;
        this.rootContainer = rootContainer;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.charset = charset;
        this.configuration = configuration;
    }
}

