/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.component.StatisticsTextComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportGenerator$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.Series;
import io.gatling.charts.template.GroupDetailsPageTemplate;
import io.gatling.charts.util.Colors$;
import io.gatling.charts.util.Colors$Blue$;
import io.gatling.charts.util.Colors$Red$;
import io.gatling.commons.shared.unstable.model.stats.Group;
import io.gatling.commons.shared.unstable.model.stats.GroupStatsPath;
import io.gatling.commons.shared.unstable.model.stats.StatsPath;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00013Qa\u0002\u0005\u0001\u0015AA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\t5\u0001\u0011\t\u0011)A\u00057!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005)\u0001\t\u0005\t\u0015a\u0003*\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015A\u0004\u0001\"\u0001:\u0005m9%o\\;q\t\u0016$\u0018-\u001b7t%\u0016\u0004xN\u001d;HK:,'/\u0019;pe*\u0011\u0011BC\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u0005-a\u0011AB2iCJ$8O\u0003\u0002\u000e\u001d\u00059q-\u0019;mS:<'\"A\b\u0002\u0005%|7C\u0001\u0001\u0012!\t\u00112#D\u0001\t\u0013\t!\u0002BA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003]\u0011X\r]8siN<UM\\3sCRLwN\\%oaV$8o\u0001\u0001\u0011\u0005IA\u0012BA\r\t\u0005]\u0011V\r]8siN<UM\\3sCRLwN\\%oaV$8/A\u0006dQ\u0006\u0014Ho\u001d$jY\u0016\u001c\bC\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u000b\u0003\u0019\u0019wN\u001c4jO&\u0011\u0001%\b\u0002\f\u0007\"\f'\u000f^:GS2,7/\u0001\td_6\u0004xN\\3oi2K'M]1ssB\u00111EJ\u0007\u0002I)\u0011QEC\u0001\nG>l\u0007o\u001c8f]RL!a\n\u0013\u0003!\r{W\u000e]8oK:$H*\u001b2sCJL\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002+]5\t1F\u0003\u0002\u001fY)\u0011Q\u0006D\u0001\u0005G>\u0014X-\u0003\u00020W\t!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtD\u0003\u0002\u001a6m]\"\"a\r\u001b\u0011\u0005I\u0001\u0001\"\u0002\u0015\u0006\u0001\bI\u0003\"B\u000b\u0006\u0001\u00049\u0002\"\u0002\u000e\u0006\u0001\u0004Y\u0002\"B\u0011\u0006\u0001\u0004\u0011\u0013\u0001C4f]\u0016\u0014\u0018\r^3\u0015\u0003i\u0002\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012A!\u00168ji\u0002")
public class GroupDetailsReportGenerator
extends ReportGenerator {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final GatlingConfiguration configuration;

    @Override
    public void generate() {
        this.reportsGenerationInputs.logFileReader().statsPaths().foreach((Function1 & Serializable)x0$1 -> {
            GroupDetailsReportGenerator.$anonfun$generate$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final Component cumulatedResponseTimeChartComponent$1(Group group$1) {
        Iterable<PercentilesVsTimePlot> dataSuccess = this.reportsGenerationInputs.logFileReader().groupCumulatedResponseTimePercentilesOverTime((Status)OK$.MODULE$, group$1);
        Series<PercentilesVsTimePlot> seriesSuccess = new Series<PercentilesVsTimePlot>("Group Cumulated Response Time Percentiles over Time (success)", dataSuccess, ReportGenerator$.MODULE$.PercentilesColors());
        return this.componentLibrary.getGroupDetailsDurationChartComponent("cumulatedResponseTimeChartContainer", "Cumulated Response Time (ms)", this.reportsGenerationInputs.logFileReader().runStart(), seriesSuccess);
    }

    private final Component cumulatedResponseTimeDistributionChartComponent$1(Group group$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileReader().groupCumulatedResponseTimeDistribution(100, group$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq distributionSuccess = (Seq)tuple2._1();
        Seq distributionFailure = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distributionSuccess, (Object)distributionFailure);
        Tuple2 tuple23 = tuple22;
        Seq distributionSuccess2 = (Seq)tuple23._1();
        Seq distributionFailure2 = (Seq)tuple23._2();
        Series<PercentVsTimePlot> distributionSeriesSuccess = new Series<PercentVsTimePlot>("Group cumulated response time (success)", (Iterable<PercentVsTimePlot>)distributionSuccess2, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Blue$.MODULE$)}))));
        Series<PercentVsTimePlot> distributionSeriesFailure = new Series<PercentVsTimePlot>("Group cumulated response time (failure)", (Iterable<PercentVsTimePlot>)distributionFailure2, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Red$.MODULE$)}))));
        return this.componentLibrary.getGroupDetailsDurationDistributionChartComponent("Group Cumulated Response Time Distribution", "cumulatedResponseTimeDistributionContainer", distributionSeriesSuccess, distributionSeriesFailure);
    }

    private final Component durationChartComponent$1(Group group$1) {
        Iterable<PercentilesVsTimePlot> dataSuccess = this.reportsGenerationInputs.logFileReader().groupDurationPercentilesOverTime((Status)OK$.MODULE$, group$1);
        Series<PercentilesVsTimePlot> seriesSuccess = new Series<PercentilesVsTimePlot>("Group Duration Percentiles over Time (success)", dataSuccess, ReportGenerator$.MODULE$.PercentilesColors());
        return this.componentLibrary.getGroupDetailsDurationChartComponent("durationContainer", "Duration (ms)", this.reportsGenerationInputs.logFileReader().runStart(), seriesSuccess);
    }

    private final Component durationDistributionChartComponent$1(Group group$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileReader().groupDurationDistribution(100, group$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq distributionSuccess = (Seq)tuple2._1();
        Seq distributionFailure = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distributionSuccess, (Object)distributionFailure);
        Tuple2 tuple23 = tuple22;
        Seq distributionSuccess2 = (Seq)tuple23._1();
        Seq distributionFailure2 = (Seq)tuple23._2();
        Series<PercentVsTimePlot> distributionSeriesSuccess = new Series<PercentVsTimePlot>("Group duration (success)", (Iterable<PercentVsTimePlot>)distributionSuccess2, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Blue$.MODULE$)}))));
        Series<PercentVsTimePlot> distributionSeriesFailure = new Series<PercentVsTimePlot>("Group duration (failure)", (Iterable<PercentVsTimePlot>)distributionFailure2, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Red$.MODULE$)}))));
        return this.componentLibrary.getGroupDetailsDurationDistributionChartComponent("Group Duration Distribution", "durationDistributionContainer", distributionSeriesSuccess, distributionSeriesFailure);
    }

    private final Component statisticsComponent$1() {
        return new StatisticsTextComponent(this.configuration);
    }

    private final Component indicatorChartComponent$1() {
        return this.componentLibrary.getRequestDetailsIndicatorChartComponent();
    }

    private final void generateDetailPage$1(String path, Group group) {
        GroupDetailsPageTemplate template = new GroupDetailsPageTemplate(group, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.statisticsComponent$1(), this.indicatorChartComponent$1(), new ErrorsTableComponent(this.reportsGenerationInputs.logFileReader().errors((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group))), this.cumulatedResponseTimeChartComponent$1(group), this.cumulatedResponseTimeDistributionChartComponent$1(group), this.durationChartComponent$1(group), this.durationDistributionChartComponent$1(group)}));
        new TemplateWriter(this.chartsFiles.groupFile(path)).writeToFile(template.getOutput(this.configuration.core().charset()), this.configuration);
    }

    public static final /* synthetic */ void $anonfun$generate$1(GroupDetailsReportGenerator $this, StatsPath x0$1) {
        StatsPath statsPath = x0$1;
        if (statsPath instanceof GroupStatsPath) {
            GroupStatsPath groupStatsPath = (GroupStatsPath)statsPath;
            Group group = groupStatsPath.group();
            $this.generateDetailPage$1(RequestPath$.MODULE$.path(group), group);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public GroupDetailsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, GatlingConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.configuration = configuration;
    }
}

