/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.GroupedCount;
import io.gatling.charts.component.RequestStatistics;
import io.gatling.charts.component.Stats;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.GroupContainer$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.template.ConsoleTemplate$;
import io.gatling.charts.template.GlobalStatsJsonTemplate;
import io.gatling.charts.template.StatsJsTemplate;
import io.gatling.commons.shared.unstable.model.stats.GeneralStats;
import io.gatling.commons.shared.unstable.model.stats.Group;
import io.gatling.commons.shared.unstable.model.stats.GroupStatsPath;
import io.gatling.commons.shared.unstable.model.stats.RequestStatsPath;
import io.gatling.commons.shared.unstable.model.stats.StatsPath;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.NumberHelper;
import io.gatling.commons.util.NumberHelper$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005)3Qa\u0002\u0005\u0001\u0015AA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00056\u0001\t\u0005\t\u0015a\u00037\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015)\u0005\u0001\"\u0001G\u0005Q\u0019F/\u0019;t%\u0016\u0004xN\u001d;HK:,'/\u0019;pe*\u0011\u0011BC\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u0005-a\u0011AB2iCJ$8O\u0003\u0002\u000e\u001d\u00059q-\u0019;mS:<'\"A\b\u0002\u0005%|7c\u0001\u0001\u0012/A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\u0010\u000e\u0003eQ!AG\u000e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005qi\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003y\t1aY8n\u0013\t\u0001\u0013DA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0018e\u0016\u0004xN\u001d;t\u000f\u0016tWM]1uS>t\u0017J\u001c9viN\u001c\u0001\u0001\u0005\u0002%K5\t\u0001\"\u0003\u0002'\u0011\t9\"+\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8J]B,Ho]\u0001\fG\"\f'\u000f^:GS2,7\u000f\u0005\u0002*Y5\t!F\u0003\u0002,\u0015\u000511m\u001c8gS\u001eL!!\f\u0016\u0003\u0017\rC\u0017M\u001d;t\r&dWm]\u0001\u0011G>l\u0007o\u001c8f]Rd\u0015N\u0019:bef\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0006\u0002\u0013\r|W\u000e]8oK:$\u0018B\u0001\u001b2\u0005A\u0019u.\u001c9p]\u0016tG\u000fT5ce\u0006\u0014\u00180A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003omj\u0011\u0001\u000f\u0006\u0003WeR!A\u000f\u0007\u0002\t\r|'/Z\u0005\u0003ya\u0012AcR1uY&twmQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0003@\u0005\u000e#EC\u0001!B!\t!\u0003\u0001C\u00036\u000b\u0001\u000fa\u0007C\u0003\"\u000b\u0001\u00071\u0005C\u0003(\u000b\u0001\u0007\u0001\u0006C\u0003/\u000b\u0001\u0007q&\u0001\u0005hK:,'/\u0019;f)\u00059\u0005C\u0001\nI\u0013\tI5C\u0001\u0003V]&$\b")
public class StatsReportGenerator
implements StrictLogging {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void generate() {
        GroupContainer rootContainer = GroupContainer$.MODULE$.root(this.computeRequestStats$1(ChartsFiles$.MODULE$.AllRequestLineTitle(), (Option)None$.MODULE$, (Option)None$.MODULE$));
        List<StatsPath> statsPaths = this.reportsGenerationInputs.logFileData().statsPaths();
        Map groupsByHierarchy = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                Option option;
                Object object;
                A1 A1 = x1;
                if (A1 instanceof GroupStatsPath) {
                    Group group;
                    GroupStatsPath groupStatsPath = (GroupStatsPath)A1;
                    object = group = groupStatsPath.group();
                } else if (A1 instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)A1).group()) instanceof Some) {
                    Group group;
                    Some some = (Some)option;
                    object = group = (Group)some.value();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(StatsPath x1) {
                RequestStatsPath requestStatsPath;
                Option option;
                StatsPath statsPath = x1;
                boolean bl = statsPath instanceof GroupStatsPath ? true : statsPath instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)statsPath).group()) instanceof Some;
                return bl;
            }
        }).map((Function1 & Serializable)group -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group.hierarchy().reverse()), group)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashSet seenGroups = HashSet$.MODULE$.empty();
        List requestStatsPaths = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                A1 A1 = x2;
                Object object = A1 instanceof RequestStatsPath ? (requestStatsPath = (RequestStatsPath)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(StatsPath x2) {
                StatsPath statsPath = x2;
                boolean bl = statsPath instanceof RequestStatsPath;
                return bl;
            }
        });
        requestStatsPaths.foreach((Function1 & Serializable)x0$1 -> {
            StatsReportGenerator.$anonfun$generate$13(this, rootContainer, seenGroups, groupsByHierarchy, x0$1);
            return BoxedUnit.UNIT;
        });
        new TemplateWriter(this.chartsFiles.statsJsFile()).writeToFile(new StatsJsTemplate(rootContainer, false).getOutput(this.configuration.core().charset()), this.configuration);
        new TemplateWriter(this.chartsFiles.statsJsonFile()).writeToFile(new StatsJsTemplate(rootContainer, true).getOutput(this.configuration.core().charset()), this.configuration);
        new TemplateWriter(this.chartsFiles.globalStatsJsonFile()).writeToFile(new GlobalStatsJsonTemplate(rootContainer.stats(), true).getOutput(), this.configuration);
        Predef$.MODULE$.println((Object)ConsoleTemplate$.MODULE$.println(rootContainer.stats(), this.reportsGenerationInputs.logFileData().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)));
    }

    private static final Stats percentiles$1(double rank, Function1 title, GeneralStats total, GeneralStats ok, GeneralStats ko) {
        return new Stats<Integer>((String)title.apply((Object)BoxesRunTime.boxToDouble((double)rank)), BoxesRunTime.boxToInteger((int)total.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ok.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ko.percentile().apply$mcID$sp(rank)), (Numeric<Integer>)Numeric.IntIsIntegral$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$generate$1(double rank) {
        return new StringBuilder(25).append("response time ").append(NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(rank))).append(" percentile").toString();
    }

    private final RequestStatistics computeRequestStats$1(String name, Option requestName, Option group2) {
        String string;
        GeneralStats total = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)None$.MODULE$);
        GeneralStats ok = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)OK$.MODULE$));
        GeneralStats ko = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)KO$.MODULE$));
        Stats<Object> numberOfRequestsStatistics = new Stats<Object>("request count", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
        Stats<Object> minResponseTimeStatistics = new Stats<Object>("min response time", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> maxResponseTimeStatistics = new Stats<Object>("max response time", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> meanResponseTimeStatistics = new Stats<Object>("mean response time", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> stdDeviationStatistics = new Stats<Object>("std deviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Function1 & Serializable percentilesTitle = (Function1 & Serializable)rank -> StatsReportGenerator.$anonfun$generate$1(BoxesRunTime.unboxToDouble((Object)rank));
        Stats percentiles1 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile1(), percentilesTitle, total, ok, ko);
        Stats percentiles2 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile2(), percentilesTitle, total, ok, ko);
        Stats percentiles3 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile3(), percentilesTitle, total, ok, ko);
        Stats percentiles4 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile4(), percentilesTitle, total, ok, ko);
        Stats<Object> meanNumberOfRequestsPerSecondStatistics = new Stats<Object>("mean requests/sec", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$);
        Seq groupedCounts = (Seq)this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRange((Option<String>)requestName, (Option<Group>)group2).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rangeName = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            GroupedCount groupedCount = new GroupedCount(rangeName, count, total.count());
            return groupedCount;
        });
        Option option = requestName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String n = (String)some.value();
            string = RequestPath$.MODULE$.path(n, (Option<Group>)group2);
        } else if (None$.MODULE$.equals(option)) {
            string = (String)group2.map((Function1 & Serializable)group -> RequestPath$.MODULE$.path((Group)group)).getOrElse((Function0 & Serializable)() -> "");
        } else {
            throw new MatchError((Object)option);
        }
        String path = string;
        return new RequestStatistics(name, path, numberOfRequestsStatistics, minResponseTimeStatistics, maxResponseTimeStatistics, meanResponseTimeStatistics, stdDeviationStatistics, percentiles1, percentiles2, percentiles3, percentiles4, (Seq<GroupedCount>)groupedCounts, meanNumberOfRequestsPerSecondStatistics);
    }

    private final Function2 groupStatsFunction$1() {
        Function2 & Serializable intersect;
        if (this.configuration.charting().useGroupDurationMetric()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group duration stats.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            intersect = (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupDurationGeneralStats((Group)group, (Option<Status>)status);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group cumulated response time stats.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            intersect = (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupCumulatedResponseTimeGeneralStats((Group)group, (Option<Status>)status);
        }
        return intersect;
    }

    public static final /* synthetic */ String $anonfun$generate$7(double x$1) {
        return "percentiles1";
    }

    public static final /* synthetic */ String $anonfun$generate$8(double x$2) {
        return "percentiles2";
    }

    public static final /* synthetic */ String $anonfun$generate$9(double x$3) {
        return "percentiles3";
    }

    public static final /* synthetic */ String $anonfun$generate$10(double x$4) {
        return "percentiles4";
    }

    private final RequestStatistics computeGroupStats$1(String name, Group group) {
        GeneralStats total = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)None$.MODULE$);
        GeneralStats ok = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)OK$.MODULE$));
        GeneralStats ko = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)KO$.MODULE$));
        Stats<Object> numberOfRequestsStatistics = new Stats<Object>("numberOfRequests", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
        Stats<Object> minResponseTimeStatistics = new Stats<Object>("minResponseTime", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> maxResponseTimeStatistics = new Stats<Object>("maxResponseTime", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> meanResponseTimeStatistics = new Stats<Object>("meanResponseTime", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats<Object> stdDeviationStatistics = new Stats<Object>("stdDeviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$);
        Stats percentiles1 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile1(), (Function1 & Serializable)x$1 -> StatsReportGenerator.$anonfun$generate$7(BoxesRunTime.unboxToDouble((Object)x$1)), total, ok, ko);
        Stats percentiles2 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile2(), (Function1 & Serializable)x$2 -> StatsReportGenerator.$anonfun$generate$8(BoxesRunTime.unboxToDouble((Object)x$2)), total, ok, ko);
        Stats percentiles3 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile3(), (Function1 & Serializable)x$3 -> StatsReportGenerator.$anonfun$generate$9(BoxesRunTime.unboxToDouble((Object)x$3)), total, ok, ko);
        Stats percentiles4 = StatsReportGenerator.percentiles$1(this.configuration.charting().indicators().percentile4(), (Function1 & Serializable)x$4 -> StatsReportGenerator.$anonfun$generate$10(BoxesRunTime.unboxToDouble((Object)x$4)), total, ok, ko);
        Stats<Object> meanNumberOfRequestsPerSecondStatistics = new Stats<Object>("meanNumberOfRequestsPerSecond", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$);
        Seq groupedCounts = (Seq)this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRange((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rangeName = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            GroupedCount groupedCount = new GroupedCount(rangeName, count, total.count());
            return groupedCount;
        });
        String path = RequestPath$.MODULE$.path(group);
        return new RequestStatistics(name, path, numberOfRequestsStatistics, minResponseTimeStatistics, maxResponseTimeStatistics, meanResponseTimeStatistics, stdDeviationStatistics, percentiles1, percentiles2, percentiles3, percentiles4, (Seq<GroupedCount>)groupedCounts, meanNumberOfRequestsPerSecondStatistics);
    }

    private final void addGroupsRec$1(List hierarchy, HashSet seenGroups$1, Map groupsByHierarchy$1, GroupContainer rootContainer$1) {
        block2: {
            .colon.colon colon2;
            List tail;
            if (seenGroups$1.contains((Object)hierarchy)) break block2;
            seenGroups$1.$plus$eq((Object)hierarchy);
            List list = hierarchy;
            if (list instanceof .colon.colon && (tail = (colon2 = (.colon.colon)list).next$access$1()).nonEmpty()) {
                this.addGroupsRec$1(tail, seenGroups$1, groupsByHierarchy$1, rootContainer$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Group group = (Group)groupsByHierarchy$1.apply((Object)hierarchy);
            RequestStatistics stats = this.computeGroupStats$1(group.name(), group);
            rootContainer$1.addGroup(group, stats);
        }
    }

    public static final /* synthetic */ void $anonfun$generate$13(StatsReportGenerator $this, GroupContainer rootContainer$1, HashSet seenGroups$1, Map groupsByHierarchy$1, RequestStatsPath x0$1) {
        RequestStatsPath requestStatsPath = x0$1;
        if (requestStatsPath == null) {
            throw new MatchError((Object)requestStatsPath);
        }
        String request = requestStatsPath.request();
        Option group2 = requestStatsPath.group();
        group2.foreach((Function1 & Serializable)group -> {
            $this.addGroupsRec$1(group.hierarchy().reverse(), seenGroups$1, groupsByHierarchy$1, rootContainer$1);
            return BoxedUnit.UNIT;
        });
        RequestStatistics stats = $this.computeRequestStats$1(request, (Option)new Some((Object)request), group2);
        rootContainer$1.addRequest((Option<Group>)group2, request, stats);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StatsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, GatlingConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

