/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.commons.util;

import io.gatling.commons.util.ReusableGzipOutputStream$;
import io.gatling.commons.util.SettableOutputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import scala.Array$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055q!B\f\u0019\u0011\u0003\tc!B\u0012\u0019\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0005\u0004%IA\f\u0005\u0007e\u0005\u0001\u000b\u0011B\u0018\t\u000fM\n!\u0019!C\u0005]!1A'\u0001Q\u0001\n=Bq!N\u0001C\u0002\u0013%a\u0007\u0003\u0004}\u0003\u0001\u0006Ia\u000e\u0005\u0006{\u0006!\tA \u0004\u0005Ga\u0001\u0001\t\u0003\u0005I\u0015\t\u0015\r\u0011\"\u0001J\u0011!i%B!A!\u0002\u0013Q\u0005\"B\u0016\u000b\t\u0003q\u0005b\u0002)\u000b\u0005\u0004%I!\u0015\u0005\u0007+*\u0001\u000b\u0011\u0002*\t\u000bYSA\u0011I,\t\u000b\u001dTA\u0011\t5\t\u000b%TA\u0011\u00015\t\u000b)TA\u0011B6\t\u000b=TA\u0011\u00029\t\u000bUTA\u0011\u0002<\t\u000bmTA\u0011\u00015\u00021I+Wo]1cY\u0016<%0\u001b9PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u001a5\u0005!Q\u000f^5m\u0015\tYB$A\u0004d_6lwN\\:\u000b\u0005uq\u0012aB4bi2Lgn\u001a\u0006\u0002?\u0005\u0011\u0011n\\\u0002\u0001!\t\u0011\u0013!D\u0001\u0019\u0005a\u0011V-^:bE2,wI_5q\u001fV$\b/\u001e;TiJ,\u0017-\\\n\u0003\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\"\u0003%9%0\u001b9NC\u001eL7-F\u00010!\t1\u0003'\u0003\u00022O\t\u0019\u0011J\u001c;\u0002\u0015\u001dS\u0018\u000e]'bO&\u001c\u0007%A\u0006Ue\u0006LG.\u001a:TSj,\u0017\u0001\u0004+sC&dWM]*ju\u0016\u0004\u0013aB*ue\u0016\fWn]\u000b\u0002oA\u0019\u0001(P \u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014HA\u0006UQJ,\u0017\r\u001a'pG\u0006d\u0007C\u0001\u0012\u000b'\tQ\u0011\t\u0005\u0002C\r6\t1I\u0003\u0002E\u000b\u0006\u0019!0\u001b9\u000b\u0005eY\u0014BA$D\u0005Q!UM\u001a7bi\u0016\u0014x*\u001e;qkR\u001cFO]3b[\u0006\u0011qn]\u000b\u0002\u0015B\u0011!eS\u0005\u0003\u0019b\u0011AcU3ui\u0006\u0014G.Z(viB,Ho\u0015;sK\u0006l\u0017aA8tAQ\u0011qh\u0014\u0005\u0006\u00116\u0001\rAS\u0001\u0004GJ\u001cW#\u0001*\u0011\u0005\t\u001b\u0016B\u0001+D\u0005\u0015\u0019%kQ\u001a3\u0003\u0011\u0019'o\u0019\u0011\u0002\u000b]\u0014\u0018\u000e^3\u0015\ta[6-\u001a\t\u0003MeK!AW\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u00069B\u0001\r!X\u0001\u0004EV4\u0007c\u0001\u0014_A&\u0011ql\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003M\u0005L!AY\u0014\u0003\t\tKH/\u001a\u0005\u0006IB\u0001\raL\u0001\u0004_\u001a4\u0007\"\u00024\u0011\u0001\u0004y\u0013a\u00017f]\u00061a-\u001b8jg\"$\u0012\u0001W\u0001\foJLG/\u001a%fC\u0012,'/\u0001\u0007xe&$X\r\u0016:bS2,'\u000fF\u0002YY6DQ\u0001X\nA\u0002uCQA\\\nA\u0002=\naa\u001c4gg\u0016$\u0018\u0001C<sSR,\u0017J\u001c;\u0015\ta\u000b8\u000f\u001e\u0005\u0006eR\u0001\raL\u0001\u0002S\")A\f\u0006a\u0001;\")a\u000e\u0006a\u0001_\u0005QqO]5uKNCwN\u001d;\u0015\ta;\u0018P\u001f\u0005\u0006qV\u0001\raL\u0001\u0002g\")A,\u0006a\u0001;\")a.\u0006a\u0001_\u0005)!/Z:fi\u0006A1\u000b\u001e:fC6\u001c\b%A\u0005g_J\u001cFO]3b[R\u0011qh \u0005\b\u0003\u0003I\u0001\u0019AA\u0002\u0003\u0019!\u0018M]4fiB!\u0011QAA\u0005\u001b\t\t9A\u0003\u0002 w%!\u00111BA\u0004\u00051yU\u000f\u001e9viN#(/Z1n\u0001")
public class ReusableGzipOutputStream
extends DeflaterOutputStream {
    private final SettableOutputStream os;
    private final CRC32 crc;

    public static ReusableGzipOutputStream forStream(OutputStream outputStream) {
        return ReusableGzipOutputStream$.MODULE$.forStream(outputStream);
    }

    public SettableOutputStream os() {
        return this.os;
    }

    private CRC32 crc() {
        return this.crc;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        this.crc().update(buf, off, len);
    }

    @Override
    public void finish() {
        block2: {
            if (this.def.finished()) break block2;
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && len <= this.buf.length - ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$TrailerSize()) {
                    this.writeTrailer(this.buf, len);
                    this.os().write(this.buf, 0, len += ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$TrailerSize());
                    return;
                }
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
            byte[] trailer = (byte[])Array$.MODULE$.ofDim(ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$TrailerSize(), ClassTag$.MODULE$.Byte());
            this.writeTrailer(trailer, 0);
            this.out.write(trailer);
        }
    }

    public void writeHeader() {
        this.os().write(new byte[]{(byte)ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$GzipMagic(), (byte)(ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$GzipMagic() >> 8), (byte)8, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0});
    }

    private void writeTrailer(byte[] buf, int offset) {
        this.writeInt((int)this.crc().getValue(), buf, offset);
        this.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private void writeInt(int i, byte[] buf, int offset) {
        this.writeShort(i & 0xFFFF, buf, offset);
        this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private void writeShort(int s, byte[] buf, int offset) {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
    }

    public void reset() {
        this.crc().reset();
        this.def.reset();
        this.os().target_$eq(null);
    }

    public ReusableGzipOutputStream(SettableOutputStream os) {
        this.os = os;
        super((OutputStream)os, new Deflater(-1, true));
        this.crc = new CRC32();
    }
}

