/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.compiler.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.gatling.compiler.config.CompilerConfiguration;
import io.gatling.compiler.config.ConfigUtils$;
import io.gatling.compiler.config.cli.ArgsParser;
import io.gatling.compiler.config.cli.CommandLineOverrides;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class CompilerConfiguration$
implements Serializable {
    public static final CompilerConfiguration$ MODULE$ = new CompilerConfiguration$();
    private static final String encodingKey = "gatling.core.encoding";
    private static final String simulationsDirectoryKey = "gatling.core.directory.simulations";
    private static final String binariesDirectoryKey = "gatling.core.directory.binaries";

    private String encodingKey() {
        return encodingKey;
    }

    private String simulationsDirectoryKey() {
        return simulationsDirectoryKey;
    }

    private String binariesDirectoryKey() {
        return binariesDirectoryKey;
    }

    public CompilerConfiguration configuration(String[] args) {
        ArgsParser argsParser = new ArgsParser(args);
        CommandLineOverrides commandLineOverrides = argsParser.parseArguments();
        Config cliConfig = ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)CompilerConfiguration$.buildConfigurationMap$1(commandLineOverrides)).asJava());
        Config customConfig = ConfigFactory.load((String)"gatling.conf");
        Config defaultConfig = ConfigFactory.load((String)"gatling-defaults.conf");
        Config config = cliConfig.withFallback((ConfigMergeable)customConfig.withFallback((ConfigMergeable)defaultConfig));
        String encoding = config.getString(this.encodingKey());
        Path simulationsDirectory = (Path)ConfigUtils$.MODULE$.string2option(config.getString(this.simulationsDirectoryKey())).fold((Function0 & Serializable)() -> ConfigUtils$.MODULE$.GatlingHome().resolve("user-files").resolve("simulations"), (Function1 & Serializable)path -> ConfigUtils$.MODULE$.resolvePath(Paths.get(path, new String[0])));
        Path binariesDirectory = (Path)ConfigUtils$.MODULE$.string2option(config.getString(this.binariesDirectoryKey())).fold((Function0 & Serializable)() -> ConfigUtils$.MODULE$.GatlingHome().resolve("target").resolve("test-classes"), (Function1 & Serializable)path -> ConfigUtils$.MODULE$.resolvePath(Paths.get(path, new String[0])));
        Seq extraScalacOptions = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(commandLineOverrides.extraScalacOptions()), ',')), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1))))));
        Seq extraJavacOptions = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(commandLineOverrides.extraJavacOptions()), ',')), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))))));
        return new CompilerConfiguration(encoding, simulationsDirectory, binariesDirectory, (Seq<String>)extraScalacOptions, (Seq<String>)extraJavacOptions);
    }

    public CompilerConfiguration apply(String encoding, Path simulationsDirectory, Path binariesDirectory, Seq<String> extraScalacOptions, Seq<String> extraJavacOptions) {
        return new CompilerConfiguration(encoding, simulationsDirectory, binariesDirectory, extraScalacOptions, extraJavacOptions);
    }

    public Option<Tuple5<String, Path, Path, Seq<String>, Seq<String>>> unapply(CompilerConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.encoding(), (Object)x$0.simulationsDirectory(), (Object)x$0.binariesDirectory(), x$0.extraScalacOptions(), x$0.extraJavacOptions()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CompilerConfiguration$.class);
    }

    private static final scala.collection.immutable.Map buildConfigurationMap$1(CommandLineOverrides overrides) {
        scala.collection.immutable.Map mapForSimulationFolder = (scala.collection.immutable.Map)ConfigUtils$.MODULE$.string2option(overrides.simulationsDirectory()).map((Function1 & Serializable)v -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.simulationsDirectoryKey()), v)}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Map mapForBinariesFolder = (scala.collection.immutable.Map)ConfigUtils$.MODULE$.string2option(overrides.binariesFolder()).map((Function1 & Serializable)v -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.binariesDirectoryKey()), v)}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        return (scala.collection.immutable.Map)mapForSimulationFolder.$plus$plus((IterableOnce)mapForBinariesFolder);
    }

    private CompilerConfiguration$() {
    }
}

