/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import com.fasterxml.jackson.databind.JsonNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.core.Predef;
import io.gatling.core.body.BodyProcessors;
import io.gatling.core.body.BodyWithBytesExpression;
import io.gatling.core.body.ElFileBodies;
import io.gatling.core.body.PebbleFileBodies;
import io.gatling.core.body.RawFileBodies;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.css.CssCheckType;
import io.gatling.core.check.css.CssSelectors;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jmespath.JmesPaths;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.jsonpath.JsonPaths;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckType;
import io.gatling.core.check.regex.Patterns;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.core.check.xpath.XmlParsers;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.throttle.Hold;
import io.gatling.core.controller.throttle.Jump;
import io.gatling.javaapi.core.Assertion;
import io.gatling.javaapi.core.Body;
import io.gatling.javaapi.core.ChainBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Choice;
import io.gatling.javaapi.core.ClosedInjectionStep;
import io.gatling.javaapi.core.DeploymentInfo;
import io.gatling.javaapi.core.FeederBuilder;
import io.gatling.javaapi.core.Filter;
import io.gatling.javaapi.core.OpenInjectionStep;
import io.gatling.javaapi.core.PauseType;
import io.gatling.javaapi.core.ScenarioBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.ThrottleStep;
import io.gatling.javaapi.core.condition.DoIf;
import io.gatling.javaapi.core.condition.DoIfEquals;
import io.gatling.javaapi.core.condition.DoIfEqualsOrElse;
import io.gatling.javaapi.core.condition.DoIfOrElse;
import io.gatling.javaapi.core.condition.DoSwitch;
import io.gatling.javaapi.core.condition.DoSwitchOrElse;
import io.gatling.javaapi.core.condition.RandomSwitch;
import io.gatling.javaapi.core.condition.RandomSwitchOrElse;
import io.gatling.javaapi.core.condition.RoundRobinSwitch;
import io.gatling.javaapi.core.condition.UniformRandomSwitch;
import io.gatling.javaapi.core.error.Errors;
import io.gatling.javaapi.core.exec.Executable;
import io.gatling.javaapi.core.group.Groups;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.CoreCheckBuilders;
import io.gatling.javaapi.core.internal.CoreCheckType;
import io.gatling.javaapi.core.internal.Executables;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.core.loop.AsLongAs;
import io.gatling.javaapi.core.loop.AsLongAsDuring;
import io.gatling.javaapi.core.loop.DoWhile;
import io.gatling.javaapi.core.loop.DoWhileDuring;
import io.gatling.javaapi.core.loop.During;
import io.gatling.javaapi.core.loop.ForEach;
import io.gatling.javaapi.core.loop.Forever;
import io.gatling.javaapi.core.loop.Repeat;
import io.pebbletemplates.pebble.extension.Extension;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jodd.lagarto.dom.NodeSelector;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;

public final class CoreDsl {
    public static final DeploymentInfo deploymentInfo = DeploymentInfo.INSTANCE;
    public static PauseType disabledPauses = PauseType.Disabled;
    public static PauseType constantPauses = PauseType.Constant;
    public static PauseType exponentialPauses = PauseType.Exponential;
    public static final Function<Body, Body.WithBytes> gzipBody = body -> new Body.WithBytes((BodyWithBytesExpression)BodyProcessors.gzip().apply((Object)body.asScala()));

    private CoreDsl() {
    }

    @NonNull
    public static ScenarioBuilder scenario(@NonNull String string) {
        return new ScenarioBuilder(string);
    }

    @NonNull
    public static Filter.AllowList AllowList(String ... stringArray) {
        return CoreDsl.AllowList(Arrays.asList(stringArray));
    }

    @NonNull
    public static Filter.AllowList AllowList(@NonNull List<String> list) {
        return new Filter.AllowList(list);
    }

    @NonNull
    public static Filter.DenyList DenyList(String ... stringArray) {
        return CoreDsl.DenyList(Arrays.asList(stringArray));
    }

    @NonNull
    public static Filter.DenyList DenyList(@NonNull List<String> list) {
        return new Filter.DenyList(list);
    }

    @NonNull
    public static ChainBuilder exec(@NonNull Function<Session, Session> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(function);
    }

    @NonNull
    public static ChainBuilder exec(@NonNull Executable executable, Executable ... executableArray) {
        return CoreDsl.exec(Executables.toChainBuilders(executable, executableArray));
    }

    @NonNull
    public static ChainBuilder exec(@NonNull List<ChainBuilder> list) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(list);
    }

    @NonNull
    public static ChainBuilder pause(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l);
    }

    @NonNull
    public static ChainBuilder pause(long l, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, pauseType);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Duration duration, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, pauseType);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull String string, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, pauseType);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Function<Session, Duration> function, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, pauseType);
    }

    @NonNull
    public static ChainBuilder pause(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2);
    }

    @NonNull
    public static ChainBuilder pause(long l, long l2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2, pauseType);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Duration duration, @NonNull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Duration duration, @NonNull Duration duration2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2, pauseType);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull String string, @NonNull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull String string, @NonNull String string2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2, pauseType);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Function<Session, Duration> function, @NonNull Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2);
    }

    @NonNull
    public static ChainBuilder pause(@NonNull Function<Session, Duration> function, @NonNull Function<Session, Duration> function2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2, pauseType);
    }

    @NonNull
    public static ChainBuilder pace(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l);
    }

    @NonNull
    public static ChainBuilder pace(long l, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, string);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Duration duration, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, string);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull String string, @NonNull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Function<Session, Duration> function, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, string);
    }

    @NonNull
    public static ChainBuilder pace(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2);
    }

    @NonNull
    public static ChainBuilder pace(long l, long l2, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2, string);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Duration duration, @NonNull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Duration duration, @NonNull Duration duration2, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2, string);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2, string3);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Function<Session, Duration> function, Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2);
    }

    @NonNull
    public static ChainBuilder pace(@NonNull Function<Session, Duration> function, @NonNull Function<Session, Duration> function2, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2, string);
    }

    @NonNull
    public static ChainBuilder rendezVous(int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.rendezVous(n);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, n);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, string);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, function);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, n);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, string);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, function);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, n);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, string);
    }

    @NonNull
    public static ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, function);
    }

    @NonNull
    public static Repeat.On<ChainBuilder> repeat(int n) {
        return ChainBuilder.EMPTY.repeat(n);
    }

    @NonNull
    public static Repeat.On<ChainBuilder> repeat(int n, @NonNull String string) {
        return ChainBuilder.EMPTY.repeat(n, string);
    }

    @NonNull
    public static Repeat.On<ChainBuilder> repeat(@NonNull String string) {
        return ChainBuilder.EMPTY.repeat(string);
    }

    @NonNull
    public static Repeat.On<ChainBuilder> repeat(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.repeat(string, string2);
    }

    @NonNull
    public static Repeat.On<ChainBuilder> repeat(@NonNull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.repeat(function);
    }

    @NonNull
    public static Repeat.On<ChainBuilder> repeat(@NonNull Function<Session, Integer> function, @NonNull String string) {
        return ChainBuilder.EMPTY.repeat(function, string);
    }

    @NonNull
    public static ForEach.On<ChainBuilder> foreach(@NonNull List<?> list, String string) {
        return ChainBuilder.EMPTY.foreach(list, string);
    }

    @NonNull
    public static ForEach.On<ChainBuilder> foreach(@NonNull List<?> list, String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.foreach(list, string, string2);
    }

    @NonNull
    public static ForEach.On<ChainBuilder> foreach(@NonNull String string, String string2) {
        return ChainBuilder.EMPTY.foreach(string, string2);
    }

    @NonNull
    public static ForEach.On<ChainBuilder> foreach(@NonNull String string, String string2, @NonNull String string3) {
        return ChainBuilder.EMPTY.foreach(string, string2, string3);
    }

    @NonNull
    public static ForEach.On<ChainBuilder> foreach(@NonNull Function<Session, List<?>> function, @NonNull String string) {
        return ChainBuilder.EMPTY.foreach(function, string);
    }

    @NonNull
    public static ForEach.On<ChainBuilder> foreach(@NonNull Function<Session, List<?>> function, @NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.foreach(function, string, string2);
    }

    @NonNull
    public static During.On<ChainBuilder> during(long l) {
        return ChainBuilder.EMPTY.during(l);
    }

    @NonNull
    public static During.On<ChainBuilder> during(long l, boolean bl) {
        return ChainBuilder.EMPTY.during(l, bl);
    }

    @NonNull
    public static During.On<ChainBuilder> during(long l, @NonNull String string) {
        return ChainBuilder.EMPTY.during(l, string);
    }

    @NonNull
    public static During.On<ChainBuilder> during(long l, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(l, string, bl);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Duration duration) {
        return ChainBuilder.EMPTY.during(duration);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, bl);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Duration duration, @NonNull String string) {
        return ChainBuilder.EMPTY.during(duration, string);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Duration duration, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, string, bl);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull String string) {
        return ChainBuilder.EMPTY.during(string);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(string, bl);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.during(string, string2);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.during(string, string2, bl);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.during(function);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.during(function, bl);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function, @NonNull String string) {
        return ChainBuilder.EMPTY.during(function, string);
    }

    @NonNull
    public static During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(function, string, bl);
    }

    @NonNull
    public static Forever.On<ChainBuilder> forever() {
        return ChainBuilder.EMPTY.forever();
    }

    @NonNull
    public static Forever.On<ChainBuilder> forever(@NonNull String string) {
        return ChainBuilder.EMPTY.forever(string);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string) {
        return ChainBuilder.EMPTY.asLongAs(string);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAs(string, string2);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, bl);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, string2, bl);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.asLongAs(function);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAs(function, string);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, bl);
    }

    @NonNull
    public static AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, string, bl);
    }

    @NonNull
    public static DoWhile.On<ChainBuilder> doWhile(@NonNull String string) {
        return ChainBuilder.EMPTY.doWhile(string);
    }

    @NonNull
    public static DoWhile.On<ChainBuilder> doWhile(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhile(string, string2);
    }

    @NonNull
    public static DoWhile.On<ChainBuilder> doWhile(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doWhile(function);
    }

    @NonNull
    public static DoWhile.On<ChainBuilder> doWhile(@NonNull Function<Session, Boolean> function, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhile(function, string);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, string2);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, string2);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, string2);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2, @NonNull String string3, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, string2, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, string2, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, string2, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, string);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, string);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, string, bl);
    }

    @NonNull
    public static AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, string, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, string2);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, string2);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, string2);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2, @NonNull String string3, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, string2, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, string2, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, string2, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, string);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, string);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, string, bl);
    }

    @NonNull
    public static DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, string, bl);
    }

    @NonNull
    public static DoIf.Then<ChainBuilder> doIf(@NonNull String string) {
        return ChainBuilder.EMPTY.doIf(string);
    }

    @NonNull
    public static DoIf.Then<ChainBuilder> doIf(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIf(function);
    }

    @NonNull
    public static DoIfOrElse.Then<ChainBuilder> doIfOrElse(@NonNull String string) {
        return ChainBuilder.EMPTY.doIfOrElse(string);
    }

    @NonNull
    public static DoIfOrElse.Then<ChainBuilder> doIfOrElse(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIfOrElse(function);
    }

    @NonNull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.doIfEquals(string, string2);
    }

    @NonNull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull String string, @NonNull Object object) {
        return ChainBuilder.EMPTY.doIfEquals(string, object);
    }

    @NonNull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull String string, @NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEquals(string, function);
    }

    @NonNull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull Function<Session, Object> function, @NonNull String string) {
        return ChainBuilder.EMPTY.doIfEquals(function, string);
    }

    @NonNull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull Function<Session, Object> function, Object object) {
        return ChainBuilder.EMPTY.doIfEquals(function, object);
    }

    @NonNull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull Function<Session, Object> function, @NonNull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEquals(function, function2);
    }

    @NonNull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(String string, String string2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, string2);
    }

    @NonNull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull String string, @NonNull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, object);
    }

    @NonNull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull String string, @NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, function);
    }

    @NonNull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull Function<Session, Object> function, @NonNull String string) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, string);
    }

    @NonNull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull Function<Session, Object> function, @NonNull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, object);
    }

    @NonNull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull Function<Session, Object> function, @NonNull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, function2);
    }

    @NonNull
    public static DoSwitch.On<ChainBuilder> doSwitch(@NonNull String string) {
        return ChainBuilder.EMPTY.doSwitch(string);
    }

    @NonNull
    public static DoSwitch.On<ChainBuilder> doSwitch(@NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitch(function);
    }

    @NonNull
    public static DoSwitchOrElse.On<ChainBuilder> doSwitchOrElse(@NonNull String string) {
        return ChainBuilder.EMPTY.doSwitchOrElse(string);
    }

    @NonNull
    public static DoSwitchOrElse.On<ChainBuilder> doSwitchOrElse(@NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitchOrElse(function);
    }

    @NonNull
    public static RandomSwitch.On<ChainBuilder> randomSwitch() {
        return ChainBuilder.EMPTY.randomSwitch();
    }

    @NonNull
    public static RandomSwitchOrElse.On<ChainBuilder> randomSwitchOrElse() {
        return ChainBuilder.EMPTY.randomSwitchOrElse();
    }

    @NonNull
    public static UniformRandomSwitch.On<ChainBuilder> uniformRandomSwitch() {
        return ChainBuilder.EMPTY.uniformRandomSwitch();
    }

    @NonNull
    public static RoundRobinSwitch.On<ChainBuilder> roundRobinSwitch() {
        return ChainBuilder.EMPTY.roundRobinSwitch();
    }

    @NonNull
    public static Errors.ExitBlockOnFail<ChainBuilder> exitBlockOnFail() {
        return ChainBuilder.EMPTY.exitBlockOnFail();
    }

    @NonNull
    public static Errors.TryMax<ChainBuilder> tryMax(int n) {
        return ChainBuilder.EMPTY.tryMax(n);
    }

    @NonNull
    public static Errors.TryMax<ChainBuilder> tryMax(int n, @NonNull String string) {
        return ChainBuilder.EMPTY.tryMax(n, string);
    }

    @NonNull
    public static Errors.TryMax<ChainBuilder> tryMax(@NonNull String string) {
        return ChainBuilder.EMPTY.tryMax(string);
    }

    @NonNull
    public static Errors.TryMax<ChainBuilder> tryMax(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.tryMax(string, string2);
    }

    @NonNull
    public static Errors.TryMax<ChainBuilder> tryMax(@NonNull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.tryMax(function);
    }

    @NonNull
    public static Errors.TryMax<ChainBuilder> tryMax(@NonNull Function<Session, Integer> function, @NonNull String string) {
        return ChainBuilder.EMPTY.tryMax(function, string);
    }

    @NonNull
    public static ChainBuilder exitHereIf(@NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(string);
    }

    @NonNull
    public static ChainBuilder exitHereIf(@NonNull Function<Session, Boolean> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(function);
    }

    @NonNull
    public static ChainBuilder exitHere() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHere();
    }

    @NonNull
    public static ChainBuilder exitHereIfFailed() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIfFailed();
    }

    @NonNull
    public static ChainBuilder stopInjector(String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjector(string);
    }

    @NonNull
    public static ChainBuilder stopInjector(Function<Session, String> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjector(function);
    }

    @NonNull
    public static ChainBuilder stopInjectorIf(Function<Session, String> function, @NonNull Function<Session, Boolean> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjectorIf(function, function2);
    }

    @NonNull
    public static ChainBuilder stopInjectorIf(String string, @NonNull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjectorIf(string, string2);
    }

    @NonNull
    public static ChainBuilder stopInjectorIf(String string, @NonNull Function<Session, Boolean> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjectorIf(string, function);
    }

    @NonNull
    public static ChainBuilder stopInjectorIf(Function<Session, String> function, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopInjectorIf(function, string);
    }

    @NonNull
    public static Groups.On<ChainBuilder> group(@NonNull String string) {
        return ChainBuilder.EMPTY.group(string);
    }

    @NonNull
    public static Groups.On<ChainBuilder> group(@NonNull Function<Session, String> function) {
        return ChainBuilder.EMPTY.group(function);
    }

    @NonNull
    public static PauseType normalPausesWithStdDevDuration(@NonNull Duration duration) {
        return new PauseType.NormalWithStdDevDuration(duration);
    }

    @NonNull
    public static PauseType normalPausesWithPercentageDuration(double d) {
        return new PauseType.NormalWithPercentageDuration(d);
    }

    @NonNull
    public static PauseType customPauses(@NonNull Function<Session, Long> function) {
        return new PauseType.Custom(function);
    }

    @NonNull
    public static PauseType uniformPausesPlusOrMinusPercentage(double d) {
        return new PauseType.UniformPercentage(d);
    }

    @NonNull
    public static PauseType uniformPausesPlusOrMinusDuration(@NonNull Duration duration) {
        return new PauseType.UniformDuration(duration);
    }

    @NonNull
    public static CheckBuilder.Find<String> bodyString() {
        return new CheckBuilder.Find.Default(Predef.bodyString(), CoreCheckType.BodyString, String.class, null);
    }

    @NonNull
    public static CheckBuilder.Find<byte[]> bodyBytes() {
        return new CheckBuilder.Find.Default(Predef.bodyBytes(), CoreCheckType.BodyBytes, byte[].class, null);
    }

    @NonNull
    public static CheckBuilder.Find<Integer> bodyLength() {
        return CoreCheckBuilders.bodyLength();
    }

    @NonNull
    public static CheckBuilder.Find<InputStream> bodyStream() {
        return new CheckBuilder.Find.Default(Predef.bodyStream(), CoreCheckType.BodyStream, InputStream.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<Integer> substring(@NonNull String string) {
        return CoreCheckBuilders.substring(string);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<Integer> substring(@NonNull Function<Session, String> function) {
        return CoreCheckBuilders.substring(function);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> xpath(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.toStringExpression(string), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> xpath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.javaFunctionToExpression(function), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> xpath(@NonNull String string, @NonNull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.toStringExpression(string), Converters.toScalaMap(map), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> xpath(@NonNull Function<Session, String> function, @NonNull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.javaFunctionToExpression(function), Converters.toScalaMap(map), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> css(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.css(Expressions.toStringExpression(string), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, String.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> css(@NonNull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.css(Expressions.javaFunctionToExpression(function), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, String.class, null);
    }

    @NonNull
    public static CheckBuilder.CssOfTypeMultipleFind css(@NonNull String string, @NonNull String string2) {
        return new CheckBuilder.Css((CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String>)Predef.css(Expressions.toStringExpression(string), (String)string2, (CssSelectors)Predef.defaultCssSelectors()));
    }

    @NonNull
    public static CheckBuilder.CssOfTypeMultipleFind css(@NonNull Function<Session, String> function, @NonNull String string) {
        return new CheckBuilder.Css((CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String>)Predef.css(Expressions.javaFunctionToExpression(function), (String)string, (CssSelectors)Predef.defaultCssSelectors()));
    }

    @NonNull
    public static CheckBuilder.MultipleFind<Map<String, Object>> form(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.form(Expressions.toStringExpression(string), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Map.class, Converters::toJavaMap);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<Map<String, Object>> form(@NonNull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.form(Expressions.javaFunctionToExpression(function), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Map.class, Converters::toJavaMap);
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonPath(@NonNull String string) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)Predef.jsonPath(Expressions.toStringExpression(string), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)Predef.jsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeFind jmesPath(@NonNull String string) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)Predef.jmesPath(Expressions.toStringExpression(string), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeFind jmesPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)Predef.jmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@NonNull String string) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)Predef.jsonpJsonPath(Expressions.toStringExpression(string), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)Predef.jsonpJsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)Predef.defaultJsonPaths()));
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeFind jsonpJmesPath(@NonNull String string) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)Predef.jsonpJmesPath(Expressions.toStringExpression(string), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @NonNull
    public static CheckBuilder.JsonOfTypeFind jsonpJmesPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)Predef.jsonpJmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)Predef.defaultJmesPaths()));
    }

    @NonNull
    public static CheckBuilder.CaptureGroupCheckBuilder regex(@NonNull String string) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)Predef.regex(Expressions.toStringExpression(string), (Patterns)Predef.defaultPatterns()));
    }

    @NonNull
    public static CheckBuilder.CaptureGroupCheckBuilder regex(@NonNull Function<Session, String> function) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)Predef.regex(Expressions.javaFunctionToExpression(function), (Patterns)Predef.defaultPatterns()));
    }

    public static void registerJmesPathFunctions(io.burt.jmespath.function.Function ... functionArray) {
        Predef.registerJmesPathFunctions(Converters.toScalaSeq(functionArray));
    }

    @NonNull
    public static CheckBuilder.Find<String> md5() {
        return new CheckBuilder.Find.Default(Predef.md5(), CoreCheckType.Md5, String.class, null);
    }

    @NonNull
    public static CheckBuilder.Find<String> sha1() {
        return new CheckBuilder.Find.Default(Predef.sha1(), CoreCheckType.Sha1, String.class, null);
    }

    @NonNull
    public static CheckBuilder.Find<Integer> responseTimeInMillis() {
        return CoreCheckBuilders.responseTimeInMillis();
    }

    @NonNull
    public static FeederBuilder.Batchable<String> csv(@NonNull String string) {
        return FeederBuilder.Impl.csv(string);
    }

    @NonNull
    public static FeederBuilder.Batchable<String> csv(@NonNull String string, char c) {
        return FeederBuilder.Impl.csv(string, c);
    }

    @NonNull
    public static FeederBuilder.Batchable<String> ssv(@NonNull String string) {
        return FeederBuilder.Impl.ssv(string);
    }

    @NonNull
    public static FeederBuilder.Batchable<String> ssv(@NonNull String string, char c) {
        return FeederBuilder.Impl.ssv(string, c);
    }

    @NonNull
    public static FeederBuilder.Batchable<String> tsv(@NonNull String string) {
        return FeederBuilder.Impl.tsv(string);
    }

    @NonNull
    public static FeederBuilder.Batchable<String> tsv(@NonNull String string, char c) {
        return FeederBuilder.Impl.tsv(string, c);
    }

    @NonNull
    public static FeederBuilder.Batchable<String> separatedValues(@NonNull String string, char c) {
        return FeederBuilder.Impl.separatedValues(string, c);
    }

    @NonNull
    public static FeederBuilder.Batchable<String> separatedValues(@NonNull String string, char c, char c2) {
        return FeederBuilder.Impl.separatedValues(string, c, c2);
    }

    @NonNull
    public static FeederBuilder.FileBased<Object> jsonFile(@NonNull String string) {
        return FeederBuilder.Impl.jsonFile(string);
    }

    @NonNull
    public static FeederBuilder<Object> jsonUrl(String string) {
        return FeederBuilder.Impl.jsonUrl(string);
    }

    @NonNull
    public static FeederBuilder<Object> arrayFeeder(@NonNull Map<String, Object>[] mapArray) {
        scala.collection.immutable.Map[] mapArray2 = (scala.collection.immutable.Map[])Arrays.stream(mapArray).map(Converters::toScalaMap).toArray(scala.collection.immutable.Map[]::new);
        return new FeederBuilder.Impl<Object>(Predef.array2FeederBuilder((scala.collection.immutable.Map[])mapArray2, (GatlingConfiguration)Predef.configuration()));
    }

    @NonNull
    public static FeederBuilder<Object> listFeeder(@NonNull List<Map<String, Object>> list) {
        Seq seq = Converters.toScalaSeq(list.stream().map(Converters::toScalaMap).collect(Collectors.toList()));
        return new FeederBuilder.Impl<Object>(Predef.seq2FeederBuilder((IndexedSeq)seq.toIndexedSeq(), (GatlingConfiguration)Predef.configuration()));
    }

    @NonNull
    public static OpenInjectionStep.Ramp rampUsers(int n) {
        return new OpenInjectionStep.Ramp(n);
    }

    @NonNull
    public static OpenInjectionStep.StressPeak stressPeakUsers(int n) {
        return new OpenInjectionStep.StressPeak(n);
    }

    @NonNull
    public static OpenInjectionStep atOnceUsers(int n) {
        return OpenInjectionStep.atOnceUsers(n);
    }

    @NonNull
    public static OpenInjectionStep.ConstantRate constantUsersPerSec(double d) {
        return new OpenInjectionStep.ConstantRate(d);
    }

    @NonNull
    public static OpenInjectionStep.RampRate rampUsersPerSec(double d) {
        return new OpenInjectionStep.RampRate(d);
    }

    @NonNull
    public static OpenInjectionStep nothingFor(long l) {
        return CoreDsl.nothingFor(Duration.ofSeconds(l));
    }

    @NonNull
    public static OpenInjectionStep nothingFor(@NonNull Duration duration) {
        return OpenInjectionStep.nothingFor(duration);
    }

    @NonNull
    public static OpenInjectionStep.Stairs incrementUsersPerSec(double d) {
        return new OpenInjectionStep.Stairs(d);
    }

    @NonNull
    public static ClosedInjectionStep.Constant constantConcurrentUsers(int n) {
        return new ClosedInjectionStep.Constant(n);
    }

    @NonNull
    public static ClosedInjectionStep.Ramp rampConcurrentUsers(int n) {
        return new ClosedInjectionStep.Ramp(n);
    }

    @NonNull
    public static ClosedInjectionStep.Stairs incrementConcurrentUsers(int n) {
        return new ClosedInjectionStep.Stairs(n);
    }

    @NonNull
    public static ThrottleStep.ReachIntermediate reachRps(int n) {
        return new ThrottleStep.ReachIntermediate(n);
    }

    @NonNull
    public static ThrottleStep holdFor(long l) {
        return CoreDsl.holdFor(Duration.ofSeconds(l));
    }

    @NonNull
    public static ThrottleStep holdFor(@NonNull Duration duration) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Hold(Converters.toScalaDuration(duration)));
    }

    @NonNull
    public static ThrottleStep jumpToRps(int n) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Jump(n));
    }

    @NonNull
    public static Assertion.WithPath global() {
        return new Assertion.WithPath((AssertionPath)AssertionPath.Global$.MODULE$);
    }

    @NonNull
    public static Assertion.WithPath forAll() {
        return new Assertion.WithPath((AssertionPath)AssertionPath.ForAll$.MODULE$);
    }

    @NonNull
    public static Assertion.WithPath details(String ... stringArray) {
        Seq seq = Converters.toScalaSeq(stringArray);
        return new Assertion.WithPath((AssertionPath)new AssertionPath.Details(seq.toList()));
    }

    @NonNull
    public static Body.WithString StringBody(@NonNull String string) {
        return new Body.WithString(Predef.StringBody((String)string, (GatlingConfiguration)Predef.configuration()));
    }

    @NonNull
    public static Body.WithString StringBody(@NonNull Function<Session, String> function) {
        return new Body.WithString(Predef.StringBody(Expressions.javaFunctionToExpression(function), (GatlingConfiguration)Predef.configuration()));
    }

    @NonNull
    public static Body.WithBytes RawFileBody(@NonNull String string) {
        return new Body.WithBytes(Predef.RawFileBody(Expressions.toStringExpression(string), (RawFileBodies)Predef.rawFileBodies()));
    }

    @NonNull
    public static Body.WithBytes RawFileBody(@NonNull Function<Session, String> function) {
        return new Body.WithBytes(Predef.RawFileBody(Expressions.javaFunctionToExpression(function), (RawFileBodies)Predef.rawFileBodies()));
    }

    @NonNull
    public static Body.WithString ElFileBody(@NonNull String string) {
        return new Body.WithString(Predef.ElFileBody(Expressions.toStringExpression(string), (ElFileBodies)Predef.elFileBodies()));
    }

    @NonNull
    public static Body.WithString ElFileBody(@NonNull Function<Session, String> function) {
        return new Body.WithString(Predef.ElFileBody(Expressions.javaFunctionToExpression(function), (ElFileBodies)Predef.elFileBodies()));
    }

    @NonNull
    public static Body.WithString PebbleStringBody(@NonNull String string) {
        return new Body.WithString(Predef.PebbleStringBody((String)string, (GatlingConfiguration)Predef.configuration()));
    }

    @NonNull
    public static Body.WithString PebbleFileBody(@NonNull String string) {
        return new Body.WithString(Predef.PebbleFileBody(Expressions.toStringExpression(string), (PebbleFileBodies)Predef.pebbleFileBodies(), (GatlingConfiguration)Predef.configuration()));
    }

    @NonNull
    public static Body.WithString PebbleFileBody(@NonNull Function<Session, String> function) {
        return new Body.WithString(Predef.PebbleFileBody(Expressions.javaFunctionToExpression(function), (PebbleFileBodies)Predef.pebbleFileBodies(), (GatlingConfiguration)Predef.configuration()));
    }

    @NonNull
    public static Body.WithBytes ByteArrayBody(@NonNull byte[] byArray) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.toStaticValueExpression(byArray)));
    }

    @NonNull
    public static Body.WithBytes ByteArrayBody(@NonNull String string) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.toBytesExpression(string)));
    }

    @NonNull
    public static Body.WithBytes ByteArrayBody(@NonNull Function<Session, byte[]> function) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.javaFunctionToExpression(function)));
    }

    @NonNull
    public static Body InputStreamBody(@NonNull Function<Session, InputStream> function) {
        return new Body.Default(Predef.InputStreamBody(Expressions.javaFunctionToExpression(function)));
    }

    public static void registerPebbleExtensions(Extension ... extensionArray) {
        Predef.registerPebbleExtensions(Converters.toScalaSeq(extensionArray));
    }

    public static Choice.WithKey.Then onCase(@NonNull Object object) {
        return new Choice.WithKey.Then(object);
    }

    public static Choice.WithWeight.Then percent(double d) {
        return new Choice.WithWeight.Then(d);
    }
}

