/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.javaapi.core.PauseType;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.ThrottleStep;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PopulationBuilder {
    private final io.gatling.core.structure.PopulationBuilder wrapped;

    public PopulationBuilder(io.gatling.core.structure.PopulationBuilder populationBuilder) {
        this.wrapped = populationBuilder;
    }

    public io.gatling.core.structure.PopulationBuilder asScala() {
        return this.wrapped;
    }

    @NonNull
    public PopulationBuilder protocols(ProtocolBuilder ... protocolBuilderArray) {
        return this.protocols(Arrays.asList(protocolBuilderArray));
    }

    @NonNull
    public PopulationBuilder protocols(@NonNull List<ProtocolBuilder> list) {
        return new PopulationBuilder(this.wrapped.protocols(Converters.toScalaSeq(list.stream().map(ProtocolBuilder::protocol).collect(Collectors.toList()))));
    }

    @NonNull
    public PopulationBuilder andThen(PopulationBuilder ... populationBuilderArray) {
        return this.andThen(Arrays.asList(populationBuilderArray));
    }

    @NonNull
    public PopulationBuilder andThen(@NonNull List<PopulationBuilder> list) {
        return new PopulationBuilder(this.wrapped.andThen(Converters.toScalaSeq(list.stream().map(PopulationBuilder::asScala).collect(Collectors.toList()))));
    }

    @NonNull
    public PopulationBuilder disablePauses() {
        return new PopulationBuilder(this.wrapped.disablePauses());
    }

    @NonNull
    public PopulationBuilder constantPauses() {
        return new PopulationBuilder(this.wrapped.constantPauses());
    }

    @NonNull
    public PopulationBuilder exponentialPauses() {
        return new PopulationBuilder(this.wrapped.exponentialPauses());
    }

    @NonNull
    public PopulationBuilder customPauses(@NonNull Function<Session, Long> function) {
        return new PopulationBuilder(this.wrapped.customPauses(Expressions.javaLongFunctionToExpression(function)));
    }

    @NonNull
    public PopulationBuilder uniformPauses(double d) {
        return new PopulationBuilder(this.wrapped.uniformPauses(d));
    }

    @NonNull
    public PopulationBuilder uniformPauses(@NonNull Duration duration) {
        return new PopulationBuilder(this.wrapped.uniformPauses(Converters.toScalaDuration(duration)));
    }

    @NonNull
    public PopulationBuilder pauses(@NonNull PauseType pauseType) {
        return new PopulationBuilder(this.wrapped.pauses(pauseType.asScala()));
    }

    @NonNull
    public PopulationBuilder throttle(ThrottleStep ... throttleStepArray) {
        return this.throttle(Arrays.asList(throttleStepArray));
    }

    @NonNull
    public PopulationBuilder throttle(@NonNull List<ThrottleStep> list) {
        return new PopulationBuilder(this.wrapped.throttle(Converters.toScalaSeq(list.stream().map(ThrottleStep::asScala).collect(Collectors.toList()))));
    }

    @NonNull
    public PopulationBuilder noShard() {
        return new PopulationBuilder(this.wrapped.noShard());
    }
}

