/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.protocol.Protocol;
import io.gatling.core.scenario.Simulation$;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.javaapi.core.Assertion;
import io.gatling.javaapi.core.PauseType;
import io.gatling.javaapi.core.PopulationBuilder;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.ThrottleStep;
import io.gatling.javaapi.core.internal.Converters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import scala.Function0;
import scala.Option;
import scala.jdk.javaapi.FunctionConverters;
import scala.runtime.BoxedUnit;

public abstract class Simulation {
    private List<PopulationBuilder> _populationBuilders = new ArrayList<PopulationBuilder>();
    private Map<Class<? extends Protocol>, Protocol> _globalProtocols = new HashMap<Class<? extends Protocol>, Protocol>();
    private List<Assertion> _assertions = new ArrayList<Assertion>();
    private Duration _maxDuration;
    private PauseType _globalPauseType = PauseType.Constant;
    private List<ThrottleStep> _globalThrottleSteps = new ArrayList<ThrottleStep>();

    public void before() {
    }

    public void after() {
    }

    public final @NonNull SetUp setUp(PopulationBuilder ... populationBuilderArray) {
        return this.setUp(Arrays.asList(populationBuilderArray));
    }

    public final @NonNull SetUp setUp(@NonNull List<PopulationBuilder> list) {
        if (!this._populationBuilders.isEmpty()) {
            throw new UnsupportedOperationException("Can only call setUp once");
        }
        this._populationBuilders = list;
        return new SetUp();
    }

    public SimulationParams params(GatlingConfiguration gatlingConfiguration, @Nullable String string) {
        return Simulation$.MODULE$.params(string != null ? string : this.getClass().getName(), Converters.toScalaSeq(this._populationBuilders.stream().map(PopulationBuilder::asScala).collect(Collectors.toList())).toList(), Converters.toScalaMap(this._globalProtocols), Converters.toScalaSeq(this._assertions.stream().map(Assertion::asScala).collect(Collectors.toList())), Option.apply((Object)this._maxDuration).map(Converters::toScalaDuration), this._globalPauseType.asScala(), Converters.toScalaSeq(this._globalThrottleSteps.stream().map(ThrottleStep::asScala).collect(Collectors.toList())), this.toScalaHookOption("before", this::before), this.toScalaHookOption("after", this::after), gatlingConfiguration);
    }

    private Option<Function0<BoxedUnit>> toScalaHookOption(String string, Runnable runnable) {
        return Option.when((boolean)this.isHookDefinedRec(this.getClass(), string), (Function0)FunctionConverters.asScalaFromSupplier(() -> {
            runnable.run();
            return null;
        }));
    }

    private boolean isHookDefinedRec(Class<?> clazz, String string) {
        try {
            clazz.getDeclaredMethod(string, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?> clazz2 = clazz.getSuperclass();
            return clazz2 != null && !clazz2.getName().equals("io.gatling.javaapi.core.Simulation") && this.isHookDefinedRec(clazz2, string);
        }
    }

    public final class SetUp {
        private SetUp() {
        }

        public @NonNull SetUp protocols(ProtocolBuilder ... protocolBuilderArray) {
            return this.protocols(Arrays.asList(protocolBuilderArray));
        }

        public @NonNull SetUp protocols(@NonNull List<ProtocolBuilder> list) {
            Simulation.this._globalProtocols = list.stream().map(ProtocolBuilder::protocol).collect(Collectors.toMap(Protocol::getClass, Function.identity()));
            return this;
        }

        public @NonNull SetUp assertions(Assertion ... assertionArray) {
            return this.assertions(Arrays.asList(assertionArray));
        }

        public @NonNull SetUp assertions(@NonNull List<Assertion> list) {
            Simulation.this._assertions = list;
            return this;
        }

        public @NonNull SetUp maxDuration(long l) {
            return this.maxDuration(Duration.ofSeconds(l));
        }

        public @NonNull SetUp maxDuration(@NonNull Duration duration) {
            Simulation.this._maxDuration = duration;
            return this;
        }

        public @NonNull SetUp throttle(ThrottleStep ... throttleStepArray) {
            return this.throttle(Arrays.asList(throttleStepArray));
        }

        public @NonNull SetUp throttle(@NonNull List<ThrottleStep> list) {
            Simulation.this._globalThrottleSteps = list;
            return this;
        }

        public @NonNull SetUp disablePauses() {
            return this.pauses(PauseType.Disabled);
        }

        public @NonNull SetUp constantPauses() {
            return this.pauses(PauseType.Constant);
        }

        public @NonNull SetUp exponentialPauses() {
            return this.pauses(PauseType.Exponential);
        }

        public @NonNull SetUp customPauses(@NonNull Function<Session, Long> function) {
            return this.pauses(new PauseType.Custom(function));
        }

        public @NonNull SetUp uniformPauses(double d) {
            return this.pauses(new PauseType.UniformPercentage(d));
        }

        public @NonNull SetUp uniformPauses(@NonNull Duration duration) {
            return this.pauses(new PauseType.UniformDuration(duration));
        }

        public @NonNull SetUp normalPausesWithStdDevDuration(Duration duration) {
            return this.pauses(new PauseType.NormalWithStdDevDuration(duration));
        }

        public @NonNull SetUp normalPausesWithPercentageDuration(double d) {
            return this.pauses(new PauseType.NormalWithPercentageDuration(d));
        }

        public @NonNull SetUp pauses(@NonNull PauseType pauseType) {
            Simulation.this._globalPauseType = pauseType;
            return this;
        }
    }
}

