/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.core.Predef;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.BatchableFeederBuilder;
import io.gatling.core.feeder.FeederBuilderBase;
import io.gatling.core.feeder.SeparatedValuesParser;
import io.gatling.core.json.JsonParsers;
import io.gatling.javaapi.core.internal.Converters;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import scala.Function0;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;

public interface FeederBuilder<T> {
    public @NonNull FeederBuilder<T> queue();

    public @NonNull FeederBuilder<T> random();

    public @NonNull FeederBuilder<T> shuffle();

    public @NonNull FeederBuilder<T> circular();

    public @NonNull FeederBuilder<Object> transform(@NonNull BiFunction<String, T, Object> var1);

    public @NonNull List<java.util.Map<String, Object>> readRecords();

    public int recordsCount();

    public @NonNull FeederBuilder<T> shard();

    public Function0<Iterator<Map<String, Object>>> asScala();

    public static final class Impl<T>
    implements Batchable<T> {
        private final BatchableFeederBuilder<T> wrapped;

        static @NonNull Batchable<String> csv(@NonNull String string) {
            return Impl.csv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        static @NonNull Batchable<String> csv(@NonNull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.csv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        static @NonNull Batchable<String> ssv(@NonNull String string) {
            return Impl.ssv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        static @NonNull Batchable<String> ssv(@NonNull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.ssv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        static @NonNull Batchable<String> tsv(@NonNull String string) {
            return Impl.tsv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        static @NonNull Batchable<String> tsv(@NonNull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.tsv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        static @NonNull Batchable<String> separatedValues(@NonNull String string, char c) {
            return Impl.separatedValues(string, c, SeparatedValuesParser.DefaultQuoteChar());
        }

        static @NonNull Batchable<String> separatedValues(@NonNull String string, char c, char c2) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.separatedValues((String)string, (char)c, (char)c2, (GatlingConfiguration)Predef.configuration()));
        }

        static @NonNull FileBased<Object> jsonFile(@NonNull String string) {
            return new Impl<Object>((FeederBuilderBase<Object>)Predef.jsonFile((String)string, (JsonParsers)Predef.defaultJsonParsers(), (GatlingConfiguration)Predef.configuration()));
        }

        static @NonNull FeederBuilder<Object> jsonUrl(@NonNull String string) {
            return new Impl<Object>(Predef.jsonUrl((String)string, (JsonParsers)Predef.defaultJsonParsers(), (GatlingConfiguration)Predef.configuration()));
        }

        public Impl(@NonNull FeederBuilderBase<T> feederBuilderBase) {
            this.wrapped = (BatchableFeederBuilder)feederBuilderBase;
        }

        private Impl<T> make(Function<BatchableFeederBuilder<T>, FeederBuilderBase<T>> function) {
            return new Impl<T>(function.apply(this.wrapped));
        }

        @Override
        public @NonNull Batchable<T> queue() {
            return this.make(BatchableFeederBuilder::queue);
        }

        @Override
        public @NonNull Batchable<T> random() {
            return this.make(BatchableFeederBuilder::random);
        }

        @Override
        public @NonNull Batchable<T> shuffle() {
            return this.make(BatchableFeederBuilder::shuffle);
        }

        @Override
        public @NonNull Batchable<T> circular() {
            return this.make(BatchableFeederBuilder::circular);
        }

        @Override
        public @NonNull FeederBuilder<Object> transform(final @NonNull BiFunction<String, T, Object> biFunction) {
            return new Impl<Object>((FeederBuilderBase<Object>)this.wrapped.transform(new PartialFunction<Tuple2<String, T>, Object>(){
                final /* synthetic */ Impl this$0;
                {
                    this.this$0 = impl;
                }

                public boolean isDefinedAt(Tuple2<String, T> tuple2) {
                    return true;
                }

                public Object apply(Tuple2<String, T> tuple2) {
                    return biFunction.apply((String)tuple2._1, tuple2._2);
                }
            }));
        }

        @Override
        public @NonNull List<java.util.Map<String, Object>> readRecords() {
            return Converters.toJavaList(this.wrapped.readRecords()).stream().map(Converters::toJavaMap).collect(Collectors.toList());
        }

        @Override
        public int recordsCount() {
            return this.wrapped.recordsCount();
        }

        @Override
        public @NonNull Batchable<T> shard() {
            return this.make(BatchableFeederBuilder::shard);
        }

        @Override
        public @NonNull Batchable<T> unzip() {
            return this.make(BatchableFeederBuilder::unzip);
        }

        @Override
        public @NonNull Batchable<T> eager() {
            return this.make(BatchableFeederBuilder::eager);
        }

        @Override
        public @NonNull Batchable<T> batch() {
            return this.make(BatchableFeederBuilder::batch);
        }

        @Override
        public @NonNull Batchable<T> batch(int n) {
            return this.make(batchableFeederBuilder -> batchableFeederBuilder.batch(n));
        }

        @Override
        public Function0<Iterator<Map<String, Object>>> asScala() {
            return this.wrapped;
        }
    }

    public static interface Batchable<T>
    extends FileBased<T> {
        @Override
        public @NonNull Batchable<T> queue();

        @Override
        public @NonNull Batchable<T> random();

        @Override
        public @NonNull Batchable<T> shuffle();

        @Override
        public @NonNull Batchable<T> circular();

        @Override
        public @NonNull Batchable<T> shard();

        @Override
        public @NonNull Batchable<T> unzip();

        public @NonNull Batchable<T> eager();

        public @NonNull Batchable<T> batch();

        public @NonNull Batchable<T> batch(int var1);
    }

    public static interface FileBased<T>
    extends FeederBuilder<T> {
        @Override
        public @NonNull FileBased<T> queue();

        @Override
        public @NonNull FileBased<T> random();

        @Override
        public @NonNull FileBased<T> shuffle();

        @Override
        public @NonNull FileBased<T> circular();

        @Override
        public @NonNull FileBased<T> shard();

        public @NonNull FileBased<T> unzip();
    }
}

