/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.commons.stats.assertion.Condition;
import io.gatling.commons.stats.assertion.CountMetric;
import io.gatling.commons.stats.assertion.Stat;
import io.gatling.commons.stats.assertion.Target;
import io.gatling.commons.stats.assertion.TimeMetric;
import io.gatling.core.Predef;
import io.gatling.javaapi.core.internal.Converters;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public final class Assertion {
    private final io.gatling.commons.stats.assertion.Assertion wrapped;

    Assertion(io.gatling.commons.stats.assertion.Assertion assertion) {
        this.wrapped = assertion;
    }

    public io.gatling.commons.stats.assertion.Assertion asScala() {
        return this.wrapped;
    }

    public static final class WithPathAndTarget<T extends Number> {
        private final AssertionPath path;
        private final Target target;

        private WithPathAndTarget(AssertionPath assertionPath, Target target) {
            this.path = assertionPath;
            this.target = target;
        }

        private Assertion next(Condition condition) {
            return new Assertion(new io.gatling.commons.stats.assertion.Assertion(this.path, this.target, condition));
        }

        public @NonNull Assertion lt(T t) {
            return this.next((Condition)new Condition.Lt(((Number)t).doubleValue()));
        }

        public @NonNull Assertion lte(T t) {
            return this.next((Condition)new Condition.Lte(((Number)t).doubleValue()));
        }

        public @NonNull Assertion gt(T t) {
            return this.next((Condition)new Condition.Gt(((Number)t).doubleValue()));
        }

        public @NonNull Assertion gte(T t) {
            return this.next((Condition)new Condition.Gte(((Number)t).doubleValue()));
        }

        public @NonNull Assertion between(T t, T t2) {
            return this.between(t, t2, true);
        }

        public @NonNull Assertion between(T t, T t2, boolean bl) {
            return this.next((Condition)new Condition.Between(((Number)t).doubleValue(), ((Number)t2).doubleValue(), bl));
        }

        public @NonNull Assertion around(T t, T t2) {
            return this.around(t, t2, true);
        }

        public @NonNull Assertion around(T t, T t2, boolean bl) {
            return this.next((Condition)new Condition.Between(((Number)t).doubleValue() - ((Number)t2).doubleValue(), ((Number)t).doubleValue() + ((Number)t2).doubleValue(), bl));
        }

        public @NonNull Assertion deviatesAround(T t, double d) {
            return this.deviatesAround(t, d, true);
        }

        public @NonNull Assertion deviatesAround(T t, double d, boolean bl) {
            double d2 = Math.floor(((Number)t).doubleValue() * d);
            return this.next((Condition)new Condition.Between(((Number)t).doubleValue() - d2, ((Number)t).doubleValue() + d2, bl));
        }

        public @NonNull Assertion is(T t) {
            return this.next((Condition)new Condition.Is(((Number)t).doubleValue()));
        }

        public @NonNull Assertion shouldBe(T t) {
            return this.is(t);
        }

        public @NonNull Assertion in(T ... TArray) {
            return this.in(Arrays.stream(TArray).collect(Collectors.toSet()));
        }

        public @NonNull Assertion within(T ... TArray) {
            return this.in((Number[])TArray);
        }

        public @NonNull Assertion in(Set<T> set) {
            return this.next((Condition)new Condition.In(Converters.toScalaSeq(set.stream().map(number -> number.doubleValue()).collect(Collectors.toList())).toList()));
        }

        public @NonNull Assertion within(Set<T> set) {
            return this.in(set);
        }
    }

    public static final class WithPathAndCountMetric {
        private final AssertionPath path;
        private final CountMetric metric;

        private WithPathAndCountMetric(AssertionPath assertionPath, CountMetric countMetric) {
            this.path = assertionPath;
            this.metric = countMetric;
        }

        public @NonNull WithPathAndTarget<Long> count() {
            return new WithPathAndTarget<Long>(this.path, (Target)new Target.Count(this.metric));
        }

        public @NonNull WithPathAndTarget<Double> percent() {
            return new WithPathAndTarget<Double>(this.path, (Target)new Target.Percent(this.metric));
        }
    }

    public static final class WithPathAndTimeMetric {
        private final AssertionPath path;
        private final TimeMetric metric;

        private WithPathAndTimeMetric(AssertionPath assertionPath, TimeMetric timeMetric) {
            this.path = assertionPath;
            this.metric = timeMetric;
        }

        private WithPathAndTarget<Integer> next(Stat stat) {
            return new WithPathAndTarget<Integer>(this.path, (Target)new Target.Time(this.metric, stat));
        }

        public @NonNull WithPathAndTarget<Integer> min() {
            return this.next((Stat)Stat.Min$.MODULE$);
        }

        public @NonNull WithPathAndTarget<Integer> max() {
            return this.next((Stat)Stat.Max$.MODULE$);
        }

        public @NonNull WithPathAndTarget<Integer> mean() {
            return this.next((Stat)Stat.Mean$.MODULE$);
        }

        public @NonNull WithPathAndTarget<Integer> stdDev() {
            return this.next((Stat)Stat.StandardDeviation$.MODULE$);
        }

        public @NonNull WithPathAndTarget<Integer> percentile1() {
            return this.percentile(Predef.configuration().reports().indicators().percentile1());
        }

        public @NonNull WithPathAndTarget<Integer> percentile2() {
            return this.percentile(Predef.configuration().reports().indicators().percentile2());
        }

        public @NonNull WithPathAndTarget<Integer> percentile3() {
            return this.percentile(Predef.configuration().reports().indicators().percentile3());
        }

        public @NonNull WithPathAndTarget<Integer> percentile4() {
            return this.percentile(Predef.configuration().reports().indicators().percentile4());
        }

        public @NonNull WithPathAndTarget<Integer> percentile(double d) {
            return this.next((Stat)new Stat.Percentile(d));
        }
    }

    public static final class WithPath {
        private final AssertionPath path;

        WithPath(AssertionPath assertionPath) {
            this.path = assertionPath;
        }

        public @NonNull WithPathAndTimeMetric responseTime() {
            return new WithPathAndTimeMetric(this.path, (TimeMetric)TimeMetric.ResponseTime$.MODULE$);
        }

        public @NonNull WithPathAndCountMetric allRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)CountMetric.AllRequests$.MODULE$);
        }

        public @NonNull WithPathAndCountMetric failedRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)CountMetric.FailedRequests$.MODULE$);
        }

        public @NonNull WithPathAndCountMetric successfulRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)CountMetric.SuccessfulRequests$.MODULE$);
        }

        public @NonNull WithPathAndTarget<Double> requestsPerSec() {
            return new WithPathAndTarget<Double>(this.path, (Target)Target.MeanRequestsPerSecond$.MODULE$);
        }
    }
}

