/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.javaapi;

import io.gatling.commons.stats.assertion.AllRequests$;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.commons.stats.assertion.Between;
import io.gatling.commons.stats.assertion.Condition;
import io.gatling.commons.stats.assertion.CountMetric;
import io.gatling.commons.stats.assertion.CountTarget;
import io.gatling.commons.stats.assertion.FailedRequests$;
import io.gatling.commons.stats.assertion.Gt;
import io.gatling.commons.stats.assertion.Gte;
import io.gatling.commons.stats.assertion.In;
import io.gatling.commons.stats.assertion.Is;
import io.gatling.commons.stats.assertion.Lt;
import io.gatling.commons.stats.assertion.Lte;
import io.gatling.commons.stats.assertion.Max$;
import io.gatling.commons.stats.assertion.Mean$;
import io.gatling.commons.stats.assertion.MeanRequestsPerSecondTarget$;
import io.gatling.commons.stats.assertion.Min$;
import io.gatling.commons.stats.assertion.PercentTarget;
import io.gatling.commons.stats.assertion.Percentiles;
import io.gatling.commons.stats.assertion.ResponseTime$;
import io.gatling.commons.stats.assertion.StandardDeviation$;
import io.gatling.commons.stats.assertion.SuccessfulRequests$;
import io.gatling.commons.stats.assertion.Target;
import io.gatling.commons.stats.assertion.TimeMetric;
import io.gatling.commons.stats.assertion.TimeSelection;
import io.gatling.commons.stats.assertion.TimeTarget;
import io.gatling.core.Predef;
import io.gatling.core.javaapi.internal.Converters;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class Assertion {
    private final io.gatling.commons.stats.assertion.Assertion wrapped;

    Assertion(io.gatling.commons.stats.assertion.Assertion assertion) {
        this.wrapped = assertion;
    }

    public io.gatling.commons.stats.assertion.Assertion asScala() {
        return this.wrapped;
    }

    public static final class WithPathAndTarget<T extends Number> {
        private final AssertionPath path;
        private final Target target;

        private WithPathAndTarget(AssertionPath assertionPath, Target target) {
            this.path = assertionPath;
            this.target = target;
        }

        private Assertion next(Condition condition) {
            return new Assertion(new io.gatling.commons.stats.assertion.Assertion(this.path, this.target, condition));
        }

        @Nonnull
        public Assertion lt(T t) {
            return this.next((Condition)new Lt(((Number)t).doubleValue()));
        }

        @Nonnull
        public Assertion lte(T t) {
            return this.next((Condition)new Lte(((Number)t).doubleValue()));
        }

        @Nonnull
        public Assertion gt(T t) {
            return this.next((Condition)new Gt(((Number)t).doubleValue()));
        }

        @Nonnull
        public Assertion gte(T t) {
            return this.next((Condition)new Gte(((Number)t).doubleValue()));
        }

        @Nonnull
        public Assertion between(T t, T t2) {
            return this.between(t, t2, true);
        }

        @Nonnull
        public Assertion between(T t, T t2, boolean bl) {
            return this.next((Condition)new Between(((Number)t).doubleValue(), ((Number)t2).doubleValue(), bl));
        }

        @Nonnull
        public Assertion around(T t, T t2) {
            return this.around(t, t2, true);
        }

        @Nonnull
        public Assertion around(T t, T t2, boolean bl) {
            return this.next((Condition)new Between(((Number)t).doubleValue() - ((Number)t2).doubleValue(), ((Number)t).doubleValue() + ((Number)t2).doubleValue(), bl));
        }

        public Assertion deviatesAround(T t, double d) {
            return this.deviatesAround(t, d, true);
        }

        public Assertion deviatesAround(T t, double d, boolean bl) {
            double d2 = Math.floor(((Number)t).doubleValue() * d);
            return this.next((Condition)new Between(((Number)t).doubleValue() - d2, ((Number)t).doubleValue() + d2, bl));
        }

        @Nonnull
        public Assertion is(T t) {
            return this.next((Condition)new Is(((Number)t).doubleValue()));
        }

        @Nonnull
        public Assertion in(T ... TArray) {
            return this.in(Arrays.stream(TArray).collect(Collectors.toSet()));
        }

        @Nonnull
        public Assertion in(Set<T> set) {
            return this.next((Condition)new In(Converters.toScalaSeq(set.stream().map(number -> number.doubleValue()).collect(Collectors.toList())).toList()));
        }
    }

    public static final class WithPathAndCountMetric {
        private final AssertionPath path;
        private final CountMetric metric;

        private WithPathAndCountMetric(AssertionPath assertionPath, CountMetric countMetric) {
            this.path = assertionPath;
            this.metric = countMetric;
        }

        @Nonnull
        public WithPathAndTarget<Long> count() {
            return new WithPathAndTarget<Long>(this.path, (Target)new CountTarget(this.metric));
        }

        @Nonnull
        public WithPathAndTarget<Double> percent() {
            return new WithPathAndTarget<Double>(this.path, (Target)new PercentTarget(this.metric));
        }
    }

    public static final class WithPathAndTimeMetric {
        private final AssertionPath path;
        private final TimeMetric metric;

        private WithPathAndTimeMetric(AssertionPath assertionPath, TimeMetric timeMetric) {
            this.path = assertionPath;
            this.metric = timeMetric;
        }

        private WithPathAndTarget<Integer> next(TimeSelection timeSelection) {
            return new WithPathAndTarget<Integer>(this.path, (Target)new TimeTarget(this.metric, timeSelection));
        }

        @Nonnull
        public WithPathAndTarget<Integer> min() {
            return this.next((TimeSelection)Min$.MODULE$);
        }

        @Nonnull
        public WithPathAndTarget<Integer> max() {
            return this.next((TimeSelection)Max$.MODULE$);
        }

        @Nonnull
        public WithPathAndTarget<Integer> mean() {
            return this.next((TimeSelection)Mean$.MODULE$);
        }

        @Nonnull
        public WithPathAndTarget<Integer> stdDev() {
            return this.next((TimeSelection)StandardDeviation$.MODULE$);
        }

        @Nonnull
        public WithPathAndTarget<Integer> percentile1() {
            return this.percentile(Predef.configuration().charting().indicators().percentile1());
        }

        @Nonnull
        public WithPathAndTarget<Integer> percentile2() {
            return this.percentile(Predef.configuration().charting().indicators().percentile2());
        }

        @Nonnull
        public WithPathAndTarget<Integer> percentile3() {
            return this.percentile(Predef.configuration().charting().indicators().percentile3());
        }

        @Nonnull
        public WithPathAndTarget<Integer> percentile4() {
            return this.percentile(Predef.configuration().charting().indicators().percentile4());
        }

        @Nonnull
        public WithPathAndTarget<Integer> percentile(double d) {
            return this.next((TimeSelection)new Percentiles(d));
        }
    }

    public static final class WithPath {
        private final AssertionPath path;

        WithPath(AssertionPath assertionPath) {
            this.path = assertionPath;
        }

        @Nonnull
        public WithPathAndTimeMetric responseTime() {
            return new WithPathAndTimeMetric(this.path, (TimeMetric)ResponseTime$.MODULE$);
        }

        @Nonnull
        public WithPathAndCountMetric allRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)AllRequests$.MODULE$);
        }

        @Nonnull
        public WithPathAndCountMetric failedRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)FailedRequests$.MODULE$);
        }

        @Nonnull
        public WithPathAndCountMetric successfulRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)SuccessfulRequests$.MODULE$);
        }

        @Nonnull
        public WithPathAndTarget<Double> requestsPerSec() {
            return new WithPathAndTarget<Double>(this.path, (Target)MeanRequestsPerSecondTarget$.MODULE$);
        }
    }
}

