/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.javaapi;

import io.gatling.core.controller.inject.open.AtOnceOpenInjection;
import io.gatling.core.controller.inject.open.NothingForOpenInjection;
import io.gatling.core.controller.inject.open.OpenInjectionBuilder;
import io.gatling.core.controller.inject.open.StairsUsersPerSecCompositeStep;
import io.gatling.core.javaapi.internal.Converters;
import io.gatling.core.javaapi.internal.OpenInjectionSteps;
import java.time.Duration;
import javax.annotation.Nonnull;

public class OpenInjectionStep {
    private final io.gatling.core.controller.inject.open.OpenInjectionStep wrapped;

    private OpenInjectionStep(@Nonnull io.gatling.core.controller.inject.open.OpenInjectionStep openInjectionStep) {
        this.wrapped = openInjectionStep;
    }

    @Nonnull
    public static OpenInjectionStep atOnceUsers(int n) {
        return new OpenInjectionStep((io.gatling.core.controller.inject.open.OpenInjectionStep)new AtOnceOpenInjection((long)n));
    }

    @Nonnull
    public static OpenInjectionStep nothingFor(@Nonnull Duration duration) {
        return new OpenInjectionStep((io.gatling.core.controller.inject.open.OpenInjectionStep)new NothingForOpenInjection(Converters.toScalaDuration(duration)));
    }

    @Nonnull
    public io.gatling.core.controller.inject.open.OpenInjectionStep asScala() {
        return this.wrapped;
    }

    public static final class Stairs {
        private final double rateIncrement;

        Stairs(double d) {
            this.rateIncrement = d;
        }

        @Nonnull
        public Times times(int n) {
            return new Times(this.rateIncrement, n);
        }

        public static final class Composite
        extends OpenInjectionStep {
            Composite(StairsUsersPerSecCompositeStep stairsUsersPerSecCompositeStep) {
                super((io.gatling.core.controller.inject.open.OpenInjectionStep)stairsUsersPerSecCompositeStep);
            }

            private StairsUsersPerSecCompositeStep wrapped() {
                return (StairsUsersPerSecCompositeStep)this.asScala();
            }

            @Nonnull
            public Composite startingFrom(double d) {
                return new Composite(this.wrapped().startingFrom(d));
            }

            @Nonnull
            public Composite separatedByRampsLasting(int n) {
                return this.separatedByRampsLasting(Duration.ofSeconds(n));
            }

            @Nonnull
            public Composite separatedByRampsLasting(@Nonnull Duration duration) {
                return new Composite(this.wrapped().separatedByRampsLasting(Converters.toScalaDuration(duration)));
            }
        }

        public static final class Times {
            private final double rateIncrement;
            private final int levels;

            private Times(double d, int n) {
                this.rateIncrement = d;
                this.levels = n;
            }

            @Nonnull
            public Composite eachLevelLasting(int n) {
                return this.eachLevelLasting(Duration.ofSeconds(n));
            }

            @Nonnull
            public Composite eachLevelLasting(@Nonnull Duration duration) {
                return new Composite(OpenInjectionSteps.newEachLevelLasting(this.rateIncrement, this.levels).eachLevelLasting(Converters.toScalaDuration(duration)));
            }
        }
    }

    public static final class RampRate {
        private final double from;

        RampRate(double d) {
            this.from = d;
        }

        @Nonnull
        public During to(double d) {
            return new During(this.from, d);
        }

        public static final class During {
            private final double from;
            private final double to;

            private During(double d, double d2) {
                this.from = d;
                this.to = d2;
            }

            @Nonnull
            public OpenInjectionStep during(int n) {
                return this.during(Duration.ofSeconds(n));
            }

            @Nonnull
            public OpenInjectionStep during(@Nonnull Duration duration) {
                return new OpenInjectionStep((io.gatling.core.controller.inject.open.OpenInjectionStep)OpenInjectionSteps.newRampRateTo(this.from, this.to).during(Converters.toScalaDuration(duration)));
            }
        }
    }

    public static final class ConstantRate {
        private final OpenInjectionBuilder.ConstantRate wrapped;

        ConstantRate(double d) {
            this.wrapped = new OpenInjectionBuilder.ConstantRate(d);
        }

        @Nonnull
        public OpenInjectionStep during(int n) {
            return this.during(Duration.ofSeconds(n));
        }

        @Nonnull
        public OpenInjectionStep during(@Nonnull Duration duration) {
            return new OpenInjectionStep((io.gatling.core.controller.inject.open.OpenInjectionStep)this.wrapped.during(Converters.toScalaDuration(duration)));
        }
    }

    public static final class Heaviside {
        private final OpenInjectionBuilder.Heaviside wrapped;

        Heaviside(int n) {
            this.wrapped = new OpenInjectionBuilder.Heaviside(n);
        }

        @Nonnull
        public OpenInjectionStep during(int n) {
            return this.during(Duration.ofSeconds(n));
        }

        @Nonnull
        public OpenInjectionStep during(@Nonnull Duration duration) {
            return new OpenInjectionStep(this.wrapped.during(Converters.toScalaDuration(duration)));
        }
    }

    public static final class Ramp {
        private final OpenInjectionBuilder.Ramp wrapped;

        Ramp(int n) {
            this.wrapped = new OpenInjectionBuilder.Ramp(n);
        }

        @Nonnull
        public OpenInjectionStep during(int n) {
            return this.during(Duration.ofSeconds(n));
        }

        @Nonnull
        public OpenInjectionStep during(@Nonnull Duration duration) {
            return new OpenInjectionStep(this.wrapped.during(Converters.toScalaDuration(duration)));
        }
    }
}

