/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.javaapi;

import io.gatling.core.javaapi.Session;
import io.gatling.core.javaapi.internal.Converters;
import io.gatling.core.javaapi.internal.Expressions;
import io.gatling.core.pause.Constant$;
import io.gatling.core.pause.Disabled$;
import io.gatling.core.pause.Exponential$;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class PauseType {
    public static final PauseType Disabled = new PauseType(){

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return Disabled$.MODULE$;
        }
    };
    public static final PauseType Constant = new PauseType(){

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return Constant$.MODULE$;
        }
    };
    public static final PauseType Exponential = new PauseType(){

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return Exponential$.MODULE$;
        }
    };

    private PauseType() {
    }

    public abstract io.gatling.core.pause.PauseType asScala();

    public static final class UniformDuration
    extends PauseType {
        private final Duration plusOrMinus;

        public UniformDuration(@Nonnull Duration duration) {
            this.plusOrMinus = duration;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.UniformDuration(Converters.toScalaDuration(this.plusOrMinus));
        }
    }

    public static final class UniformPercentage
    extends PauseType {
        private final double plusOrMinus;

        UniformPercentage(double d) {
            this.plusOrMinus = d;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.UniformPercentage(this.plusOrMinus);
        }
    }

    public static final class Custom
    extends PauseType {
        private final Function<Session, Long> f;

        Custom(@Nonnull Function<Session, Long> function) {
            this.f = function;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.Custom(Expressions.javaLongFunctionToExpression(this.f));
        }
    }

    public static final class NormalWithStdDevDuration
    extends PauseType {
        private final Duration stdDev;

        NormalWithStdDevDuration(@Nonnull Duration duration) {
            this.stdDev = duration;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.NormalWithStdDevDuration(Converters.toScalaDuration(this.stdDev));
        }
    }

    public static final class NormalWithPercentageDuration
    extends PauseType {
        private final double stdDev;

        NormalWithPercentageDuration(double d) {
            this.stdDev = d;
        }

        @Override
        public io.gatling.core.pause.PauseType asScala() {
            return new io.gatling.core.pause.NormalWithPercentageDuration(this.stdDev);
        }
    }
}

