/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.javaapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.mitchellbosecke.pebble.extension.Extension;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.commons.stats.assertion.Details;
import io.gatling.commons.stats.assertion.ForAll$;
import io.gatling.commons.stats.assertion.Global$;
import io.gatling.core.body.BodyProcessors;
import io.gatling.core.body.BodyWithBytesExpression;
import io.gatling.core.body.ElFileBodies;
import io.gatling.core.body.PebbleFileBodies;
import io.gatling.core.body.RawFileBodies;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.css.CssSelectors;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jmespath.JmesPaths;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.jsonpath.JsonPaths;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckType;
import io.gatling.core.check.regex.Patterns;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.core.check.xpath.XmlParsers;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.throttle.Hold;
import io.gatling.core.controller.throttle.Jump;
import io.gatling.core.javaapi.ActionBuilder;
import io.gatling.core.javaapi.Assertion;
import io.gatling.core.javaapi.Body;
import io.gatling.core.javaapi.ChainBuilder;
import io.gatling.core.javaapi.CheckBuilder;
import io.gatling.core.javaapi.ClosedInjectionStep;
import io.gatling.core.javaapi.FeederBuilder;
import io.gatling.core.javaapi.Filter;
import io.gatling.core.javaapi.OpenInjectionStep;
import io.gatling.core.javaapi.PauseType;
import io.gatling.core.javaapi.Possibility;
import io.gatling.core.javaapi.ScenarioBuilder;
import io.gatling.core.javaapi.Session;
import io.gatling.core.javaapi.StructureBuilder;
import io.gatling.core.javaapi.ThrottleStep;
import io.gatling.core.javaapi.condition.DoIf;
import io.gatling.core.javaapi.condition.DoIfEquals;
import io.gatling.core.javaapi.condition.DoIfEqualsOrElse;
import io.gatling.core.javaapi.condition.DoIfOrElse;
import io.gatling.core.javaapi.condition.DoSwitch;
import io.gatling.core.javaapi.condition.DoSwitchOrElse;
import io.gatling.core.javaapi.condition.RandomSwitchOrElse;
import io.gatling.core.javaapi.error.Errors;
import io.gatling.core.javaapi.group.Groups;
import io.gatling.core.javaapi.internal.Converters;
import io.gatling.core.javaapi.internal.CoreCheckBuilders;
import io.gatling.core.javaapi.internal.CoreCheckType;
import io.gatling.core.javaapi.internal.Expressions;
import io.gatling.core.javaapi.loop.AsLongAs;
import io.gatling.core.javaapi.loop.AsLongAsDuring;
import io.gatling.core.javaapi.loop.DoWhile;
import io.gatling.core.javaapi.loop.DoWhileDuring;
import io.gatling.core.javaapi.loop.During;
import io.gatling.core.javaapi.loop.ForEach;
import io.gatling.core.javaapi.loop.Forever;
import io.gatling.core.javaapi.loop.Repeat;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;

public final class Predef {
    public static PauseType disabledPauses = PauseType.Disabled;
    public static PauseType constantPauses = PauseType.Constant;
    public static PauseType exponentialPauses = PauseType.Exponential;
    public static final Function<Body, Body.WithBytes> gzipBody = body -> new Body.WithBytes((BodyWithBytesExpression)BodyProcessors.gzip().apply((Object)body.asScala()));

    private Predef() {
    }

    @Nonnull
    public static ScenarioBuilder scenario(@Nonnull String string) {
        return new ScenarioBuilder(string);
    }

    @Nonnull
    public static Filter.AllowList AllowList(String ... stringArray) {
        return Predef.AllowList(Arrays.asList(stringArray));
    }

    @Nonnull
    public static Filter.AllowList AllowList(@Nonnull List<String> list) {
        return new Filter.AllowList(list);
    }

    @Nonnull
    public static Filter.DenyList DenyList(String ... stringArray) {
        return Predef.DenyList(Arrays.asList(stringArray));
    }

    @Nonnull
    public static Filter.DenyList DenyList(@Nonnull List<String> list) {
        return new Filter.DenyList(list);
    }

    @Nonnull
    public static ChainBuilder exec(@Nonnull Function<Session, Session> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(function);
    }

    @Nonnull
    public static ChainBuilder exec(@Nonnull ActionBuilder actionBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(actionBuilder);
    }

    @Nonnull
    public static <WB extends io.gatling.core.structure.StructureBuilder<WB>> ChainBuilder exec(StructureBuilder<?, WB> ... structureBuilderArray) {
        return Predef.exec(Arrays.asList(structureBuilderArray));
    }

    @Nonnull
    public static <WB extends io.gatling.core.structure.StructureBuilder<WB>> ChainBuilder exec(@Nonnull List<StructureBuilder<?, WB>> list) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(list);
    }

    @Nonnull
    public static ChainBuilder pause(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l);
    }

    @Nonnull
    public static ChainBuilder pause(long l, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2);
    }

    @Nonnull
    public static ChainBuilder pause(long l, long l2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Duration duration, @Nonnull Duration duration2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string, @Nonnull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull String string, @Nonnull String string2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function, @Nonnull Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2);
    }

    @Nonnull
    public static ChainBuilder pause(@Nonnull Function<Session, Duration> function, @Nonnull Function<Session, Duration> function2, @Nonnull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2, pauseType);
    }

    @Nonnull
    public static ChainBuilder pace(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l);
    }

    @Nonnull
    public static ChainBuilder pace(long l, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull String string, @Nonnull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, string);
    }

    @Nonnull
    public static ChainBuilder pace(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2);
    }

    @Nonnull
    public static ChainBuilder pace(long l, long l2, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Duration duration, @Nonnull Duration duration2, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2, string);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2, string3);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function, Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2);
    }

    @Nonnull
    public static ChainBuilder pace(@Nonnull Function<Session, Duration> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2, string);
    }

    @Nonnull
    public static ChainBuilder rendezVous(int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.rendezVous(n);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Supplier<Iterator<Map<String, Object>>> supplier) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull Iterator<Map<String, Object>> iterator) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator);
    }

    @Nonnull
    public static ChainBuilder feed(@Nonnull FeederBuilder<?> feederBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder);
    }

    @Nonnull
    public static Repeat.Loop<ChainBuilder> repeat(int n) {
        return ChainBuilder.EMPTY.repeat(n);
    }

    @Nonnull
    public static Repeat.Loop<ChainBuilder> repeat(int n, @Nonnull String string) {
        return ChainBuilder.EMPTY.repeat(n, string);
    }

    @Nonnull
    public static Repeat.Loop<ChainBuilder> repeat(@Nonnull String string) {
        return ChainBuilder.EMPTY.repeat(string);
    }

    @Nonnull
    public static Repeat.Loop<ChainBuilder> repeat(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.repeat(string, string2);
    }

    @Nonnull
    public static Repeat.Loop<ChainBuilder> repeat(@Nonnull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.repeat(function);
    }

    @Nonnull
    public static Repeat.Loop<ChainBuilder> repeat(@Nonnull Function<Session, Integer> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.repeat(function, string);
    }

    @Nonnull
    public static ForEach.Loop<ChainBuilder> foreach(@Nonnull List<?> list, String string) {
        return ChainBuilder.EMPTY.foreach(list, string);
    }

    @Nonnull
    public static ForEach.Loop<ChainBuilder> foreach(@Nonnull List<?> list, String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.foreach(list, string, string2);
    }

    @Nonnull
    public static ForEach.Loop<ChainBuilder> foreach(@Nonnull String string, String string2) {
        return ChainBuilder.EMPTY.foreach(string, string2);
    }

    @Nonnull
    public static ForEach.Loop<ChainBuilder> foreach(@Nonnull String string, String string2, @Nonnull String string3) {
        return ChainBuilder.EMPTY.foreach(string, string2, string3);
    }

    @Nonnull
    public static ForEach.Loop<ChainBuilder> foreach(@Nonnull Function<Session, List<?>> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.foreach(function, string);
    }

    @Nonnull
    public static ForEach.Loop<ChainBuilder> foreach(@Nonnull Function<Session, List<?>> function, @Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.foreach(function, string, string2);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(long l) {
        return ChainBuilder.EMPTY.during(l);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(long l, boolean bl) {
        return ChainBuilder.EMPTY.during(l, bl);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(long l, @Nonnull String string) {
        return ChainBuilder.EMPTY.during(l, string);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(long l, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(l, string, bl);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Duration duration) {
        return ChainBuilder.EMPTY.during(duration);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, bl);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Duration duration, @Nonnull String string) {
        return ChainBuilder.EMPTY.during(duration, string);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Duration duration, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, string, bl);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull String string) {
        return ChainBuilder.EMPTY.during(string);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(string, bl);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.during(string, string2);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.during(string, string2, bl);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.during(function);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.during(function, bl);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Function<Session, Duration> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.during(function, string);
    }

    @Nonnull
    public static During.Loop<ChainBuilder> during(@Nonnull Function<Session, Duration> function, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(function, string, bl);
    }

    @Nonnull
    public static Forever.Loop<ChainBuilder> forever() {
        return ChainBuilder.EMPTY.forever();
    }

    @Nonnull
    public static Forever.Loop<ChainBuilder> forever(@Nonnull String string) {
        return ChainBuilder.EMPTY.forever(string);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAs(string);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.asLongAs(string, string2);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, bl);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, string2, bl);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.asLongAs(function);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAs(function, string);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, bl);
    }

    @Nonnull
    public static AsLongAs.Loop<ChainBuilder> asLongAs(@Nonnull Function<Session, Boolean> function, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, string, bl);
    }

    @Nonnull
    public static DoWhile.Loop<ChainBuilder> doWhile(@Nonnull String string) {
        return ChainBuilder.EMPTY.doWhile(string);
    }

    @Nonnull
    public static DoWhile.Loop<ChainBuilder> doWhile(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doWhile(string, string2);
    }

    @Nonnull
    public static DoWhile.Loop<ChainBuilder> doWhile(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doWhile(function);
    }

    @Nonnull
    public static DoWhile.Loop<ChainBuilder> doWhile(@Nonnull Function<Session, Boolean> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.doWhile(function, string);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, bl);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3, bl);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, bl);
    }

    @Nonnull
    public static AsLongAsDuring.Loop<ChainBuilder> asLongAsDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string, bl);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, bl);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3, bl);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, @Nonnull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, bl);
    }

    @Nonnull
    public static DoWhileDuring.Loop<ChainBuilder> doWhileDuring(@Nonnull Function<Session, Boolean> function, @Nonnull Function<Session, Duration> function2, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string, bl);
    }

    @Nonnull
    public static DoIf.Then<ChainBuilder> doIf(@Nonnull String string) {
        return ChainBuilder.EMPTY.doIf(string);
    }

    @Nonnull
    public static DoIf.Then<ChainBuilder> doIf(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIf(function);
    }

    @Nonnull
    public static DoIfOrElse.Then<ChainBuilder> doIfOrElse(@Nonnull String string) {
        return ChainBuilder.EMPTY.doIfOrElse(string);
    }

    @Nonnull
    public static DoIfOrElse.Then<ChainBuilder> doIfOrElse(@Nonnull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIfOrElse(function);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.doIfEquals(string, string2);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull String string, @Nonnull Object object) {
        return ChainBuilder.EMPTY.doIfEquals(string, object);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull String string, @Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEquals(string, function);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull Function<Session, Object> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.doIfEquals(function, string);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull Function<Session, Object> function, Object object) {
        return ChainBuilder.EMPTY.doIfEquals(function, object);
    }

    @Nonnull
    public static DoIfEquals.Then<ChainBuilder> doIfEquals(@Nonnull Function<Session, Object> function, @Nonnull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEquals(function, function2);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(String string, String string2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, string2);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull String string, @Nonnull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, object);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull String string, @Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, function);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull Function<Session, Object> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, string);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull Function<Session, Object> function, @Nonnull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, object);
    }

    @Nonnull
    public static DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@Nonnull Function<Session, Object> function, @Nonnull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, function2);
    }

    @Nonnull
    public static DoSwitch.Possibilities<ChainBuilder> doSwitch(@Nonnull String string) {
        return ChainBuilder.EMPTY.doSwitch(string);
    }

    @Nonnull
    public static DoSwitch.Possibilities<ChainBuilder> doSwitch(@Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitch(function);
    }

    @Nonnull
    public static DoSwitchOrElse.Possibilities<ChainBuilder> doSwitchOrElse(@Nonnull String string) {
        return ChainBuilder.EMPTY.doSwitchOrElse(string);
    }

    @Nonnull
    public static DoSwitchOrElse.Possibilities<ChainBuilder> doSwitchOrElse(@Nonnull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitchOrElse(function);
    }

    @Nonnull
    public static ChainBuilder randomSwitch(Possibility.WithWeight ... withWeightArray) {
        return (ChainBuilder)ChainBuilder.EMPTY.randomSwitch(withWeightArray);
    }

    @Nonnull
    public static ChainBuilder randomSwitch(@Nonnull List<Possibility.WithWeight> list) {
        return (ChainBuilder)ChainBuilder.EMPTY.randomSwitch(list);
    }

    @Nonnull
    public static RandomSwitchOrElse.OrElse<ChainBuilder> randomSwitchOrElse(Possibility.WithWeight ... withWeightArray) {
        return ChainBuilder.EMPTY.randomSwitchOrElse(withWeightArray);
    }

    @Nonnull
    public static RandomSwitchOrElse.OrElse<ChainBuilder> randomSwitchOrElse(@Nonnull List<Possibility.WithWeight> list) {
        return ChainBuilder.EMPTY.randomSwitchOrElse(list);
    }

    @Nonnull
    public static ChainBuilder uniformRandomSwitch(ChainBuilder ... chainBuilderArray) {
        return (ChainBuilder)ChainBuilder.EMPTY.uniformRandomSwitch(chainBuilderArray);
    }

    @Nonnull
    public static ChainBuilder uniformRandomSwitch(@Nonnull List<ChainBuilder> list) {
        return (ChainBuilder)ChainBuilder.EMPTY.uniformRandomSwitch(list);
    }

    @Nonnull
    public static ChainBuilder roundRobinSwitch(ChainBuilder ... chainBuilderArray) {
        return (ChainBuilder)ChainBuilder.EMPTY.roundRobinSwitch(chainBuilderArray);
    }

    @Nonnull
    public static ChainBuilder roundRobinSwitch(@Nonnull List<ChainBuilder> list) {
        return (ChainBuilder)ChainBuilder.EMPTY.roundRobinSwitch(list);
    }

    @Nonnull
    public static ChainBuilder exitBlockOnFail(@Nonnull ChainBuilder chainBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitBlockOnFail(chainBuilder);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(int n) {
        return ChainBuilder.EMPTY.tryMax(n);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(int n, @Nonnull String string) {
        return ChainBuilder.EMPTY.tryMax(n, string);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull String string) {
        return ChainBuilder.EMPTY.tryMax(string);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull String string, @Nonnull String string2) {
        return ChainBuilder.EMPTY.tryMax(string, string2);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.tryMax(function);
    }

    @Nonnull
    public static Errors.TryMax<ChainBuilder> tryMax(@Nonnull Function<Session, Integer> function, @Nonnull String string) {
        return ChainBuilder.EMPTY.tryMax(function, string);
    }

    @Nonnull
    public static ChainBuilder exitHereIf(@Nonnull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(string);
    }

    @Nonnull
    public static ChainBuilder exitHereIf(@Nonnull Function<Session, Boolean> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(function);
    }

    @Nonnull
    public static ChainBuilder exitHere() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHere();
    }

    @Nonnull
    public static ChainBuilder exitHereIfFailed() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIfFailed();
    }

    @Nonnull
    public static Groups.Grouping<ChainBuilder> group(@Nonnull String string) {
        return ChainBuilder.EMPTY.group(string);
    }

    @Nonnull
    public static Groups.Grouping<ChainBuilder> group(@Nonnull Function<Session, String> function) {
        return ChainBuilder.EMPTY.group(function);
    }

    @Nonnull
    public static PauseType normalPausesWithPercentageDuration(double d) {
        return new PauseType.NormalWithPercentageDuration(d);
    }

    @Nonnull
    public static PauseType normalPausesWithStdDevDuration(@Nonnull Duration duration) {
        return new PauseType.NormalWithStdDevDuration(duration);
    }

    @Nonnull
    public static PauseType customPauses(@Nonnull Function<Session, Long> function) {
        return new PauseType.Custom(function);
    }

    @Nonnull
    public static PauseType uniformPausesPlusOrMinusPercentage(double d) {
        return new PauseType.UniformPercentage(d);
    }

    @Nonnull
    public static PauseType uniformPausesPlusOrMinusDuration(@Nonnull Duration duration) {
        return new PauseType.UniformDuration(duration);
    }

    @Nonnull
    public static CheckBuilder.Find<String> bodyString() {
        return new CheckBuilder.Find.Default(io.gatling.core.Predef.bodyString(), CoreCheckType.BodyString, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.Find<byte[]> bodyBytes() {
        return new CheckBuilder.Find.Default(io.gatling.core.Predef.bodyBytes(), CoreCheckType.BodyBytes, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.Find<Integer> bodyLength() {
        return CoreCheckBuilders.bodyLength();
    }

    @Nonnull
    public static CheckBuilder.Find<InputStream> bodyStream() {
        return new CheckBuilder.Find.Default(io.gatling.core.Predef.bodyStream(), CoreCheckType.BodyStream, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Integer> substring(@Nonnull String string) {
        return CoreCheckBuilders.substring(string);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Integer> substring(@Nonnull Function<Session, String> function) {
        return CoreCheckBuilders.substring(function);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull String string) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.xpath(Expressions.toStringExpression(string), (XmlParsers)io.gatling.core.Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.xpath(Expressions.javaFunctionToExpression(function), (XmlParsers)io.gatling.core.Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull String string, @Nonnull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.xpath(Expressions.toStringExpression(string), Converters.toScalaMap(map), (XmlParsers)io.gatling.core.Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> xpath(@Nonnull Function<Session, String> function, @Nonnull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.xpath(Expressions.javaFunctionToExpression(function), Converters.toScalaMap(map), (XmlParsers)io.gatling.core.Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> css(@Nonnull String string) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.css(Expressions.toStringExpression(string), (CssSelectors)io.gatling.core.Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> css(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.css(Expressions.javaFunctionToExpression(function), (CssSelectors)io.gatling.core.Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> css(@Nonnull String string, @Nonnull String string2) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.css(Expressions.toStringExpression(string), (String)string2, (CssSelectors)io.gatling.core.Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<String> css(@Nonnull Function<Session, String> function, @Nonnull String string) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.css(Expressions.javaFunctionToExpression(function), (String)string, (CssSelectors)io.gatling.core.Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Map<String, Object>> form(@Nonnull String string) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.form(Expressions.toStringExpression(string), (CssSelectors)io.gatling.core.Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Converters::toJavaMap);
    }

    @Nonnull
    public static CheckBuilder.MultipleFind<Map<String, Object>> form(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(io.gatling.core.Predef.form(Expressions.javaFunctionToExpression(function), (CssSelectors)io.gatling.core.Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Converters::toJavaMap);
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonPath(@Nonnull String string) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)io.gatling.core.Predef.jsonPath(Expressions.toStringExpression(string), (JsonPaths)io.gatling.core.Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)io.gatling.core.Predef.jsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)io.gatling.core.Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jmesPath(@Nonnull String string) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)io.gatling.core.Predef.jmesPath(Expressions.toStringExpression(string), (JmesPaths)io.gatling.core.Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jmesPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)io.gatling.core.Predef.jmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)io.gatling.core.Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@Nonnull String string) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)io.gatling.core.Predef.jsonpJsonPath(Expressions.toStringExpression(string), (JsonPaths)io.gatling.core.Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)io.gatling.core.Predef.jsonpJsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)io.gatling.core.Predef.defaultJsonPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jsonpJmesPath(@Nonnull String string) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)io.gatling.core.Predef.jsonpJmesPath(Expressions.toStringExpression(string), (JmesPaths)io.gatling.core.Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.JsonOfTypeFind jsonpJmesPath(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)io.gatling.core.Predef.jsonpJmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)io.gatling.core.Predef.defaultJmesPaths()));
    }

    @Nonnull
    public static CheckBuilder.CaptureGroupCheckBuilder regex(@Nonnull String string) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)io.gatling.core.Predef.regex(Expressions.toStringExpression(string), (Patterns)io.gatling.core.Predef.defaultPatterns()));
    }

    @Nonnull
    public static CheckBuilder.CaptureGroupCheckBuilder regex(@Nonnull Function<Session, String> function) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)io.gatling.core.Predef.regex(Expressions.javaFunctionToExpression(function), (Patterns)io.gatling.core.Predef.defaultPatterns()));
    }

    public static void registerJmesPathFunctions(io.burt.jmespath.function.Function ... functionArray) {
        io.gatling.core.Predef.registerJmesPathFunctions(Converters.toScalaSeq(functionArray));
    }

    @Nonnull
    public static CheckBuilder.Find<String> md5() {
        return new CheckBuilder.Find.Default(io.gatling.core.Predef.md5(), CoreCheckType.Md5, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.Find<String> sha1() {
        return new CheckBuilder.Find.Default(io.gatling.core.Predef.sha1(), CoreCheckType.Sha1, Function.identity());
    }

    @Nonnull
    public static CheckBuilder.Find<Integer> responseTimeInMillis() {
        return CoreCheckBuilders.responseTimeInMillis();
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> csv(@Nonnull String string) {
        return FeederBuilder.Impl.csv(string);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> csv(@Nonnull String string, char c) {
        return FeederBuilder.Impl.csv(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> ssv(@Nonnull String string) {
        return FeederBuilder.Impl.ssv(string);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> ssv(@Nonnull String string, char c) {
        return FeederBuilder.Impl.ssv(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> tsv(@Nonnull String string) {
        return FeederBuilder.Impl.tsv(string);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> tsv(@Nonnull String string, char c) {
        return FeederBuilder.Impl.tsv(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> separatedValues(@Nonnull String string, char c) {
        return FeederBuilder.Impl.separatedValues(string, c);
    }

    @Nonnull
    public static FeederBuilder.Batchable<String> separatedValues(@Nonnull String string, char c, char c2) {
        return FeederBuilder.Impl.separatedValues(string, c, c2);
    }

    @Nonnull
    public static FeederBuilder.FileBased<Object> jsonFile(@Nonnull String string) {
        return FeederBuilder.Impl.jsonFile(string);
    }

    @Nonnull
    public static FeederBuilder<Object> jsonUrl(String string) {
        return FeederBuilder.Impl.jsonUrl(string);
    }

    @Nonnull
    public static FeederBuilder<Object> arrayFeeder(@Nonnull Map<String, Object>[] mapArray) {
        scala.collection.immutable.Map[] mapArray2 = (scala.collection.immutable.Map[])Arrays.stream(mapArray).map(Converters::toScalaMap).toArray(scala.collection.immutable.Map[]::new);
        return new FeederBuilder.Impl<Object>(io.gatling.core.Predef.array2FeederBuilder((scala.collection.immutable.Map[])mapArray2, (GatlingConfiguration)io.gatling.core.Predef.configuration()));
    }

    @Nonnull
    public static FeederBuilder<Object> listFeeder(@Nonnull List<Map<String, Object>> list) {
        Seq seq = Converters.toScalaSeq(list.stream().map(Converters::toScalaMap).collect(Collectors.toList()));
        return new FeederBuilder.Impl<Object>(io.gatling.core.Predef.seq2FeederBuilder((IndexedSeq)seq.toIndexedSeq(), (GatlingConfiguration)io.gatling.core.Predef.configuration()));
    }

    @Nonnull
    public static OpenInjectionStep.Ramp rampUsers(int n) {
        return new OpenInjectionStep.Ramp(n);
    }

    @Nonnull
    public static OpenInjectionStep.Heaviside heavisideUsers(int n) {
        return new OpenInjectionStep.Heaviside(n);
    }

    @Nonnull
    public static OpenInjectionStep atOnceUsers(int n) {
        return OpenInjectionStep.atOnceUsers(n);
    }

    @Nonnull
    public static OpenInjectionStep.ConstantRate constantUsersPerSec(double d) {
        return new OpenInjectionStep.ConstantRate(d);
    }

    @Nonnull
    public static OpenInjectionStep.RampRate rampUsersPerSec(double d) {
        return new OpenInjectionStep.RampRate(d);
    }

    @Nonnull
    public static OpenInjectionStep nothingFor(int n) {
        return Predef.nothingFor(Duration.ofSeconds(n));
    }

    @Nonnull
    public static OpenInjectionStep nothingFor(@Nonnull Duration duration) {
        return OpenInjectionStep.nothingFor(duration);
    }

    @Nonnull
    public static OpenInjectionStep.Stairs incrementUsersPerSec(double d) {
        return new OpenInjectionStep.Stairs(d);
    }

    @Nonnull
    public static ClosedInjectionStep.Constant constantConcurrentUsers(int n) {
        return new ClosedInjectionStep.Constant(n);
    }

    @Nonnull
    public static ClosedInjectionStep.Ramp rampConcurrentUsers(int n) {
        return new ClosedInjectionStep.Ramp(n);
    }

    @Nonnull
    public static ClosedInjectionStep.Stairs incrementConcurrentUsers(int n) {
        return new ClosedInjectionStep.Stairs(n);
    }

    @Nonnull
    public static ThrottleStep.ReachIntermediate reachRps(int n) {
        return new ThrottleStep.ReachIntermediate(n);
    }

    @Nonnull
    public static ThrottleStep holdFor(int n) {
        return Predef.holdFor(Duration.ofSeconds(n));
    }

    @Nonnull
    public static ThrottleStep holdFor(@Nonnull Duration duration) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Hold(Converters.toScalaDuration(duration)));
    }

    @Nonnull
    public static ThrottleStep jumpToRps(int n) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Jump(n));
    }

    @Nonnull
    public static Assertion.WithPath global() {
        return new Assertion.WithPath((AssertionPath)Global$.MODULE$);
    }

    @Nonnull
    public static Assertion.WithPath forAll() {
        return new Assertion.WithPath((AssertionPath)ForAll$.MODULE$);
    }

    @Nonnull
    public static Assertion.WithPath details(String ... stringArray) {
        Seq seq = Converters.toScalaSeq(stringArray);
        return new Assertion.WithPath((AssertionPath)new Details(seq.toList()));
    }

    @Nonnull
    public static Body.WithString StringBody(@Nonnull String string) {
        return new Body.WithString(io.gatling.core.Predef.StringBody((String)string, (GatlingConfiguration)io.gatling.core.Predef.configuration()));
    }

    @Nonnull
    public static Body.WithString StringBody(@Nonnull Function<Session, String> function) {
        return new Body.WithString(io.gatling.core.Predef.StringBody(Expressions.javaFunctionToExpression(function), (GatlingConfiguration)io.gatling.core.Predef.configuration()));
    }

    @Nonnull
    public static Body.WithBytes RawFileBody(@Nonnull String string) {
        return new Body.WithBytes(io.gatling.core.Predef.RawFileBody(Expressions.toStringExpression(string), (RawFileBodies)io.gatling.core.Predef.rawFileBodies()));
    }

    @Nonnull
    public static Body.WithBytes RawFileBody(@Nonnull Function<Session, String> function) {
        return new Body.WithBytes(io.gatling.core.Predef.RawFileBody(Expressions.javaFunctionToExpression(function), (RawFileBodies)io.gatling.core.Predef.rawFileBodies()));
    }

    @Nonnull
    public static Body.WithString ElFileBody(@Nonnull String string) {
        return new Body.WithString(io.gatling.core.Predef.ElFileBody(Expressions.toStringExpression(string), (ElFileBodies)io.gatling.core.Predef.elFileBodies()));
    }

    @Nonnull
    public static Body.WithString ElFileBody(@Nonnull Function<Session, String> function) {
        return new Body.WithString(io.gatling.core.Predef.ElFileBody(Expressions.javaFunctionToExpression(function), (ElFileBodies)io.gatling.core.Predef.elFileBodies()));
    }

    @Nonnull
    public static Body.WithString PebbleStringBody(@Nonnull String string) {
        return new Body.WithString(io.gatling.core.Predef.PebbleStringBody((String)string, (GatlingConfiguration)io.gatling.core.Predef.configuration()));
    }

    @Nonnull
    public static Body.WithString PebbleFileBody(@Nonnull String string) {
        return new Body.WithString(io.gatling.core.Predef.PebbleFileBody(Expressions.toStringExpression(string), (PebbleFileBodies)io.gatling.core.Predef.pebbleFileBodies(), (GatlingConfiguration)io.gatling.core.Predef.configuration()));
    }

    @Nonnull
    public static Body.WithString PebbleFileBody(@Nonnull Function<Session, String> function) {
        return new Body.WithString(io.gatling.core.Predef.PebbleFileBody(Expressions.javaFunctionToExpression(function), (PebbleFileBodies)io.gatling.core.Predef.pebbleFileBodies(), (GatlingConfiguration)io.gatling.core.Predef.configuration()));
    }

    @Nonnull
    public static Body.WithBytes ByteArrayBody(@Nonnull byte[] byArray) {
        return new Body.WithBytes(io.gatling.core.Predef.ByteArrayBody(Expressions.toStaticValueExpression(byArray)));
    }

    @Nonnull
    public static Body.WithBytes ByteArrayBody(@Nonnull String string) {
        return new Body.WithBytes(io.gatling.core.Predef.ByteArrayBody(Expressions.toBytesExpression(string)));
    }

    @Nonnull
    public static Body.WithBytes ByteArrayBody(@Nonnull Function<Session, byte[]> function) {
        return new Body.WithBytes(io.gatling.core.Predef.ByteArrayBody(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public static Body InputStreamBody(@Nonnull Function<Session, InputStream> function) {
        return new Body.Default(io.gatling.core.Predef.InputStreamBody(Expressions.javaFunctionToExpression(function)));
    }

    public static void registerPebbleExtensions(Extension ... extensionArray) {
        io.gatling.core.Predef.registerPebbleExtensions(Converters.toScalaSeq(extensionArray));
    }
}

