/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.javaapi;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.javaapi.Assertion;
import io.gatling.core.javaapi.PauseType;
import io.gatling.core.javaapi.PopulationBuilder;
import io.gatling.core.javaapi.ProtocolBuilder;
import io.gatling.core.javaapi.Session;
import io.gatling.core.javaapi.ThrottleStep;
import io.gatling.core.javaapi.internal.Converters;
import io.gatling.core.protocol.Protocol;
import io.gatling.core.scenario.Simulation$;
import io.gatling.core.scenario.SimulationParams;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import scala.Option;

public abstract class Simulation {
    private List<PopulationBuilder> _populationBuilders;
    private Map<Class<? extends Protocol>, Protocol> _globalProtocols = new HashMap<Class<? extends Protocol>, Protocol>();
    private List<Assertion> _assertions = new ArrayList<Assertion>();
    private Duration _maxDuration;
    private PauseType _globalPauseType = PauseType.Constant;
    private List<ThrottleStep> _globalThrottleSteps = new ArrayList<ThrottleStep>();

    public void before() {
    }

    public void after() {
    }

    @Nonnull
    public SetUp setUp(PopulationBuilder ... populationBuilderArray) {
        return this.setUp(Arrays.asList(populationBuilderArray));
    }

    @Nonnull
    public SetUp setUp(@Nonnull List<PopulationBuilder> list) {
        if (this._populationBuilders != null) {
            throw new UnsupportedOperationException("Can only call setUp once");
        }
        this._populationBuilders = list;
        return new SetUp();
    }

    public SimulationParams params(GatlingConfiguration gatlingConfiguration) {
        return Simulation$.MODULE$.params(this.getClass().getName(), Converters.toScalaSeq(this._populationBuilders.stream().map(PopulationBuilder::asScala).collect(Collectors.toList())).toList(), Converters.toScalaMap(this._globalProtocols), Converters.toScalaSeq(this._assertions.stream().map(Assertion::asScala).collect(Collectors.toList())), Option.apply((Object)this._maxDuration).map(Converters::toScalaDuration), this._globalPauseType.asScala(), Converters.toScalaSeq(this._globalThrottleSteps.stream().map(ThrottleStep::asScala).collect(Collectors.toList())), () -> {
            this.before();
            return null;
        }, () -> {
            this.after();
            return null;
        }, gatlingConfiguration);
    }

    public class SetUp {
        private SetUp() {
        }

        @Nonnull
        public SetUp protocols(ProtocolBuilder ... protocolBuilderArray) {
            return this.protocols(Arrays.asList(protocolBuilderArray));
        }

        @Nonnull
        public SetUp protocols(@Nonnull List<ProtocolBuilder> list) {
            Simulation.this._globalProtocols = list.stream().map(ProtocolBuilder::protocol).collect(Collectors.toMap(Object::getClass, Function.identity()));
            return this;
        }

        @Nonnull
        public SetUp assertions(Assertion ... assertionArray) {
            return this.assertions(Arrays.asList(assertionArray));
        }

        @Nonnull
        public SetUp assertions(@Nonnull List<Assertion> list) {
            Simulation.this._assertions = list;
            return this;
        }

        @Nonnull
        public SetUp maxDuration(int n) {
            return this.maxDuration(Duration.ofSeconds(n));
        }

        @Nonnull
        public SetUp maxDuration(@Nonnull Duration duration) {
            Simulation.this._maxDuration = duration;
            return this;
        }

        @Nonnull
        public SetUp throttle(ThrottleStep ... throttleStepArray) {
            return this.throttle(Arrays.asList(throttleStepArray));
        }

        @Nonnull
        public SetUp throttle(@Nonnull List<ThrottleStep> list) {
            Simulation.this._globalThrottleSteps = list;
            return this;
        }

        @Nonnull
        public SetUp disablePauses() {
            return this.pauses(PauseType.Disabled);
        }

        @Nonnull
        public SetUp constantPauses() {
            return this.pauses(PauseType.Constant);
        }

        @Nonnull
        public SetUp exponentialPauses() {
            return this.pauses(PauseType.Exponential);
        }

        @Nonnull
        public SetUp customPauses(@Nonnull Function<Session, Long> function) {
            return this.pauses(new PauseType.Custom(function));
        }

        @Nonnull
        public SetUp uniformPauses(double d) {
            return this.pauses(new PauseType.UniformPercentage(d));
        }

        @Nonnull
        public SetUp uniformPauses(@Nonnull Duration duration) {
            return this.pauses(new PauseType.UniformDuration(duration));
        }

        @Nonnull
        public SetUp pauses(@Nonnull PauseType pauseType) {
            Simulation.this._globalPauseType = pauseType;
            return this;
        }
    }
}

