/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.javaapi.core.internal.Converters;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import scala.Option;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;

public final class Session {
    private final io.gatling.core.session.Session wrapped;

    public Session(io.gatling.core.session.Session session) {
        this.wrapped = session;
    }

    public <T> T get(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        return (T)(option.isDefined() ? option.get() : null);
    }

    public String getString(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        return option.isDefined() ? option.get().toString() : null;
    }

    public Integer getIntegerWrapper(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        if (option.isDefined()) {
            Object object = option.get();
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                return Integer.valueOf((String)object);
            }
            throw new ClassCastException(object + " is not an Integer: " + object.getClass());
        }
        return null;
    }

    public int getInt(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is undefined");
        }
        throw new ClassCastException(object + " is not an Integer: " + object.getClass());
    }

    public Long getLongWrapper(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        if (option.isDefined()) {
            Object object = option.get();
            if (object instanceof Integer) {
                return ((Integer)object).longValue();
            }
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof String) {
                return Long.valueOf((String)object);
            }
            throw new ClassCastException(object + " is not an Long: " + object.getClass());
        }
        return null;
    }

    public long getLong(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new ClassCastException(object + " is not an Long: " + object.getClass());
    }

    public Double getDoubleWrapper(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        if (option.isDefined()) {
            Object object = option.get();
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue();
            }
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof String) {
                return Double.valueOf((String)object);
            }
            throw new ClassCastException(object + " is not an Double: " + object.getClass());
        }
        return null;
    }

    public double getDouble(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new ClassCastException(object + " is not an Double: " + object.getClass());
    }

    public Boolean getBooleanWrapper(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        if (option.isDefined()) {
            Object object = option.get();
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                return Boolean.valueOf((String)object);
            }
            throw new ClassCastException(object + " is not an Boolean: " + object.getClass());
        }
        return null;
    }

    public boolean getBoolean(@Nonnull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        throw new ClassCastException(object + " is not an Boolean: " + object.getClass());
    }

    @Nonnull
    public List<Object> getList(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        if (option.isDefined()) {
            Object object = option.get();
            if (object instanceof List) {
                return (List)object;
            }
            if (object instanceof Seq) {
                return Converters.toJavaList((Seq)object);
            }
            throw new ClassCastException(object + " is not an List: " + object.getClass());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public java.util.Set<Object> getSet(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        if (option.isDefined()) {
            Object object = option.get();
            if (object instanceof java.util.Set) {
                return (java.util.Set)object;
            }
            if (object instanceof Set) {
                return Converters.toJavaSet((Set)object);
            }
            throw new ClassCastException(object + " is not an Set: " + object.getClass());
        }
        return Collections.emptySet();
    }

    @Nonnull
    public java.util.Map<String, Object> getMap(@Nonnull String string) {
        Option option = this.wrapped.attributes().get((Object)string);
        if (option.isDefined()) {
            Object object = option.get();
            if (object instanceof java.util.Map) {
                return (java.util.Map)object;
            }
            if (object instanceof Map) {
                return Converters.toJavaMap((Map<String, Object>)((Map)object));
            }
            throw new ClassCastException(object + " is not an Map: " + object.getClass());
        }
        return Collections.emptyMap();
    }

    @Nonnull
    public Session set(@Nonnull String string, Object object) {
        return new Session(this.wrapped.set(string, object));
    }

    @Nonnull
    public Session setAll(@Nonnull java.util.Map<String, Object> map) {
        return new Session(this.wrapped.setAll(Converters.toScalaMap(map)));
    }

    @Nonnull
    public Session remove(@Nonnull String string) {
        return new Session(this.wrapped.remove(string));
    }

    @Nonnull
    public Session removeAll(String ... stringArray) {
        return new Session(this.wrapped.removeAll(Converters.toScalaSeq(stringArray)));
    }

    public boolean contains(@Nonnull String string) {
        return this.wrapped.contains(string);
    }

    public boolean isFailed() {
        return this.wrapped.isFailed();
    }

    @Nonnull
    public Session markAsSucceeded() {
        return new Session(this.wrapped.markAsSucceeded());
    }

    @Nonnull
    public Session markAsFailed() {
        return new Session(this.wrapped.markAsFailed());
    }

    public io.gatling.core.session.Session asScala() {
        return this.wrapped;
    }
}

