/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core.loop;

import io.gatling.javaapi.core.ChainBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.StructureBuilder;
import io.gatling.javaapi.core.internal.loop.ScalaDuring;
import java.time.Duration;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface During<T extends StructureBuilder<T, W>, W extends io.gatling.core.structure.StructureBuilder<W>> {
    public T make(Function<W, W> var1);

    @Nonnull
    default public Loop<T> during(long l) {
        return this.during(Duration.ofSeconds(l));
    }

    @Nonnull
    default public Loop<T> during(long l, boolean bl) {
        return this.during(Duration.ofSeconds(l), bl);
    }

    @Nonnull
    default public Loop<T> during(long l, String string) {
        return this.during(Duration.ofSeconds(l), string);
    }

    @Nonnull
    default public Loop<T> during(long l, String string, boolean bl) {
        return this.during(Duration.ofSeconds(l), string, bl);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Duration duration) {
        return this.during((Session session) -> duration);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Duration duration, boolean bl) {
        return this.during((Session session) -> duration, bl);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Duration duration, @Nonnull String string) {
        return this.during((Session session) -> duration, string, true);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Duration duration, @Nonnull String string, boolean bl) {
        return new Loop(ScalaDuring.apply(this, duration, string, bl));
    }

    @Nonnull
    default public Loop<T> during(@Nonnull String string) {
        return this.during(string, UUID.randomUUID().toString());
    }

    @Nonnull
    default public Loop<T> during(@Nonnull String string, boolean bl) {
        return this.during(string, UUID.randomUUID().toString(), bl);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull String string, @Nonnull String string2) {
        return this.during(string, string2, true);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull String string, @Nonnull String string2, boolean bl) {
        return new Loop(ScalaDuring.apply(this, string, string2, bl));
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Function<Session, Duration> function) {
        return this.during(function, UUID.randomUUID().toString());
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Function<Session, Duration> function, boolean bl) {
        return this.during(function, UUID.randomUUID().toString(), bl);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Function<Session, Duration> function, @Nonnull String string) {
        return this.during(function, string, true);
    }

    @Nonnull
    default public Loop<T> during(@Nonnull Function<Session, Duration> function, @Nonnull String string, boolean bl) {
        return new Loop(ScalaDuring.apply(this, function, string, bl));
    }

    public static final class Loop<T extends StructureBuilder<T, ?>> {
        private final ScalaDuring.Loop<T, ?> wrapped;

        Loop(ScalaDuring.Loop<T, ?> loop) {
            this.wrapped = loop;
        }

        @Nonnull
        public T loop(@Nonnull ChainBuilder chainBuilder) {
            return this.wrapped.loop(chainBuilder);
        }
    }
}

