/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.core.Predef;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.BatchableFeederBuilder;
import io.gatling.core.feeder.FeederBuilderBase;
import io.gatling.core.feeder.SeparatedValuesParser;
import io.gatling.core.json.JsonParsers;
import io.gatling.javaapi.core.internal.Converters;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import scala.Function0;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;

public interface FeederBuilder<T> {
    @Nonnull
    public FeederBuilder<T> queue();

    @Nonnull
    public FeederBuilder<T> random();

    @Nonnull
    public FeederBuilder<T> shuffle();

    @Nonnull
    public FeederBuilder<T> circular();

    @Nonnull
    public FeederBuilder<Object> convert(@Nonnull BiFunction<String, T, Object> var1);

    @Nonnull
    public List<java.util.Map<String, Object>> readRecords();

    @Nonnull
    public FeederBuilder<T> shard();

    public Function0<Iterator<Map<String, Object>>> asScala();

    public static final class Impl<T>
    implements Batchable<T> {
        private final BatchableFeederBuilder<T> wrapped;

        @Nonnull
        static Batchable<String> csv(@Nonnull String string) {
            return Impl.csv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        @Nonnull
        static Batchable<String> csv(@Nonnull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.csv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        @Nonnull
        static Batchable<String> ssv(@Nonnull String string) {
            return Impl.ssv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        @Nonnull
        static Batchable<String> ssv(@Nonnull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.ssv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        @Nonnull
        static Batchable<String> tsv(@Nonnull String string) {
            return Impl.tsv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        @Nonnull
        static Batchable<String> tsv(@Nonnull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.tsv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        @Nonnull
        static Batchable<String> separatedValues(@Nonnull String string, char c) {
            return Impl.separatedValues(string, c, SeparatedValuesParser.DefaultQuoteChar());
        }

        @Nonnull
        static Batchable<String> separatedValues(@Nonnull String string, char c, char c2) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.separatedValues((String)string, (char)c, (char)c2, (GatlingConfiguration)Predef.configuration()));
        }

        @Nonnull
        static FileBased<Object> jsonFile(@Nonnull String string) {
            return new Impl<Object>((FeederBuilderBase<Object>)Predef.jsonFile((String)string, (JsonParsers)Predef.defaultJsonParsers(), (GatlingConfiguration)Predef.configuration()));
        }

        @Nonnull
        static FeederBuilder<Object> jsonUrl(@Nonnull String string) {
            return new Impl<Object>(Predef.jsonUrl((String)string, (JsonParsers)Predef.defaultJsonParsers(), (GatlingConfiguration)Predef.configuration()));
        }

        public Impl(@Nonnull FeederBuilderBase<T> feederBuilderBase) {
            this.wrapped = (BatchableFeederBuilder)feederBuilderBase;
        }

        private Impl<T> make(Function<BatchableFeederBuilder<T>, FeederBuilderBase<T>> function) {
            return new Impl<T>(function.apply(this.wrapped));
        }

        @Override
        @Nonnull
        public Batchable<T> queue() {
            return this.make(BatchableFeederBuilder::queue);
        }

        @Override
        @Nonnull
        public Batchable<T> random() {
            return this.make(BatchableFeederBuilder::random);
        }

        @Override
        @Nonnull
        public Batchable<T> shuffle() {
            return this.make(BatchableFeederBuilder::shuffle);
        }

        @Override
        @Nonnull
        public Batchable<T> circular() {
            return this.make(BatchableFeederBuilder::circular);
        }

        @Override
        @Nonnull
        public FeederBuilder<Object> convert(final @Nonnull BiFunction<String, T, Object> biFunction) {
            return new Impl<Object>((FeederBuilderBase<Object>)this.wrapped.convert(new PartialFunction<Tuple2<String, T>, Object>(){

                public boolean isDefinedAt(Tuple2<String, T> tuple2) {
                    return true;
                }

                public Object apply(Tuple2<String, T> tuple2) {
                    return biFunction.apply(tuple2._1, tuple2._2);
                }
            }));
        }

        @Override
        @Nonnull
        public List<java.util.Map<String, Object>> readRecords() {
            return Converters.toJavaList(this.wrapped.readRecords()).stream().map(Converters::toJavaMap).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public Batchable<T> shard() {
            return this.make(BatchableFeederBuilder::shard);
        }

        @Override
        @Nonnull
        public Batchable<T> unzip() {
            return this.make(BatchableFeederBuilder::unzip);
        }

        @Override
        @Nonnull
        public Batchable<T> eager() {
            return this.make(BatchableFeederBuilder::eager);
        }

        @Override
        @Nonnull
        public Batchable<T> batch() {
            return this.make(BatchableFeederBuilder::batch);
        }

        @Override
        @Nonnull
        public Batchable<T> batch(int n) {
            return this.make(batchableFeederBuilder -> batchableFeederBuilder.batch(n));
        }

        @Override
        public Function0<Iterator<Map<String, Object>>> asScala() {
            return this.wrapped;
        }
    }

    public static interface Batchable<T>
    extends FileBased<T> {
        @Override
        @Nonnull
        public Batchable<T> queue();

        @Override
        @Nonnull
        public Batchable<T> random();

        @Override
        @Nonnull
        public Batchable<T> shuffle();

        @Override
        @Nonnull
        public Batchable<T> circular();

        @Override
        @Nonnull
        public Batchable<T> shard();

        @Override
        @Nonnull
        public Batchable<T> unzip();

        @Nonnull
        public Batchable<T> eager();

        @Nonnull
        public Batchable<T> batch();

        @Nonnull
        public Batchable<T> batch(int var1);
    }

    public static interface FileBased<T>
    extends FeederBuilder<T> {
        @Override
        @Nonnull
        public FileBased<T> queue();

        @Override
        @Nonnull
        public FileBased<T> random();

        @Override
        @Nonnull
        public FileBased<T> shuffle();

        @Override
        @Nonnull
        public FileBased<T> circular();

        @Override
        @Nonnull
        public FileBased<T> shard();

        @Nonnull
        public FileBased<T> unzip();
    }
}

