/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.config;

import io.gatling.commons.util.PathHelper;
import io.gatling.commons.util.PathHelper$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GatlingFiles$lambda$$binariesDirectory$1;
import io.gatling.core.config.GatlingFiles$lambda$$binariesDirectory$2;
import io.gatling.core.config.GatlingFiles$lambda$$simulationLogDirectory$1;
import io.gatling.core.config.GatlingFiles$lambda$$simulationLogDirectory$2;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.util.Properties$;

public final class GatlingFiles$ {
    public static final GatlingFiles$ MODULE$;
    private final Path GatlingHome;
    private final Path GatlingAssetsPackage;
    private final Path GatlingJsFolder;
    private final Path GatlingStyleFolder;
    private final Path GatlingAssetsJsPackage;
    private final Path GatlingAssetsStylePackage;

    static {
        new GatlingFiles$();
    }

    public Path GatlingHome() {
        return this.GatlingHome;
    }

    public Path GatlingAssetsPackage() {
        return this.GatlingAssetsPackage;
    }

    public Path GatlingJsFolder() {
        return this.GatlingJsFolder;
    }

    public Path GatlingStyleFolder() {
        return this.GatlingStyleFolder;
    }

    public Path GatlingAssetsJsPackage() {
        return this.GatlingAssetsJsPackage;
    }

    public Path GatlingAssetsStylePackage() {
        return this.GatlingAssetsStylePackage;
    }

    private Path resolvePath(Path path) {
        return (path.isAbsolute() || PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(path)) ? path : PathHelper.RichPath$.MODULE$.$div$extension1(PathHelper$.MODULE$.RichPath(this.GatlingHome()), path)).normalize().toAbsolutePath();
    }

    public Path dataDirectory(GatlingConfiguration configuration) {
        return this.resolvePath(PathHelper$.MODULE$.string2path(configuration.core().directory().data()));
    }

    public Path bodiesDirectory(GatlingConfiguration configuration) {
        return this.resolvePath(PathHelper$.MODULE$.string2path(configuration.core().directory().bodies()));
    }

    public Path sourcesDirectory(GatlingConfiguration configuration) {
        return this.resolvePath(PathHelper$.MODULE$.string2path(configuration.core().directory().sources()));
    }

    public Option<String> reportsOnlyDirectory(GatlingConfiguration configuration) {
        return configuration.core().directory().reportsOnly();
    }

    public Path binariesDirectory(GatlingConfiguration configuration) {
        return (Path)configuration.core().directory().binaries().map((Function1)new GatlingFiles$lambda$$binariesDirectory$1(this)).getOrElse((Function0)new GatlingFiles$lambda$$binariesDirectory$2(this));
    }

    public Path resultDirectory(String runUuid, GatlingConfiguration configuration) {
        return PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(this.resolvePath(PathHelper$.MODULE$.string2path(configuration.core().directory().results()))), runUuid);
    }

    public Path jsDirectory(String runUuid, GatlingConfiguration configuration) {
        return PathHelper.RichPath$.MODULE$.$div$extension1(PathHelper$.MODULE$.RichPath(this.resultDirectory(runUuid, configuration)), this.GatlingJsFolder());
    }

    public Path styleDirectory(String runUuid, GatlingConfiguration configuration) {
        return PathHelper.RichPath$.MODULE$.$div$extension1(PathHelper$.MODULE$.RichPath(this.resultDirectory(runUuid, configuration)), this.GatlingStyleFolder());
    }

    public Path simulationLogDirectory(String runUuid, boolean create, GatlingConfiguration configuration) {
        Path path;
        Path dir = this.resultDirectory(runUuid, configuration);
        if (create) {
            path = PathHelper.RichPath$.MODULE$.mkdirs$extension(PathHelper$.MODULE$.RichPath(dir));
        } else {
            Predef$.MODULE$.require(dir.toFile().exists(), (Function0)new GatlingFiles$lambda$$simulationLogDirectory$1(dir));
            Predef$.MODULE$.require(dir.toFile().isDirectory(), (Function0)new GatlingFiles$lambda$$simulationLogDirectory$2(dir));
            path = dir;
        }
        return path;
    }

    public boolean simulationLogDirectory$default$2() {
        return true;
    }

    public final /* synthetic */ Path io$gatling$core$config$GatlingFiles$$$anonfun$1(String path) {
        return this.resolvePath(PathHelper$.MODULE$.string2path(path));
    }

    public final /* synthetic */ Path io$gatling$core$config$GatlingFiles$$$anonfun$2() {
        return PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(this.GatlingHome()), "target")), "test-classes");
    }

    public static final /* synthetic */ String io$gatling$core$config$GatlingFiles$$$anonfun$3(Path dir$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"simulation directory '", "' doesn't exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir$1}));
    }

    public static final /* synthetic */ String io$gatling$core$config$GatlingFiles$$$anonfun$4(Path dir$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"simulation directory '", "' is not a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir$1}));
    }

    private GatlingFiles$() {
        MODULE$ = this;
        this.GatlingHome = PathHelper$.MODULE$.string2path(Properties$.MODULE$.envOrElse("GATLING_HOME", Properties$.MODULE$.propOrElse("GATLING_HOME", ".")));
        this.GatlingAssetsPackage = PathHelper$.MODULE$.string2path("assets");
        this.GatlingJsFolder = PathHelper$.MODULE$.string2path("js");
        this.GatlingStyleFolder = PathHelper$.MODULE$.string2path("style");
        this.GatlingAssetsJsPackage = PathHelper.RichPath$.MODULE$.$div$extension1(PathHelper$.MODULE$.RichPath(this.GatlingAssetsPackage()), this.GatlingJsFolder());
        this.GatlingAssetsStylePackage = PathHelper.RichPath$.MODULE$.$div$extension1(PathHelper$.MODULE$.RichPath(this.GatlingAssetsPackage()), this.GatlingStyleFolder());
    }
}

