/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.FeederOptions;
import io.gatling.core.feeder.FeederSource;
import io.gatling.core.feeder.InMemoryFeeder$;
import io.gatling.core.feeder.ZippedResourceCache$;
import io.gatling.core.json.Json$;
import io.gatling.core.json.JsonParsers;
import io.gatling.core.util.Resource;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005ua!B\u0005\u000b\u00059\u0011\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011!\u0002!\u0011!Q\u0001\n%B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006s\u0001!\tA\u000f\u0005\u0006\u007f\u0001!I\u0001\u0011\u0005\u0006\u0017\u0001!\t%\u001c\u0005\u0006{\u0002!\tE \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0005QQ5o\u001c8GS2,g)Z3eKJ\u001cv.\u001e:dK*\u00111\u0002D\u0001\u0007M\u0016,G-\u001a:\u000b\u00055q\u0011\u0001B2pe\u0016T!a\u0004\t\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011#\u0001\u0002j_N\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\rQ2$H\u0007\u0002\u0015%\u0011AD\u0003\u0002\r\r\u0016,G-\u001a:T_V\u00148-\u001a\t\u0003)yI!aH\u000b\u0003\u0007\u0005s\u00170\u0001\u0005sKN|WO]2f\u0007\u0001\u0001\"a\t\u0014\u000e\u0003\u0011R!!\n\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003O\u0011\u0012\u0001BU3t_V\u00148-Z\u0001\fUN|g\u000eU1sg\u0016\u00148\u000f\u0005\u0002+[5\t1F\u0003\u0002-\u0019\u0005!!n]8o\u0013\tq3FA\u0006Kg>t\u0007+\u0019:tKJ\u001c\u0018aB2iCJ\u001cX\r\u001e\t\u0003c]j\u0011A\r\u0006\u0003_MR!\u0001N\u001b\u0002\u00079LwNC\u00017\u0003\u0011Q\u0017M^1\n\u0005a\u0012$aB\"iCJ\u001cX\r^\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmbTH\u0010\t\u00035\u0001AQ\u0001\t\u0003A\u0002\tBQ\u0001\u000b\u0003A\u0002%BQa\f\u0003A\u0002A\nQc^5uQ*\u001bxN\\!se\u0006LX\t\\3nK:$8/\u0006\u0002B\u000bR\u0011!\t\u001b\u000b\u0003\u0007.\u0003\"\u0001R#\r\u0001\u0011)a)\u0002b\u0001\u000f\n\tA+\u0005\u0002I;A\u0011A#S\u0005\u0003\u0015V\u0011qAT8uQ&tw\rC\u0003M\u000b\u0001\u0007Q*A\u0001g!\u0011!b\nU\"\n\u0005=+\"!\u0003$v]\u000e$\u0018n\u001c82!\r\t\u0016\f\u0018\b\u0003%^s!a\u0015,\u000e\u0003QS!!V\u0011\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001-\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0011%#XM]1u_JT!\u0001W\u000b\u0011\u0005u3W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0005\u0005\u0014\u0017a\u00026bG.\u001cxN\u001c\u0006\u0003G\u0012\f\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0003\u0015\f1aY8n\u0013\t9gL\u0001\u0005Kg>tgj\u001c3f\u0011\u0015IW\u00011\u0001k\u0003\u001dy\u0007\u000f^5p]N\u00042AG6\u001e\u0013\ta'BA\u0007GK\u0016$WM](qi&|gn\u001d\u000b\u0004]R,\bcA8r;9\u0011!\u0004]\u0005\u00031*I!A]:\u0003\r\u0019+W\rZ3s\u0015\tA&\u0002C\u0003j\r\u0001\u0007!\u000eC\u0003w\r\u0001\u0007q/A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003qnl\u0011!\u001f\u0006\u0003u2\taaY8oM&<\u0017B\u0001?z\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006!a.Y7f+\u0005y\b\u0003BA\u0001\u0003\u0013qA!a\u0001\u0002\u0006A\u00111+F\u0005\u0004\u0003\u000f)\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\bU\tAB]3d_J$7oQ8v]R$b!a\u0005\u0002\u001a\u0005m\u0001c\u0001\u000b\u0002\u0016%\u0019\u0011qC\u000b\u0003\u0007%sG\u000fC\u0003j\u0011\u0001\u0007!\u000eC\u0003w\u0011\u0001\u0007q\u000f")
public final class JsonFileFeederSource
implements FeederSource<Object> {
    private final Resource resource;
    private final JsonParsers jsonParsers;
    private final Charset charset;

    private <T> T withJsonArrayElements(FeederOptions<Object> options, Function1<Iterator<JsonNode>, T> f) {
        return (T)Using$.MODULE$.resource((Object)ZippedResourceCache$.MODULE$.unzipped(this.resource, options).inputStream(), (Function1 & Serializable)is -> {
            JsonNode node = $this.jsonParsers.parse((InputStream)is, $this.charset);
            if (node.isArray()) {
                return f.apply((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(node.elements()).asScala());
            }
            throw new IllegalArgumentException("Root element of JSON feeder file isn't an array");
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Override
    public Iterator<Map<String, Object>> feeder(FeederOptions<Object> options, GatlingConfiguration configuration) {
        Vector records = (Vector)this.withJsonArrayElements(options, (Function1 & Serializable)x$1 -> x$1.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JsonNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.isObject()) {
                    return (B1)((Map)Json$.MODULE$.asScala(A1));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(JsonNode x1) {
                JsonNode jsonNode = x1;
                return jsonNode.isObject();
            }
        }).toVector());
        return InMemoryFeeder$.MODULE$.apply(records, options.conversion(), options.strategy());
    }

    @Override
    public String name() {
        return "json(" + this.resource.name() + ")";
    }

    @Override
    public int recordsCount(FeederOptions<Object> options, GatlingConfiguration configuration) {
        return BoxesRunTime.unboxToInt(this.withJsonArrayElements(options, (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())));
    }

    public JsonFileFeederSource(Resource resource, JsonParsers jsonParsers, Charset charset) {
        this.resource = resource;
        this.jsonParsers = jsonParsers;
        this.charset = charset;
    }
}

