/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats;

import io.gatling.commons.stats.Status;
import io.gatling.commons.stats.assertion.Assertion;
import io.gatling.commons.util.Clock;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller;
import io.gatling.core.controller.Controller$Command$StatsEngineStopped$;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.session.GroupBlock;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.EnterpriseStatsEngineExtensions;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.RunMessage;
import io.gatling.core.stats.writer.ShortScenarioDescription;
import io.netty.channel.ChannelHandler;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.Option;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ux!\u0002\f\u0018\u0011\u0003\u0001c!\u0002\u0012\u0018\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"\u0002\u0017\u0002\t\u0003ic\u0001\u0002\u0012\u0018\u0005=B\u0001b\r\u0003\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t\u0013\u0012\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0002B\u0001B\u0003%\u0011\u000b\u0003\u0005V\t\t\u0005\t\u0015!\u0003W\u0011!\u0001GA!A!\u0002\u0013\t\u0007\u0002\u00033\u0005\u0005\u0003\u0005\u000b\u0011B3\t\u000b)\"A\u0011A6\t\u000fI$!\u0019!C\u0005g\"1q\u0010\u0002Q\u0001\nQDq!!\u0001\u0005\t\u0003\n\u0019\u0001C\u0004\u0002\f\u0011!\t%!\u0004\t\u000f\u0005]B\u0001\"\u0003\u0002:!9\u0011q\b\u0003\u0005B\u0005\u0005\u0003bBA,\t\u0011\u0005\u0013\u0011\f\u0005\b\u0003;\"A\u0011IA0\u0011\u001d\t\u0019\n\u0002C!\u0003+Cq!!,\u0005\t\u0003\ny+\u0001\fECR\fwK]5uKJ\u001c8\u000b^1ug\u0016sw-\u001b8f\u0015\tA\u0012$A\u0003ti\u0006$8O\u0003\u0002\u001b7\u0005!1m\u001c:f\u0015\taR$A\u0004hCRd\u0017N\\4\u000b\u0003y\t!![8\u0004\u0001A\u0011\u0011%A\u0007\u0002/\t1B)\u0019;b/JLG/\u001a:t'R\fGo]#oO&tWm\u0005\u0002\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001b9\nY,!3\u0002L\u00065\u0017qZAs!\t\tCaE\u0002\u0005IA\u0002\"!I\u0019\n\u0005I:\"aC*uCR\u001cXI\\4j]\u0016\f!\"Y:tKJ$\u0018n\u001c8t!\r)T\b\u0011\b\u0003mmr!a\u000e\u001e\u000e\u0003aR!!O\u0010\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013B\u0001\u001f'\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0007M+\u0017O\u0003\u0002=MA\u0011\u0011iR\u0007\u0002\u0005*\u00111\tR\u0001\nCN\u001cXM\u001d;j_:T!\u0001G#\u000b\u0005\u0019[\u0012aB2p[6|gn]\u0005\u0003\u0011\n\u0013\u0011\"Q:tKJ$\u0018n\u001c8\u0002\u0015I,h.T3tg\u0006<W\r\u0005\u0002L\u001d6\tAJ\u0003\u0002N/\u00051qO]5uKJL!a\u0014'\u0003\u0015I+h.T3tg\u0006<W-A\u0005tG\u0016t\u0017M]5pgB\u0019Q'\u0010*\u0011\u0005-\u001b\u0016B\u0001+M\u0005a\u0019\u0006n\u001c:u'\u000e,g.\u0019:j_\u0012+7o\u0019:jaRLwN\\\u0001\fI\u0006$\u0018m\u0016:ji\u0016\u00148\u000fE\u00026{]\u00032\u0001W.^\u001b\u0005I&B\u0001.\u001a\u0003\u0015\t7\r^8s\u0013\ta\u0016L\u0001\u0005BGR|'OU3g!\tYe,\u0003\u0002`\u0019\n\tB)\u0019;b/JLG/\u001a:NKN\u001c\u0018mZ3\u0002\rML8\u000f^3n!\tA&-\u0003\u0002d3\nY\u0011i\u0019;peNK8\u000f^3n\u0003\u0015\u0019Gn\\2l!\t1\u0017.D\u0001h\u0015\tAW)\u0001\u0003vi&d\u0017B\u00016h\u0005\u0015\u0019En\\2l)\u001dqC.\u001c8paFDQaM\u0006A\u0002QBQ!S\u0006A\u0002)CQ\u0001U\u0006A\u0002ECQ!V\u0006A\u0002YCQ\u0001Y\u0006A\u0002\u0005DQ\u0001Z\u0006A\u0002\u0015\fa!Y2uSZ,W#\u0001;\u0011\u0005UlX\"\u0001<\u000b\u0005]D\u0018AB1u_6L7M\u0003\u0002zu\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005!\\(\"\u0001?\u0002\t)\fg/Y\u0005\u0003}Z\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB1di&4X\rI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003\u000b\u00012!JA\u0004\u0013\r\tIA\n\u0002\u0005+:LG/\u0001\u0003ti>\u0004HCBA\u0003\u0003\u001f\t9\u0003C\u0004\u0002\u0012=\u0001\r!a\u0005\u0002\u0015\r|g\u000e\u001e:pY2,'\u000f\u0005\u0003Y7\u0006U\u0001\u0003BA\f\u0003CqA!!\u0007\u0002\u001e5\u0011\u00111\u0004\u0006\u0004\u0003#I\u0012\u0002BA\u0010\u00037\t!bQ8oiJ|G\u000e\\3s\u0013\u0011\t\u0019#!\n\u0003\u000f\r{W.\\1oI*!\u0011qDA\u000e\u0011\u001d\tIc\u0004a\u0001\u0003W\t\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\u000b\u0015\ni#!\r\n\u0007\u0005=bE\u0001\u0004PaRLwN\u001c\t\u0004k\u0005M\u0012bAA\u001b\u007f\tIQ\t_2faRLwN\\\u0001\tI&\u001c\b/\u0019;dQR!\u0011QAA\u001e\u0011\u0019\ti\u0004\u0005a\u0001;\u00069Q.Z:tC\u001e,\u0017\u0001\u00047pOV\u001bXM]*uCJ$H\u0003BA\u0003\u0003\u0007Bq!!\u0012\u0012\u0001\u0004\t9%\u0001\u0005tG\u0016t\u0017M]5p!\u0011\tI%!\u0015\u000f\t\u0005-\u0013Q\n\t\u0003o\u0019J1!a\u0014'\u0003\u0019\u0001&/\u001a3fM&!\u00111KA+\u0005\u0019\u0019FO]5oO*\u0019\u0011q\n\u0014\u0002\u00151|w-V:fe\u0016sG\r\u0006\u0003\u0002\u0006\u0005m\u0003bBA#%\u0001\u0007\u0011qI\u0001\fY><'+Z:q_:\u001cX\r\u0006\n\u0002\u0006\u0005\u0005\u00141MA7\u0003c\nY(a \u0002\f\u0006E\u0005bBA#'\u0001\u0007\u0011q\t\u0005\b\u0003K\u001a\u0002\u0019AA4\u0003\u00199'o\\;qgB)Q'!\u001b\u0002H%\u0019\u00111N \u0003\t1K7\u000f\u001e\u0005\b\u0003_\u001a\u0002\u0019AA$\u0003-\u0011X-];fgRt\u0015-\\3\t\u000f\u0005M4\u00031\u0001\u0002v\u0005q1\u000f^1siRKW.Z:uC6\u0004\bcA\u0013\u0002x%\u0019\u0011\u0011\u0010\u0014\u0003\t1{gn\u001a\u0005\b\u0003{\u001a\u0002\u0019AA;\u00031)g\u000e\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\t\ti\u0005a\u0001\u0003\u0007\u000baa\u001d;biV\u001c\b\u0003BAC\u0003\u000fk\u0011\u0001R\u0005\u0004\u0003\u0013#%AB*uCR,8\u000fC\u0004\u0002\u000eN\u0001\r!a$\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\u0011\u000b\u0015\ni#a\u0012\t\u000f\u0005u2\u00031\u0001\u0002\u0010\u0006YAn\\4He>,\b/\u00128e)!\t)!a&\u0002\u001a\u0006%\u0006bBA#)\u0001\u0007\u0011q\t\u0005\b\u00037#\u0002\u0019AAO\u0003)9'o\\;q\u00052|7m\u001b\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111U\r\u0002\u000fM,7o]5p]&!\u0011qUAQ\u0005)9%o\\;q\u00052|7m\u001b\u0005\b\u0003W#\u0002\u0019AA;\u00035)\u00070\u001b;US6,7\u000f^1na\u0006yAn\\4SKF,Xm\u001d;De\u0006\u001c\b\u000e\u0006\u0006\u0002\u0006\u0005E\u00161WA[\u0003oCq!!\u0012\u0016\u0001\u0004\t9\u0005C\u0004\u0002fU\u0001\r!a\u001a\t\u000f\u0005=T\u00031\u0001\u0002H!9\u0011\u0011X\u000bA\u0002\u0005\u001d\u0013!B3se>\u0014\bbBA_\u0007\u0001\u0007\u0011qX\u0001\u0011g&lW\u000f\\1uS>t\u0007+\u0019:b[N\u0004B!!1\u0002F6\u0011\u00111\u0019\u0006\u0004\u0003\u000bJ\u0012\u0002BAd\u0003\u0007\u0014\u0001cU5nk2\fG/[8o!\u0006\u0014\u0018-\\:\t\u000b%\u001b\u0001\u0019\u0001&\t\u000b\u0001\u001c\u0001\u0019A1\t\u000b\u0011\u001c\u0001\u0019A3\t\u000f\u0005E7\u00011\u0001\u0002T\u0006\u0001\"/Z:vYR\u001cH)\u001b:fGR|'/\u001f\t\u0006K\u00055\u0012Q\u001b\t\u0005\u0003/\f\t/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\u00111\u0017\u000e\\3\u000b\u0007\u0005}70A\u0002oS>LA!a9\u0002Z\n!\u0001+\u0019;i\u0011\u001d\t9o\u0001a\u0001\u0003S\fQbY8oM&<WO]1uS>t\u0007\u0003BAv\u0003cl!!!<\u000b\u0007\u0005=\u0018$\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003g\fiO\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c")
public final class DataWritersStatsEngine
implements StatsEngine {
    private final Seq<Assertion> assertions;
    private final RunMessage runMessage;
    private final Seq<ShortScenarioDescription> scenarios;
    private final Seq<ActorRef<DataWriterMessage>> dataWriters;
    private final ActorSystem system;
    private final Clock clock;
    private final AtomicBoolean active;

    public static DataWritersStatsEngine apply(SimulationParams simulationParams, RunMessage runMessage, ActorSystem system, Clock clock, Option<Path> resultsDirectory, GatlingConfiguration configuration) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, system, clock, resultsDirectory, configuration);
    }

    @Override
    public final ChannelHandler statsChannelHandler(String remoteAddress) {
        return EnterpriseStatsEngineExtensions.statsChannelHandler$(this, remoteAddress);
    }

    @Override
    public final void logTcpConnectAttempt(InetSocketAddress remoteAddress) {
        EnterpriseStatsEngineExtensions.logTcpConnectAttempt$(this, remoteAddress);
    }

    @Override
    public final void logTcpConnect(String remoteAddress, long startTimestamp, long endTimestamp, Option<String> error) {
        EnterpriseStatsEngineExtensions.logTcpConnect$(this, remoteAddress, startTimestamp, endTimestamp, error);
    }

    @Override
    public final void logTlsHandshake(String remoteAddress, long startTimestamp, long endTimestamp, Option<String> error) {
        EnterpriseStatsEngineExtensions.logTlsHandshake$(this, remoteAddress, startTimestamp, endTimestamp, error);
    }

    private AtomicBoolean active() {
        return this.active;
    }

    @Override
    public void start() {
        FiniteDuration startTimeoutDuration = new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
        Seq dataWriterInitResponses = (Seq)this.dataWriters.map((Function1 & Serializable)dataWriter -> {
            Promise promise = dataWriter.replyPromise(startTimeoutDuration);
            dataWriter.$bang(new DataWriterMessage.Init($this.assertions, $this.runMessage, $this.scenarios, promise));
            return promise.future();
        });
        ExecutionContext executionContext = this.system.executionContext();
        Future statsEngineFuture = Future$.MODULE$.sequence((IterableOnce)dataWriterInitResponses, BuildFrom$.MODULE$.buildFromIterableOps(), executionContext);
        Await$.MODULE$.ready((Awaitable)statsEngineFuture, (Duration)startTimeoutDuration);
    }

    @Override
    public void stop(ActorRef<Controller.Command> controller, Option<Exception> exception) {
        if (this.active().getAndSet(false)) {
            Seq responses = (Seq)this.dataWriters.map((Function1 & Serializable)dataWriter -> {
                Promise promise = dataWriter.replyPromise(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
                dataWriter.$bang(new DataWriterMessage.Stop(promise));
                return promise.future();
            });
            ExecutionContext executionContext = this.system.executionContext();
            Future$.MODULE$.sequence((IterableOnce)responses, BuildFrom$.MODULE$.buildFromIterableOps(), executionContext).onComplete((Function1 & Serializable)x$1 -> {
                controller.$bang(Controller$Command$StatsEngineStopped$.MODULE$);
                return BoxedUnit.UNIT;
            }, executionContext);
            return;
        }
    }

    private void dispatch(DataWriterMessage message) {
        if (this.active().get()) {
            this.dataWriters.foreach((Function1 & Serializable)x$2 -> {
                x$2.$bang(message);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void logUserStart(String scenario) {
        this.dispatch(new DataWriterMessage.LoadEvent.UserStart(scenario, this.clock.nowMillis()));
    }

    @Override
    public void logUserEnd(String scenario) {
        this.dispatch(new DataWriterMessage.LoadEvent.UserEnd(scenario, this.clock.nowMillis()));
    }

    @Override
    public void logResponse(String scenario, List<String> groups2, String requestName, long startTimestamp, long endTimestamp, Status status, Option<String> responseCode, Option<String> message) {
        if (endTimestamp >= 0L) {
            this.dispatch(new DataWriterMessage.LoadEvent.Response(scenario, groups2, requestName, startTimestamp, endTimestamp, status, responseCode, message));
            return;
        }
    }

    @Override
    public void logGroupEnd(String scenario, GroupBlock groupBlock, long exitTimestamp) {
        this.dispatch(new DataWriterMessage.LoadEvent.Group(scenario, groupBlock.groups(), groupBlock.startTimestamp(), exitTimestamp, groupBlock.cumulatedResponseTime(), groupBlock.status()));
    }

    @Override
    public void logRequestCrash(String scenario, List<String> groups2, String requestName, String error) {
        this.dispatch(new DataWriterMessage.LoadEvent.Error(requestName + ": " + error + " ", this.clock.nowMillis()));
    }

    public DataWritersStatsEngine(Seq<Assertion> assertions, RunMessage runMessage, Seq<ShortScenarioDescription> scenarios, Seq<ActorRef<DataWriterMessage>> dataWriters, ActorSystem system, Clock clock) {
        this.assertions = assertions;
        this.runMessage = runMessage;
        this.scenarios = scenarios;
        this.dataWriters = dataWriters;
        this.system = system;
        this.clock = clock;
        EnterpriseStatsEngineExtensions.$init$(this);
        this.active = new AtomicBoolean(true);
    }
}

