/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.actor.Cancellable;
import io.gatling.core.config.ConsoleDataWriterConfiguration;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.DataWriterMessage$Flush$;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.RunMessage;
import io.gatling.core.stats.writer.ShortScenarioDescription;
import io.gatling.core.stats.writer.UserCounters;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ub!\u0002\b\u0010\u0005UI\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")\u0001\n\u0001C\u0001\u0013\")q\n\u0001C!!\")\u0011\u000b\u0001C!%\")\u0011\f\u0001C!5\")Q\r\u0001C\u0005M\")\u0011\u000f\u0001C\u0005e\"9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003o\u0001A\u0011IA\u001d\u0005E\u0019uN\\:pY\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003!E\taa\u001e:ji\u0016\u0014(B\u0001\n\u0014\u0003\u0015\u0019H/\u0019;t\u0015\t!R#\u0001\u0003d_J,'B\u0001\f\u0018\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001G\u0001\u0003S>\u001c\"\u0001\u0001\u000e\u0011\u0007mab$D\u0001\u0010\u0013\tirB\u0001\u0006ECR\fwK]5uKJ\u0004\"aG\u0010\n\u0005\u0001z!aC\"p]N|G.\u001a#bi\u0006\f!B];o\u001b\u0016\u001c8/Y4f\u0007\u0001\u0001\"a\u0007\u0013\n\u0005\u0015z!A\u0003*v]6+7o]1hK\u0006I1oY3oCJLwn\u001d\t\u0004QI*dBA\u00150\u001d\tQS&D\u0001,\u0015\ta#%\u0001\u0004=e>|GOP\u0005\u0002]\u0005)1oY1mC&\u0011\u0001'M\u0001\ba\u0006\u001c7.Y4f\u0015\u0005q\u0013BA\u001a5\u0005\r\u0019V-\u001d\u0006\u0003aE\u0002\"a\u0007\u001c\n\u0005]z!\u0001G*i_J$8kY3oCJLw\u000eR3tGJL\u0007\u000f^5p]\u0006)1\r\\8dWB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005kRLGN\u0003\u0002?+\u000591m\\7n_:\u001c\u0018B\u0001!<\u0005\u0015\u0019En\\2l\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u00111IR\u0007\u0002\t*\u0011QiE\u0001\u0007G>tg-[4\n\u0005\u001d#%AH\"p]N|G.\u001a#bi\u0006<&/\u001b;fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q)!j\u0013'N\u001dB\u00111\u0004\u0001\u0005\u0006C\u0015\u0001\ra\t\u0005\u0006M\u0015\u0001\ra\n\u0005\u0006q\u0015\u0001\r!\u000f\u0005\u0006\u0003\u0016\u0001\rAQ\u0001\u0007_:Le.\u001b;\u0015\u0003y\tqa\u001c8GYV\u001c\b\u000e\u0006\u0002T/B\u0011A+V\u0007\u0002c%\u0011a+\r\u0002\u0005+:LG\u000fC\u0003Y\u000f\u0001\u0007a$\u0001\u0003eCR\f\u0017!C8o\u001b\u0016\u001c8/Y4f)\r\u00196\f\u001a\u0005\u00069\"\u0001\r!X\u0001\b[\u0016\u001c8/Y4f!\tq\u0016M\u0004\u0002\u001c?&\u0011\u0001mD\u0001\u0012\t\u0006$\u0018m\u0016:ji\u0016\u0014X*Z:tC\u001e,\u0017B\u00012d\u0005%au.\u00193Fm\u0016tGO\u0003\u0002a\u001f!)\u0001\f\u0003a\u0001=\u0005iqN\\+tKJlUm]:bO\u0016$2aU4q\u0011\u0015A\u0017\u00021\u0001j\u0003\u0011)8/\u001a:\u0011\u0005)lgB\u00010l\u0013\ta7-A\u0005M_\u0006$WI^3oi&\u0011an\u001c\u0002\u0005+N,'O\u0003\u0002mG\")\u0001,\u0003a\u0001=\u0005\trN\u001c*fgB|gn]3NKN\u001c\u0018mZ3\u0015\u0007M\u001b\b\u0010C\u0003u\u0015\u0001\u0007Q/\u0001\u0005sKN\u0004xN\\:f!\tQg/\u0003\u0002x_\nA!+Z:q_:\u001cX\rC\u0003Y\u0015\u0001\u0007a\u0004\u000b\u0004\u000bu\u0006\u0015\u0011q\u0001\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018\u0001\u00027b]\u001eT\u0011a`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0004q\u0014\u0001cU;qaJ,7o],be:LgnZ:\u0002\u000bY\fG.^3-\u0005\u0005%\u0011EAA\u0006\u0003\u0001z'o\u001a\u0018xCJ$(/Z7pm\u0016\u0014hf^1siNtC*[:u\u0003B\u0004XM\u001c3\u0002\u001d=tWI\u001d:pe6+7o]1hKR)1+!\u0005\u0002\u001c!9\u00111C\u0006A\u0002\u0005U\u0011!B3se>\u0014\bc\u00016\u0002\u0018%\u0019\u0011\u0011D8\u0003\u000b\u0015\u0013(o\u001c:\t\u000ba[\u0001\u0019\u0001\u0010\u0002\u000f=t7I]1tQR)1+!\t\u00026!9\u00111\u0005\u0007A\u0002\u0005\u0015\u0012!B2bkN,\u0007\u0003BA\u0014\u0003_qA!!\u000b\u0002,A\u0011!&M\u0005\u0004\u0003[\t\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00022\u0005M\"AB*ue&twMC\u0002\u0002.EBQ\u0001\u0017\u0007A\u0002y\taa\u001c8Ti>\u0004HcA*\u0002<!)\u0001,\u0004a\u0001=\u0001")
public final class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final RunMessage runMessage;
    private final Seq<ShortScenarioDescription> scenarios;
    private final Clock clock;
    private final ConsoleDataWriterConfiguration configuration;

    @Override
    public ConsoleData onInit() {
        Cancellable timer = this.scheduler().scheduleAtFixedRate(this.configuration.writePeriod(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.self().$bang(DataWriterMessage$Flush$.MODULE$));
        ConsoleData data = new ConsoleData(this.clock.nowMillis(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss O").withZone(this.runMessage.zoneId()), timer);
        this.scenarios.foreach((Function1 & Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        return data;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long now = this.clock.nowMillis();
        long runDuration = (now - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration.light(), ZonedDateTime.ofInstant(Instant.ofEpochMilli(now), java.time.Clock.systemDefaultZone().getZone()), data.dateTimeFormatter());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, ConsoleData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.User) {
            DataWriterMessage.LoadEvent.User user = (DataWriterMessage.LoadEvent.User)loadEvent;
            this.onUserMessage(user, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            this.onResponseMessage(response, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            this.onErrorMessage(error, data);
            return;
        }
    }

    private void onUserMessage(DataWriterMessage.LoadEvent.User user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            if (user.start()) {
                userCounters.userStart();
                return;
            }
            userCounters.userDone();
            return;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
            return;
        }
    }

    private void onResponseMessage(DataWriterMessage.LoadEvent.Response response, ConsoleData data) {
        String requestPath = ((IterableOnceOps)response.groupHierarchy().$colon$plus((Object)response.name())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable)() -> RequestCounters$.MODULE$.empty());
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            return;
        }
        if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
            return;
        }
        throw new MatchError((Object)status);
    }

    private void onErrorMessage(DataWriterMessage.LoadEvent.Error error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        data.timer().cancel();
        if (!data.complete()) {
            this.onFlush(data);
            return;
        }
    }

    public ConsoleDataWriter(RunMessage runMessage, Seq<ShortScenarioDescription> scenarios, Clock clock, ConsoleDataWriterConfiguration configuration) {
        this.runMessage = runMessage;
        this.scenarios = scenarios;
        this.clock = clock;
        this.configuration = configuration;
        super("console-data-writer");
    }
}

