/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.json;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.gatling.commons.util.Hex$;
import io.gatling.core.json.JsonParsers;
import io.gatling.shared.util.StringBuilderPool;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Json$ {
    public static final Json$ MODULE$ = new Json$();
    private static final StringBuilderPool stringBuilders = new StringBuilderPool();
    private static final ObjectMapper objectMapper;

    static {
        JsonFactoryBuilder jsonFactoryBuilder = (JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build()).enable(StreamReadFeature.USE_FAST_DOUBLE_PARSER).enable(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER);
        Json$.liftedTree1$1(jsonFactoryBuilder);
        objectMapper = new ObjectMapper(jsonFactoryBuilder.build());
    }

    private StringBuilderPool stringBuilders() {
        return stringBuilders;
    }

    public ObjectMapper objectMapper() {
        return objectMapper;
    }

    public int arrayOfObjectsLength(InputStream is, JsonParsers jsonParsers) {
        JsonParser parser = jsonParsers.createParser(is);
        JsonToken jsonToken = parser.nextToken();
        JsonToken jsonToken2 = JsonToken.START_ARRAY;
        Predef$.MODULE$.require(!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null), (Function0 & Serializable)() -> "Root element of JSON feeder file isn't an array");
        JsonToken jsonToken3 = parser.nextToken();
        if (JsonToken.START_OBJECT.equals(jsonToken3)) {
            int size = 1;
            parser.skipChildren();
            while (parser.nextToken() != null) {
                BoxedUnit boxedUnit;
                JsonToken jsonToken4 = parser.getCurrentToken();
                JsonToken jsonToken5 = JsonToken.START_OBJECT;
                if (!(jsonToken4 != null ? !jsonToken4.equals(jsonToken5) : jsonToken5 != null)) {
                    ++size;
                    boxedUnit = parser.skipChildren();
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return size;
        }
        if (JsonToken.END_ARRAY.equals(jsonToken3)) {
            return 0;
        }
        throw new IllegalArgumentException("Root element of JSON feeder file isn't an array of objects");
    }

    public String stringifyNode(JsonNode node, boolean isRootObject) {
        StringBuilder sb = this.stringBuilders().get();
        return Json$.appendStringified$1(node, isRootObject, sb).toString();
    }

    public String stringify(Object value, boolean isRootObject) {
        StringBuilder sb = this.stringBuilders().get();
        return this.appendStringified$2(value, isRootObject, sb).toString();
    }

    public Object asScala(JsonNode node2) {
        JsonNodeType jsonNodeType = node2.getNodeType();
        if (JsonNodeType.ARRAY.equals(jsonNodeType)) {
            int n = node2.size();
            switch (n) {
                case 0: {
                    return Nil$.MODULE$;
                }
                case 1: {
                    return ArraySeq$.MODULE$.unsafeWrapArray((Object)new Object[]{this.asScala(node2.get(0))});
                }
                case 2: {
                    return ArraySeq$.MODULE$.unsafeWrapArray((Object)new Object[]{this.asScala(node2.get(0)), this.asScala(node2.get(1))});
                }
                case 3: {
                    return ArraySeq$.MODULE$.unsafeWrapArray((Object)new Object[]{this.asScala(node2.get(0)), this.asScala(node2.get(1)), this.asScala(node2.get(2))});
                }
                case 4: {
                    return ArraySeq$.MODULE$.unsafeWrapArray((Object)new Object[]{this.asScala(node2.get(0)), this.asScala(node2.get(1)), this.asScala(node2.get(2)), this.asScala(node2.get(3))});
                }
            }
            return CollectionConverters$.MODULE$.IteratorHasAsScala(node2.elements()).asScala().map((Function1 & Serializable)node -> MODULE$.asScala((JsonNode)node)).toVector();
        }
        if (JsonNodeType.OBJECT.equals(jsonNodeType)) {
            int n = node2.size();
            switch (n) {
                case 0: {
                    return Predef$.MODULE$.Map().empty();
                }
                case 1: {
                    Map.Entry entry0 = (Map.Entry)node2.properties().iterator().next();
                    return new Map.Map1(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()));
                }
                case 2: {
                    Iterator it = node2.properties().iterator();
                    Map.Entry entry0 = (Map.Entry)it.next();
                    Map.Entry entry1 = (Map.Entry)it.next();
                    return new Map.Map2(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()), entry1.getKey(), this.asScala((JsonNode)entry1.getValue()));
                }
                case 3: {
                    Iterator it = node2.properties().iterator();
                    Map.Entry entry0 = (Map.Entry)it.next();
                    Map.Entry entry1 = (Map.Entry)it.next();
                    Map.Entry entry2 = (Map.Entry)it.next();
                    return new Map.Map3(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()), entry1.getKey(), this.asScala((JsonNode)entry1.getValue()), entry2.getKey(), this.asScala((JsonNode)entry2.getValue()));
                }
                case 4: {
                    Iterator it = node2.properties().iterator();
                    Map.Entry entry0 = (Map.Entry)it.next();
                    Map.Entry entry1 = (Map.Entry)it.next();
                    Map.Entry entry2 = (Map.Entry)it.next();
                    Map.Entry entry3 = (Map.Entry)it.next();
                    return new Map.Map4(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()), entry1.getKey(), this.asScala((JsonNode)entry1.getValue()), entry2.getKey(), this.asScala((JsonNode)entry2.getValue()), entry3.getKey(), this.asScala((JsonNode)entry3.getValue()));
                }
            }
            return CollectionConverters$.MODULE$.IteratorHasAsScala(node2.properties().iterator()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), MODULE$.asScala((JsonNode)e.getValue()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        if (JsonNodeType.STRING.equals(jsonNodeType)) {
            return node2.textValue();
        }
        if (JsonNodeType.BOOLEAN.equals(jsonNodeType)) {
            return BoxesRunTime.boxToBoolean((boolean)node2.booleanValue());
        }
        if (JsonNodeType.NULL.equals(jsonNodeType)) {
            return null;
        }
        if (JsonNodeType.NUMBER.equals(jsonNodeType)) {
            JsonParser.NumberType numberType = node2.numberType();
            if (JsonParser.NumberType.INT.equals(numberType)) {
                return BoxesRunTime.boxToInteger((int)node2.intValue());
            }
            if (JsonParser.NumberType.LONG.equals(numberType)) {
                return BoxesRunTime.boxToLong((long)node2.longValue());
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType)) {
                return BoxesRunTime.boxToFloat((float)node2.floatValue());
            }
            if (JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return BoxesRunTime.boxToDouble((double)node2.doubleValue());
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType)) {
                return node2.bigIntegerValue();
            }
            if (JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                return node2.decimalValue();
            }
            throw new MatchError((Object)numberType);
        }
        throw new IllegalArgumentException("Unsupported node type " + node2.getNodeType());
    }

    private static final /* synthetic */ Object liftedTree1$1(JsonFactoryBuilder jsonFactoryBuilder$1) {
        BoxedUnit boxedUnit;
        try {
            boxedUnit = jsonFactoryBuilder$1.enable(StreamReadFeature.USE_FAST_DOUBLE_PARSER).enable(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private static final StringBuilder appendStringified$1(JsonNode node, boolean rootLevel, StringBuilder sb$1) {
        JsonNodeType jsonNodeType = node.getNodeType();
        if (JsonNodeType.NUMBER.equals(jsonNodeType)) {
            JsonParser.NumberType numberType = node.numberType();
            if (JsonParser.NumberType.INT.equals(numberType)) {
                return sb$1.append(node.intValue());
            }
            if (JsonParser.NumberType.LONG.equals(numberType)) {
                return sb$1.append(node.longValue());
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType)) {
                return sb$1.append(node.floatValue());
            }
            if (JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return sb$1.append(node.doubleValue());
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType)) {
                return sb$1.append(node.bigIntegerValue());
            }
            if (JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                return sb$1.append(node.decimalValue());
            }
            throw new MatchError((Object)numberType);
        }
        if (JsonNodeType.STRING.equals(jsonNodeType)) {
            return Json$.appendString$1(node.asText(), rootLevel, sb$1);
        }
        if (JsonNodeType.OBJECT.equals(jsonNodeType)) {
            return Json$.appendMap$1(node, sb$1);
        }
        if (JsonNodeType.ARRAY.equals(jsonNodeType)) {
            return Json$.appendArray$1(node, sb$1);
        }
        if (JsonNodeType.BOOLEAN.equals(jsonNodeType)) {
            return sb$1.append(node.booleanValue());
        }
        if (JsonNodeType.NULL.equals(jsonNodeType)) {
            return sb$1.append("null");
        }
        return Json$.appendString$1(node.toString(), rootLevel, sb$1);
    }

    private static final StringBuilder appendString$1(String s, boolean rootLevel, StringBuilder sb$1) {
        if (rootLevel) {
            return Json$.appendString0$1(s, sb$1);
        }
        sb$1.append('\"');
        return Json$.appendString0$1(s, sb$1).append('\"');
    }

    private static final StringBuilder appendString0$1(String s, StringBuilder sb$1) {
        int limit$macro$9 = s.length();
        block9: for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            int c;
            int n = c = s.charAt(index$macro$7);
            switch (n) {
                case 34: {
                    sb$1.append("\\\"");
                    continue block9;
                }
                case 92: {
                    sb$1.append("\\\\");
                    continue block9;
                }
                case 8: {
                    sb$1.append("\\b");
                    continue block9;
                }
                case 12: {
                    sb$1.append("\\f");
                    continue block9;
                }
                case 10: {
                    sb$1.append("\\n");
                    continue block9;
                }
                case 13: {
                    sb$1.append("\\r");
                    continue block9;
                }
                case 9: {
                    sb$1.append("\\t");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl((char)c)) {
                        sb$1.append("\\u");
                        int n2 = c;
                        int limit$macro$4 = 4;
                        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                            int digit = (n2 & 0xF000) >> 12;
                            sb$1.append(Hex$.MODULE$.toHexChar(digit));
                            n2 <<= 4;
                        }
                        continue block9;
                    }
                    sb$1.append((char)c);
                    continue block9;
                }
            }
        }
        return sb$1;
    }

    private static final StringBuilder appendArray$1(JsonNode node, StringBuilder sb$1) {
        block0: {
            sb$1.append('[');
            CollectionConverters$.MODULE$.IteratorHasAsScala(node.elements()).asScala().foreach((Function1 & Serializable)elem -> Json$.appendStringified$1(elem, false, sb$1).append(','));
            if (node.size() <= 0) break block0;
            sb$1.setLength(sb$1.length() - 1);
        }
        return sb$1.append(']');
    }

    private static final StringBuilder appendMap$1(JsonNode node, StringBuilder sb$1) {
        block0: {
            sb$1.append('{');
            CollectionConverters$.MODULE$.IteratorHasAsScala(node.properties().iterator()).asScala().foreach((Function1 & Serializable)e -> {
                sb$1.append('\"').append((String)e.getKey()).append("\":");
                return Json$.appendStringified$1((JsonNode)e.getValue(), false, sb$1).append(',');
            });
            if (node.size() <= 0) break block0;
            sb$1.setLength(sb$1.length() - 1);
        }
        return sb$1.append('}');
    }

    private final StringBuilder appendStringified$2(Object value, boolean rootLevel, StringBuilder sb$2) {
        Object object = value;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return sb$2.append(by);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return sb$2.append(s);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return sb$2.append(n);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return sb$2.append(l);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return sb$2.append(f);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return sb$2.append(d);
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return sb$2.append(bl);
        }
        if (object instanceof String) {
            String string = (String)object;
            return Json$.appendString$2(string, rootLevel, sb$2);
        }
        if (object == null) {
            return sb$2.append("null");
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.appendMap$2(map, sb$2);
        }
        if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            return this.appendMap$2((Map)CollectionConverters$.MODULE$.MapHasAsScala(map).asScala(), sb$2);
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return this.appendArray$2((Iterable)Predef$.MODULE$.genericWrapArray(object2), sb$2);
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return this.appendArray$2(iterable, sb$2);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return this.appendArray$2(CollectionConverters$.MODULE$.CollectionHasAsScala(collection).asScala(), sb$2);
        }
        if (object instanceof Product) {
            Product product = (Product)object;
            return this.appendProduct$1(product, sb$2);
        }
        return sb$2.append(this.objectMapper().writeValueAsString(object));
    }

    private static final StringBuilder appendString$2(String s, boolean rootLevel, StringBuilder sb$2) {
        if (rootLevel) {
            return Json$.appendString0$2(s, sb$2);
        }
        sb$2.append('\"');
        return Json$.appendString0$2(s, sb$2).append('\"');
    }

    private static final StringBuilder appendString0$2(String s, StringBuilder sb$2) {
        int limit$macro$9 = s.length();
        block9: for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            int c;
            int n = c = s.charAt(index$macro$7);
            switch (n) {
                case 34: {
                    sb$2.append("\\\"");
                    continue block9;
                }
                case 92: {
                    sb$2.append("\\\\");
                    continue block9;
                }
                case 8: {
                    sb$2.append("\\b");
                    continue block9;
                }
                case 12: {
                    sb$2.append("\\f");
                    continue block9;
                }
                case 10: {
                    sb$2.append("\\n");
                    continue block9;
                }
                case 13: {
                    sb$2.append("\\r");
                    continue block9;
                }
                case 9: {
                    sb$2.append("\\t");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl((char)c)) {
                        sb$2.append("\\u");
                        int n2 = c;
                        int limit$macro$4 = 4;
                        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                            int digit = (n2 & 0xF000) >> 12;
                            sb$2.append(Hex$.MODULE$.toHexChar(digit));
                            n2 <<= 4;
                        }
                        continue block9;
                    }
                    sb$2.append((char)c);
                    continue block9;
                }
            }
        }
        return sb$2;
    }

    private final StringBuilder appendArray$2(Iterable iterable, StringBuilder sb$2) {
        block0: {
            sb$2.append('[');
            iterable.foreach((Function1 & Serializable)elem -> this.appendStringified$2(elem, false, sb$2).append(','));
            if (!iterable.nonEmpty()) break block0;
            sb$2.setLength(sb$2.length() - 1);
        }
        return sb$2.append(']');
    }

    private final StringBuilder appendMap$2(Map map, StringBuilder sb$2) {
        block0: {
            sb$2.append('{');
            map.foreachEntry((Function2 & Serializable)(k, v) -> {
                sb$2.append('\"').append(k).append("\":");
                return this.appendStringified$2(v, false, sb$2).append(',');
            });
            if (!map.nonEmpty()) break block0;
            sb$2.setLength(sb$2.length() - 1);
        }
        return sb$2.append('}');
    }

    private final StringBuilder appendProduct$1(Product product, StringBuilder sb$2) {
        sb$2.append('{');
        int limit$macro$4 = product.productArity();
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            Object object = index$macro$2 > 0 ? sb$2.append(',') : BoxedUnit.UNIT;
            sb$2.append('\"').append(product.productElementName(index$macro$2)).append("\":");
            this.appendStringified$2(product.productElement(index$macro$2), false, sb$2);
        }
        return sb$2.append('}');
    }

    private Json$() {
    }
}

