/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.End$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleData$;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserCounters;
import io.gatling.core.stats.writer.UserMessage;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\b\u0010\u0001iA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!9q\u0007\u0001b\u0001\n\u0013A\u0004BB!\u0001A\u0003%\u0011\bC\u0003C\u0001\u0011\u00051\tC\u0003J\u0001\u0011\u0005#\nC\u0003T\u0001\u0011\u0005C\u000bC\u0003\\\u0001\u0011%A\fC\u0003d\u0001\u0011%A\rC\u0003l\u0001\u0011%A\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002\u0006\u0001!\t%a\u0002\u0003#\r{gn]8mK\u0012\u000bG/Y,sSR,'O\u0003\u0002\u0011#\u00051qO]5uKJT!AE\n\u0002\u000bM$\u0018\r^:\u000b\u0005Q)\u0012\u0001B2pe\u0016T!AF\f\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0001$\u0001\u0002j_\u000e\u00011C\u0001\u0001\u001c!\raRdH\u0007\u0002\u001f%\u0011ad\u0004\u0002\u000b\t\u0006$\u0018m\u0016:ji\u0016\u0014\bC\u0001\u000f!\u0013\t\tsBA\u0006D_:\u001cx\u000e\\3ECR\f\u0017!B2m_\u000e\\\u0007C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0011)H/\u001b7\u000b\u0005!*\u0012aB2p[6|gn]\u0005\u0003U\u0015\u0012Qa\u00117pG.\fQbY8oM&<WO]1uS>t\u0007CA\u00171\u001b\u0005q#BA\u0018\u0014\u0003\u0019\u0019wN\u001c4jO&\u0011\u0011G\f\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r!TG\u000e\t\u00039\u0001AQAI\u0002A\u0002\rBQaK\u0002A\u00021\naB\u001a7vg\"$\u0016.\\3s\u001d\u0006lW-F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u0015;sS:<\u0017a\u00044mkNDG+[7fe:\u000bW.\u001a\u0011\u0002\r=t\u0017J\\5u)\tyB\tC\u0003F\r\u0001\u0007a)\u0001\u0003j]&$\bC\u0001\u000fH\u0013\tAuB\u0001\u0003J]&$\u0018aB8o\r2,8\u000f\u001b\u000b\u0003\u0017F\u0003\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013A!\u00168ji\")!k\u0002a\u0001?\u0005!A-\u0019;b\u0003%yg.T3tg\u0006<W\rF\u0002L+jCQA\u0016\u0005A\u0002]\u000bq!\\3tg\u0006<W\r\u0005\u0002\u001d1&\u0011\u0011l\u0004\u0002\u0011\u0019>\fG-\u0012<f]RlUm]:bO\u0016DQA\u0015\u0005A\u0002}\tQb\u001c8Vg\u0016\u0014X*Z:tC\u001e,GcA&^E\")a,\u0003a\u0001?\u0006!Qo]3s!\ta\u0002-\u0003\u0002b\u001f\tYQk]3s\u001b\u0016\u001c8/Y4f\u0011\u0015\u0011\u0016\u00021\u0001 \u0003EygNU3ta>t7/Z'fgN\fw-\u001a\u000b\u0004\u0017\u0016T\u0007\"\u00024\u000b\u0001\u00049\u0017\u0001\u0003:fgB|gn]3\u0011\u0005qA\u0017BA5\u0010\u0005=\u0011Vm\u001d9p]N,W*Z:tC\u001e,\u0007\"\u0002*\u000b\u0001\u0004y\u0012AD8o\u000bJ\u0014xN]'fgN\fw-\u001a\u000b\u0004\u00176\u0014\b\"\u00028\f\u0001\u0004y\u0017!B3se>\u0014\bC\u0001\u000fq\u0013\t\txB\u0001\u0007FeJ|'/T3tg\u0006<W\rC\u0003S\u0017\u0001\u0007q$A\u0004p]\u000e\u0013\u0018m\u001d5\u0015\t-+\u00181\u0001\u0005\u0006m2\u0001\ra^\u0001\u0006G\u0006,8/\u001a\t\u0003q~t!!_?\u0011\u0005ilU\"A>\u000b\u0005qL\u0012A\u0002\u001fs_>$h(\u0003\u0002\u007f\u001b\u00061\u0001K]3eK\u001aL1\u0001QA\u0001\u0015\tqX\nC\u0003S\u0019\u0001\u0007q$\u0001\u0004p]N#x\u000e\u001d\u000b\u0004\u0017\u0006%\u0001\"\u0002*\u000e\u0001\u0004y\u0002")
public class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConsoleData onInit(Init init) {
        void var2_2;
        ConsoleData data = new ConsoleData(this.clock.nowMillis(), ConsoleData$.MODULE$.$lessinit$greater$default$2(), ConsoleData$.MODULE$.$lessinit$greater$default$3(), ConsoleData$.MODULE$.$lessinit$greater$default$4(), ConsoleData$.MODULE$.$lessinit$greater$default$5(), ConsoleData$.MODULE$.$lessinit$greater$default$6());
        init.scenarios().foreach((Function1 & Serializable & scala.Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().console().writePeriod(), true);
        return var2_2;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, ConsoleSummary$.MODULE$.apply$default$7());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(LoadEventMessage message, ConsoleData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            this.onErrorMessage(errorMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onUserMessage(UserMessage user, ConsoleData data) {
        MessageEvent messageEvent = user.event();
        if (Start$.MODULE$.equals(messageEvent)) {
            Option option = data.usersCounters().get((Object)user.session().scenario());
            if (option instanceof Some) {
                Some some = (Some)option;
                UserCounters userCounters = (UserCounters)some.value();
                userCounters.userStart();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.session().scenario()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (End$.MODULE$.equals(messageEvent)) {
            Option option = data.usersCounters().get((Object)user.session().scenario());
            if (option instanceof Some) {
                Some some = (Some)option;
                UserCounters userCounters = (UserCounters)some.value();
                userCounters.userDone();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.session().scenario()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)messageEvent);
        }
    }

    private void onResponseMessage(ResponseMessage response, ConsoleData data) {
        String requestPath = ((TraversableOnce)response.groupHierarchy().$colon$plus((Object)response.name(), List$.MODULE$.canBuildFrom())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable & scala.Serializable)() -> new RequestCounters(RequestCounters$.MODULE$.$lessinit$greater$default$1(), RequestCounters$.MODULE$.$lessinit$greater$default$2()));
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable & scala.Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status);
        }
    }

    private void onErrorMessage(ErrorMessage error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        block0: {
            this.cancelTimer(this.flushTimerName());
            if (data.complete()) break block0;
            this.onFlush(data);
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

