/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.AssertionSerializer;
import io.gatling.core.stats.writer.BufferedFileChannelWriter;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.ErrorMessageSerializer;
import io.gatling.core.stats.writer.FileData;
import io.gatling.core.stats.writer.GroupMessage;
import io.gatling.core.stats.writer.GroupMessageSerializer;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.ResponseMessageSerializer;
import io.gatling.core.stats.writer.RunMessageSerializer;
import io.gatling.core.stats.writer.UserMessage;
import io.gatling.core.stats.writer.UserMessageSerializer;
import java.io.Serializable;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0003\u0006\u0001+!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015Y\u0006\u0001\"\u0011]\u0005Eaun\u001a$jY\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u00171\taa\u001e:ji\u0016\u0014(BA\u0007\u000f\u0003\u0015\u0019H/\u0019;t\u0015\ty\u0001#\u0001\u0003d_J,'BA\t\u0013\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aE\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001-A\u0019q\u0003\u0007\u000e\u000e\u0003)I!!\u0007\u0006\u0003\u0015\u0011\u000bG/Y,sSR,'\u000f\u0005\u0002\u00187%\u0011AD\u0003\u0002\t\r&dW\rR1uC\u0006)1\r\\8dWB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005kRLGN\u0003\u0002$!\u000591m\\7n_:\u001c\u0018BA\u0013!\u0005\u0015\u0019En\\2l\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011\u0001fK\u0007\u0002S)\u0011!FD\u0001\u0007G>tg-[4\n\u00051J#\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004CA\f\u0001\u0011\u0015i2\u00011\u0001\u001f\u0011\u001513\u00011\u0001(\u0003\u0019yg.\u00138jiR\u0011!\u0004\u000e\u0005\u0006k\u0011\u0001\rAN\u0001\u0005S:LG\u000f\u0005\u0002\u0018o%\u0011\u0001H\u0003\u0002\u0005\u0013:LG/A\u0004p]\u001acWo\u001d5\u0015\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$\u0001B+oSRDQAQ\u0003A\u0002i\tA\u0001Z1uC\u0006IqN\\'fgN\fw-\u001a\u000b\u0004w\u0015S\u0005\"\u0002$\u0007\u0001\u00049\u0015aB7fgN\fw-\u001a\t\u0003/!K!!\u0013\u0006\u0003!1{\u0017\rZ#wK:$X*Z:tC\u001e,\u0007\"\u0002\"\u0007\u0001\u0004Q\u0012aB8o\u0007J\f7\u000f\u001b\u000b\u0004w5S\u0006\"\u0002(\b\u0001\u0004y\u0015!B2bkN,\u0007C\u0001)X\u001d\t\tV\u000b\u0005\u0002S{5\t1K\u0003\u0002U)\u00051AH]8pizJ!AV\u001f\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-vBQAQ\u0004A\u0002i\taa\u001c8Ti>\u0004HCA\u001e^\u0011\u0015\u0011\u0005\u00021\u0001\u001b\u0001")
public class LogFileDataWriter
extends DataWriter<FileData> {
    private final GatlingConfiguration configuration;

    @Override
    public FileData onInit(Init init) {
        BufferedFileChannelWriter writer = BufferedFileChannelWriter$.MODULE$.apply(init.runMessage().runId(), this.configuration);
        AssertionSerializer assertionSerializer = new AssertionSerializer(writer);
        init.assertions().foreach((Function1 & Serializable & scala.Serializable)assertion -> {
            assertionSerializer.serialize(assertion);
            return BoxedUnit.UNIT;
        });
        new RunMessageSerializer(writer).serialize(init.runMessage());
        return new FileData(new UserMessageSerializer(writer), new ResponseMessageSerializer(writer), new GroupMessageSerializer(writer), new ErrorMessageSerializer(writer), writer);
    }

    @Override
    public void onFlush(FileData data) {
    }

    @Override
    public void onMessage(LoadEventMessage message, FileData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            data.userMessageSerializer().serialize(userMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof GroupMessage) {
            GroupMessage groupMessage = (GroupMessage)loadEventMessage;
            data.groupMessageSerializer().serialize(groupMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            data.responseMessageSerializer().serialize(responseMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            data.errorMessageSerializer().serialize(errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void onCrash(String cause, FileData data) {
    }

    @Override
    public void onStop(FileData data) {
        data.writer().close();
    }

    public LogFileDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.configuration = configuration;
    }
}

