/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.controller.inject;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.UserEndMessage;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d!\u0002\u000e\u001c\u0003\u00031\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A!\f\u0001B\u0001B\u0003%1\fC\u0003c\u0001\u0011\u00051\rC\u0004l\u0001\u0001\u0007I\u0011\u00027\t\u000fA\u0004\u0001\u0019!C\u0005c\"1q\u000f\u0001Q!\n5Dq\u0001\u001f\u0001A\u0002\u0013%A\u000eC\u0004z\u0001\u0001\u0007I\u0011\u0002>\t\rq\u0004\u0001\u0015)\u0003n\u0011\u001di\b\u00011A\u0005\nyD\u0011\"!\u0002\u0001\u0001\u0004%I!a\u0002\t\u000f\u0005-\u0001\u0001)Q\u0005\u007f\"9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\t\u0001\u0011E\u0011q\u0002\u0005\b\u0003'\u0001A\u0011CA\b\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!!\f\u0001\t#\ty\u0003\u0003\u0004\u0002D\u0001!\t\u0002\u001c\u0005\b\u0003\u000b\u0002a\u0011AA$\u0011\u001d\ti\u0005\u0001D\u0001\u0003\u001fBa!!\u0019\u0001\t\u0003q\bBBA2\u0001\u0011\u0005aP\u0001\u0005X_J\\Gn\\1e\u0015\taR$\u0001\u0004j]*,7\r\u001e\u0006\u0003=}\t!bY8oiJ|G\u000e\\3s\u0015\t\u0001\u0013%\u0001\u0003d_J,'B\u0001\u0012$\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001J\u0001\u0003S>\u001c\u0001aE\u0002\u0001O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007C\u0001\u00186\u001b\u0005y#B\u0001\u00192\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u00114'\u0001\u0005usB,7/\u00194f\u0015\u0005!\u0014aA2p[&\u0011ag\f\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u0011M\u001cWM\\1sS>\u0004\"!O\u001e\u000e\u0003iR!aN\u0010\n\u0005qR$\u0001C*dK:\f'/[8\u0002\u0013U\u001cXM]%e\u000f\u0016t\u0007CA I\u001b\u0005\u0001%BA!C\u0003\u0019\tGo\\7jG*\u00111\tR\u0001\u000bG>t7-\u001e:sK:$(BA#G\u0003\u0011)H/\u001b7\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0011\u0002\u000b\u0003R|W.[2M_:<\u0017AD3wK:$Hj\\8q\u000fJ|W\u000f\u001d\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bqa\u00195b]:,GN\u0003\u0002QG\u0005)a.\u001a;us&\u0011!+\u0014\u0002\u000f\u000bZ,g\u000e\u001e'p_B<%o\\;q\u0003-\u0019H/\u0019;t\u000b:<\u0017N\\3\u0011\u0005UCV\"\u0001,\u000b\u0005]{\u0012!B:uCR\u001c\u0018BA-W\u0005-\u0019F/\u0019;t\u000b:<\u0017N\\3\u0002\u000b\rdwnY6\u0011\u0005q\u0003W\"A/\u000b\u0005\u0015s&BA0\"\u0003\u001d\u0019w.\\7p]NL!!Y/\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\u0019!gm\u001a5jUB\u0011Q\rA\u0007\u00027!)qG\u0002a\u0001q!)QH\u0002a\u0001}!)!J\u0002a\u0001\u0017\")1K\u0002a\u0001)\")!L\u0002a\u00017\u0006I1o\u00195fIVdW\rZ\u000b\u0002[B\u0011\u0001F\\\u0005\u0003_&\u00121!\u00138u\u00035\u00198\r[3ek2,Gm\u0018\u0013fcR\u0011!/\u001e\t\u0003QML!\u0001^\u0015\u0003\tUs\u0017\u000e\u001e\u0005\bm\"\t\t\u00111\u0001n\u0003\rAH%M\u0001\u000bg\u000eDW\rZ;mK\u0012\u0004\u0013aB:u_B\u0004X\rZ\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0002sw\"9aoCA\u0001\u0002\u0004i\u0017\u0001C:u_B\u0004X\r\u001a\u0011\u0002\u0019\u0005dGnU2iK\u0012,H.\u001a3\u0016\u0003}\u00042\u0001KA\u0001\u0013\r\t\u0019!\u000b\u0002\b\u0005>|G.Z1o\u0003A\tG\u000e\\*dQ\u0016$W\u000f\\3e?\u0012*\u0017\u000fF\u0002s\u0003\u0013AqA\u001e\b\u0002\u0002\u0003\u0007q0A\u0007bY2\u001c6\r[3ek2,G\rI\u0001\u0018S:\u001c'/Z7f]R\u001c6\r[3ek2,G-V:feN$\u0012A]\u0001\u0010g\u0016$\u0018\t\u001c7TG\",G-\u001e7fI\u0006)\u0012N\\2sK6,g\u000e^*u_B\u0004X\rZ+tKJ\u001c\u0018!C:uCJ$Xk]3s)\u0015\u0011\u0018\u0011DA\u0012\u0011\u001d\tYb\u0005a\u0001\u0003;\ta!^:fe&#\u0007c\u0001\u0015\u0002 %\u0019\u0011\u0011E\u0015\u0003\t1{gn\u001a\u0005\b\u0003K\u0019\u0002\u0019AA\u0014\u0003%)g/\u001a8u\u0019>|\u0007\u000fE\u0002M\u0003SI1!a\u000bN\u0005%)e/\u001a8u\u0019>|\u0007/\u0001\u0006j]*,7\r^+tKJ$2A]A\u0019\u0011\u001d\t\u0019\u0004\u0006a\u0001\u0003k\tQ\u0001Z3mCf\u0004B!a\u000e\u0002@5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0005ekJ\fG/[8o\u0015\t\u0019\u0015&\u0003\u0003\u0002B\u0005e\"A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0013O\u0016$8i\u001c8dkJ\u0014XM\u001c;Vg\u0016\u00148/A\u0006j]*,7\r\u001e\"bi\u000eDGc\u0001:\u0002J!9\u00111\n\fA\u0002\u0005U\u0012a\u00032bi\u000eDw+\u001b8e_^\fq!\u001a8e+N,'\u000fF\u0002s\u0003#Bq!a\u0015\u0018\u0001\u0004\t)&A\u0006vg\u0016\u0014X*Z:tC\u001e,\u0007\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005mc+\u0001\u0004xe&$XM]\u0005\u0005\u0003?\nIF\u0001\bVg\u0016\u0014XI\u001c3NKN\u001c\u0018mZ3\u0002'%\u001c\u0018\t\u001c7Vg\u0016\u00148oU2iK\u0012,H.\u001a3\u0002#%\u001c\u0018\t\u001c7Vg\u0016\u00148o\u0015;paB,G\r")
public abstract class Workload
implements StrictLogging {
    private final Scenario scenario;
    private final AtomicLong userIdGen;
    private final EventLoopGroup eventLoopGroup;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private int scheduled;
    private int stopped;
    private boolean allScheduled;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(int x$1) {
        this.scheduled = x$1;
    }

    private int stopped() {
        return this.stopped;
    }

    private void stopped_$eq(int x$1) {
        this.stopped = x$1;
    }

    private boolean allScheduled() {
        return this.allScheduled;
    }

    private void allScheduled_$eq(boolean x$1) {
        this.allScheduled = x$1;
    }

    private void incrementScheduledUsers() {
        this.scheduled_$eq(this.scheduled() + 1);
    }

    public void setAllScheduled() {
        this.allScheduled_$eq(true);
    }

    public void incrementStoppedUsers() {
        this.stopped_$eq(this.stopped() + 1);
    }

    private void startUser(long userId, EventLoop eventLoop) {
        BoxedUnit boxedUnit;
        Session rawSession = Session$.MODULE$.apply(this.scenario.name(), userId, this.scenario.onExit(), eventLoop);
        Session session = (Session)this.scenario.onStart().apply((Object)rawSession);
        long timestamp = this.clock.nowMillis();
        this.scenario.entry().$bang(session);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Start user #{}", new Object[]{BoxesRunTime.boxToLong((long)session.userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.statsEngine.logUserStart(this.scenario.name(), timestamp);
    }

    public void injectUser(FiniteDuration delay) {
        block2: {
            this.incrementScheduledUsers();
            long userId = this.userIdGen.incrementAndGet();
            EventLoop eventLoop = this.eventLoopGroup.next();
            if (eventLoop.isShutdown()) break block2;
            if (delay.$less$eq((Object)Duration$.MODULE$.Zero())) {
                eventLoop.execute(() -> this.startUser(userId, eventLoop));
            } else {
                eventLoop.schedule(() -> this.startUser(userId, eventLoop), delay.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public int getConcurrentUsers() {
        return this.scheduled() - this.stopped();
    }

    public abstract void injectBatch(FiniteDuration var1);

    public abstract void endUser(UserEndMessage var1);

    public boolean isAllUsersScheduled() {
        return this.allScheduled();
    }

    public boolean isAllUsersStopped() {
        return this.allScheduled() && this.scheduled() == this.stopped();
    }

    public Workload(Scenario scenario, AtomicLong userIdGen, EventLoopGroup eventLoopGroup, StatsEngine statsEngine, Clock clock) {
        this.scenario = scenario;
        this.userIdGen = userIdGen;
        this.eventLoopGroup = eventLoopGroup;
        this.statsEngine = statsEngine;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.scheduled = 0;
        this.stopped = 0;
        this.allScheduled = false;
    }
}

