/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserCounters;
import io.gatling.core.stats.writer.UserEndMessage;
import io.gatling.core.stats.writer.UserStartMessage;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-b!B\b\u0011\u0005YQ\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u00111\u0002!\u0011!Q\u0001\n5BQa\r\u0001\u0005\u0002QBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006)\u0002!\t%\u0016\u0005\u00069\u0002!I!\u0018\u0005\u0006I\u0002!I!\u001a\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006w\u0002!I\u0001 \u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\t)\u0003\u0001C!\u0003O\u0011\u0011cQ8og>dW\rR1uC^\u0013\u0018\u000e^3s\u0015\t\t\"#\u0001\u0004xe&$XM\u001d\u0006\u0003'Q\tQa\u001d;biNT!!\u0006\f\u0002\t\r|'/\u001a\u0006\u0003/a\tqaZ1uY&twMC\u0001\u001a\u0003\tIwn\u0005\u0002\u00017A\u0019A$H\u0010\u000e\u0003AI!A\b\t\u0003\u0015\u0011\u000bG/Y,sSR,'\u000f\u0005\u0002\u001dA%\u0011\u0011\u0005\u0005\u0002\f\u0007>t7o\u001c7f\t\u0006$\u0018-A\u0003dY>\u001c7n\u0001\u0001\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001B;uS2T!!\u000b\f\u0002\u000f\r|W.\\8og&\u00111F\n\u0002\u0006\u00072|7m[\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0012AB2p]\u001aLw-\u0003\u00023_\t!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDcA\u001b7oA\u0011A\u0004\u0001\u0005\u0006E\r\u0001\r\u0001\n\u0005\u0006Y\r\u0001\r!L\u0001\u000fM2,8\u000f\u001b+j[\u0016\u0014h*Y7f+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0011a\u0017M\\4\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f\u0019dWo\u001d5US6,'OT1nK\u0002\naa\u001c8J]&$HCA\u0010F\u0011\u00151e\u00011\u0001H\u0003\u0011Ig.\u001b;\u0011\u0005qA\u0015BA%\u0011\u0005\u0011Ie.\u001b;\u0002\u000f=tg\t\\;tQR\u0011AJ\u0015\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0005+:LG\u000fC\u0003T\u000f\u0001\u0007q$\u0001\u0003eCR\f\u0017!C8o\u001b\u0016\u001c8/Y4f)\raek\u0017\u0005\u0006/\"\u0001\r\u0001W\u0001\b[\u0016\u001c8/Y4f!\ta\u0012,\u0003\u0002[!\t\u0001Bj\\1e\u000bZ,g\u000e^'fgN\fw-\u001a\u0005\u0006'\"\u0001\raH\u0001\u0013_:,6/\u001a:Ti\u0006\u0014H/T3tg\u0006<W\rF\u0002M=\u000eDQaX\u0005A\u0002\u0001\fA!^:feB\u0011A$Y\u0005\u0003EB\u0011\u0001#V:feN#\u0018M\u001d;NKN\u001c\u0018mZ3\t\u000bMK\u0001\u0019A\u0010\u0002!=tWk]3s\u000b:$W*Z:tC\u001e,Gc\u0001'gU\")qL\u0003a\u0001OB\u0011A\u0004[\u0005\u0003SB\u0011a\"V:fe\u0016sG-T3tg\u0006<W\rC\u0003T\u0015\u0001\u0007q$A\tp]J+7\u000f]8og\u0016lUm]:bO\u0016$2\u0001T7s\u0011\u0015q7\u00021\u0001p\u0003!\u0011Xm\u001d9p]N,\u0007C\u0001\u000fq\u0013\t\t\bCA\bSKN\u0004xN\\:f\u001b\u0016\u001c8/Y4f\u0011\u0015\u00196\u00021\u0001 Q\u0011YAo\u001e=\u0011\u0005m*\u0018B\u0001<=\u0005A\u0019V\u000f\u001d9sKN\u001cx+\u0019:oS:<7/A\u0003wC2,X\rL\u0001zC\u0005Q\u0018\u0001I8sO::\u0018M\u001d;sK6|g/\u001a:/o\u0006\u0014Ho\u001d\u0018MSN$\u0018\t\u001d9f]\u0012\fab\u001c8FeJ|'/T3tg\u0006<W\r\u0006\u0003M{\u0006\u0015\u0001\"\u0002@\r\u0001\u0004y\u0018!B3se>\u0014\bc\u0001\u000f\u0002\u0002%\u0019\u00111\u0001\t\u0003\u0019\u0015\u0013(o\u001c:NKN\u001c\u0018mZ3\t\u000bMc\u0001\u0019A\u0010\u0002\u000f=t7I]1tQR)A*a\u0003\u0002$!9\u0011QB\u0007A\u0002\u0005=\u0011!B2bkN,\u0007\u0003BA\t\u0003?qA!a\u0005\u0002\u001cA\u0019\u0011Q\u0003(\u000e\u0005\u0005]!bAA\rG\u00051AH]8pizJ1!!\bO\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011)!\t\u000b\u0007\u0005ua\nC\u0003T\u001b\u0001\u0007q$\u0001\u0004p]N#x\u000e\u001d\u000b\u0004\u0019\u0006%\u0002\"B*\u000f\u0001\u0004y\u0002")
public final class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConsoleData onInit(Init init) {
        void var2_2;
        ConsoleData data = new ConsoleData(this.clock.nowMillis());
        init.scenarios().foreach((Function1 & Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        this.startTimerAtFixedRate(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().console().writePeriod());
        return var2_2;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, new Date());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(LoadEventMessage message, ConsoleData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserStartMessage) {
            UserStartMessage userStartMessage = (UserStartMessage)loadEventMessage;
            this.onUserStartMessage(userStartMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof UserEndMessage) {
            UserEndMessage userEndMessage = (UserEndMessage)loadEventMessage;
            this.onUserEndMessage(userEndMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            this.onErrorMessage(errorMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onUserStartMessage(UserStartMessage user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userStart();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void onUserEndMessage(UserEndMessage user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userDone();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void onResponseMessage(ResponseMessage response, ConsoleData data) {
        String requestPath = ((IterableOnceOps)response.groupHierarchy().$colon$plus((Object)response.name())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable)() -> RequestCounters$.MODULE$.empty());
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status);
        }
    }

    private void onErrorMessage(ErrorMessage error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        block0: {
            this.cancelTimer(this.flushTimerName());
            if (data.complete()) break block0;
            this.onFlush(data);
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

