/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.Adaptive$;
import io.gatling.core.feeder.Batch;
import io.gatling.core.feeder.Batch$;
import io.gatling.core.feeder.BatchedSeparatedValuesFeeder$;
import io.gatling.core.feeder.FeederLoadingMode;
import io.gatling.core.feeder.FeederOptions;
import io.gatling.core.feeder.FeederSource;
import io.gatling.core.feeder.InMemoryFeeder$;
import io.gatling.core.feeder.SeparatedValuesFeederSource$;
import io.gatling.core.feeder.SeparatedValuesParser$;
import io.gatling.core.util.Resource;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005m;aAC\u0006\t\u0002=\u0019bAB\u000b\f\u0011\u0003ya\u0003C\u0003\u001e\u0003\u0011\u0005q\u0004C\u0003!\u0003\u0011%\u0011EB\u0003\u0016\u0017\ty!\u0006\u0003\u0005*\t\t\u0005\t\u0015!\u0003#\u0011!IDA!A!\u0002\u0013Q\u0004\u0002C\u001f\u0005\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000bu!A\u0011\u0001 \t\u000b1!A\u0011I\"\u00027M+\u0007/\u0019:bi\u0016$g+\u00197vKN4U-\u001a3feN{WO]2f\u0015\taQ\"\u0001\u0004gK\u0016$WM\u001d\u0006\u0003\u001d=\tAaY8sK*\u0011\u0001#E\u0001\bO\u0006$H.\u001b8h\u0015\u0005\u0011\u0012AA5p!\t!\u0012!D\u0001\f\u0005m\u0019V\r]1sCR,GMV1mk\u0016\u001ch)Z3eKJ\u001cv.\u001e:dKN\u0011\u0011a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aE\u0001\u0006k:T\u0018\u000e\u001d\u000b\u0003E!\u0002\"a\t\u0014\u000e\u0003\u0011R!!J\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003O\u0011\u0012\u0001BU3t_V\u00148-\u001a\u0005\u0006S\r\u0001\rAI\u0001\te\u0016\u001cx.\u001e:dKN\u0019AaF\u0016\u0011\u0007Qac&\u0003\u0002.\u0017\taa)Z3eKJ\u001cv.\u001e:dKB\u0011qF\u000e\b\u0003aQ\u0002\"!M\r\u000e\u0003IR!a\r\u0010\u0002\rq\u0012xn\u001c;?\u0013\t)\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u001a\u0003%\u0019X\r]1sCR|'\u000f\u0005\u0002\u0019w%\u0011A(\u0007\u0002\u0005\u0007\"\f'/A\u0005rk>$Xm\u00115beR!q\bQ!C!\t!B\u0001C\u0003*\u0011\u0001\u0007!\u0005C\u0003:\u0011\u0001\u0007!\bC\u0003>\u0011\u0001\u0007!\bF\u0002E\u001dN\u00032!\u0012%L\u001d\t!b)\u0003\u0002H\u0017\u00059\u0001/Y2lC\u001e,\u0017BA%K\u0005\u00191U-\u001a3fe*\u0011qi\u0003\t\u000311K!!T\r\u0003\u0007\u0005s\u0017\u0010C\u0003P\u0013\u0001\u0007\u0001+A\u0004paRLwN\\:\u0011\u0007Q\tf&\u0003\u0002S\u0017\tia)Z3eKJ|\u0005\u000f^5p]NDQ\u0001V\u0005A\u0002U\u000bQbY8oM&<WO]1uS>t\u0007C\u0001,Z\u001b\u00059&B\u0001-\u000e\u0003\u0019\u0019wN\u001c4jO&\u0011!l\u0016\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public final class SeparatedValuesFeederSource
implements FeederSource<String> {
    private final Resource resource;
    private final char separator;
    private final char quoteChar;

    @Override
    public Iterator<Map<String, Object>> feeder(FeederOptions<String> options, GatlingConfiguration configuration) {
        Resource uncompressedResource = options.unzip() ? SeparatedValuesFeederSource$.MODULE$.io$gatling$core$feeder$SeparatedValuesFeederSource$$unzip(this.resource) : this.resource;
        return this.applyBatch$1(uncompressedResource, configuration, options);
    }

    private final Iterator applyBatch$1(Resource res, GatlingConfiguration configuration$1, FeederOptions options$1) {
        Iterator<Map<String, Object>> iterator;
        Charset charset = configuration$1.core().charset();
        FeederLoadingMode feederLoadingMode = options$1.loadingMode();
        if (feederLoadingMode instanceof Batch) {
            Batch batch = (Batch)feederLoadingMode;
            int bufferSize = batch.bufferSize();
            iterator = BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), bufferSize, charset);
        } else if (Adaptive$.MODULE$.equals(feederLoadingMode) && res.file().length() > configuration$1.core().feederAdaptiveLoadModeThreshold()) {
            iterator = BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), Batch$.MODULE$.DefaultBufferLines(), charset);
        } else {
            Vector records = (Vector)Using$.MODULE$.resource((Object)FileChannel.open(res.file().toPath(), new OpenOption[0]), (Function1 & Serializable)channel -> ((IterableOnceOps)SeparatedValuesParser$.MODULE$.stream($this.separator, $this.quoteChar, charset).apply(channel)).toVector(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            iterator = InMemoryFeeder$.MODULE$.apply(records, options$1.conversion(), options$1.strategy());
        }
        return iterator;
    }

    public SeparatedValuesFeederSource(Resource resource, char separator, char quoteChar) {
        this.resource = resource;
        this.separator = separator;
        this.quoteChar = quoteChar;
    }
}

