/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.Adaptive$;
import io.gatling.core.feeder.Batch;
import io.gatling.core.feeder.Batch$;
import io.gatling.core.feeder.BatchedSeparatedValuesFeeder$;
import io.gatling.core.feeder.FeederLoadingMode;
import io.gatling.core.feeder.FeederOptions;
import io.gatling.core.feeder.FeederSource;
import io.gatling.core.feeder.InMemoryFeeder$;
import io.gatling.core.feeder.SeparatedValuesParser$;
import io.gatling.core.feeder.Unzip$;
import io.gatling.core.util.Resource;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005A3QAB\u0004\u0003\u0017=A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%a\u0006C\u00033\u0001\u0011\u00051\u0007C\u0003\t\u0001\u0011\u0005\u0003HA\u000eTKB\f'/\u0019;fIZ\u000bG.^3t\r\u0016,G-\u001a:T_V\u00148-\u001a\u0006\u0003\u0011%\taAZ3fI\u0016\u0014(B\u0001\u0006\f\u0003\u0011\u0019wN]3\u000b\u00051i\u0011aB4bi2Lgn\u001a\u0006\u0002\u001d\u0005\u0011\u0011n\\\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rE\u0002\u00181ii\u0011aB\u0005\u00033\u001d\u0011ABR3fI\u0016\u00148k\\;sG\u0016\u0004\"aG\u0012\u000f\u0005q\t\u0003CA\u000f\u0013\u001b\u0005q\"BA\u0010!\u0003\u0019a$o\\8u}\r\u0001\u0011B\u0001\u0012\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0012\u0012\u0001\u0003:fg>,(oY3\u0011\u0005!ZS\"A\u0015\u000b\u0005)J\u0011\u0001B;uS2L!\u0001L\u0015\u0003\u0011I+7o\\;sG\u0016\f\u0011b]3qCJ\fGo\u001c:\u0011\u0005Ey\u0013B\u0001\u0019\u0013\u0005\u0011\u0019\u0005.\u0019:\u0002\u0013E,x\u000e^3DQ\u0006\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00035kY:\u0004CA\f\u0001\u0011\u00151C\u00011\u0001(\u0011\u0015iC\u00011\u0001/\u0011\u0015\tD\u00011\u0001/)\rI4\t\u0013\t\u0004uu\u0002eBA\f<\u0013\tat!A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$A\u0002$fK\u0012,'O\u0003\u0002=\u000fA\u0011\u0011#Q\u0005\u0003\u0005J\u00111!\u00118z\u0011\u0015!U\u00011\u0001F\u0003\u001dy\u0007\u000f^5p]N\u00042a\u0006$\u001b\u0013\t9uAA\u0007GK\u0016$WM](qi&|gn\u001d\u0005\u0006\u0013\u0016\u0001\rAS\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005-sU\"\u0001'\u000b\u00055K\u0011AB2p]\u001aLw-\u0003\u0002P\u0019\n!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public final class SeparatedValuesFeederSource
implements FeederSource<String> {
    private final Resource resource;
    private final char separator;
    private final char quoteChar;

    @Override
    public Iterator<Map<String, Object>> feeder(FeederOptions<String> options, GatlingConfiguration configuration) {
        Resource uncompressedResource = options.unzip() ? Unzip$.MODULE$.unzip(this.resource) : this.resource;
        return this.applyBatch$1(uncompressedResource, configuration, options);
    }

    private final Iterator applyBatch$1(Resource res, GatlingConfiguration configuration$1, FeederOptions options$1) {
        Iterator<Map<String, Object>> iterator;
        Charset charset = configuration$1.core().charset();
        FeederLoadingMode feederLoadingMode = options$1.loadingMode();
        if (feederLoadingMode instanceof Batch) {
            Batch batch = (Batch)feederLoadingMode;
            int bufferSize = batch.bufferSize();
            iterator = BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), bufferSize, charset);
        } else if (Adaptive$.MODULE$.equals(feederLoadingMode) && res.file().length() > configuration$1.core().feederAdaptiveLoadModeThreshold()) {
            iterator = BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), Batch$.MODULE$.DefaultBufferLines(), charset);
        } else {
            Vector records = (Vector)Using$.MODULE$.resource((Object)FileChannel.open(res.file().toPath(), new OpenOption[0]), (Function1 & Serializable)channel -> ((IterableOnceOps)SeparatedValuesParser$.MODULE$.stream($this.separator, $this.quoteChar, charset).apply(channel)).toVector(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            iterator = InMemoryFeeder$.MODULE$.apply(records, options$1.conversion(), options$1.strategy());
        }
        return iterator;
    }

    public SeparatedValuesFeederSource(Resource resource, char separator, char quoteChar) {
        this.resource = resource;
        this.separator = separator;
        this.quoteChar = quoteChar;
    }
}

