/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.body;

import io.gatling.commons.util.FastByteArrayInputStream;
import io.gatling.commons.util.GzipHelper$;
import io.gatling.commons.validation.Validation;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.session.Session;
import io.gatling.core.session.package$;
import io.gatling.core.session.package$RichExpression$;
import io.gatling.core.util.Resource;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;

public final class BodyProcessors$ {
    public static final BodyProcessors$ MODULE$ = new BodyProcessors$();

    public Function1<Body, ByteArrayBody> gzip() {
        return (Function1 & Serializable)body -> {
            Function1 function1;
            Body body2 = body;
            if (body2 instanceof StringBody) {
                StringBody stringBody = (StringBody)body2;
                Function1<Session, Validation<String>> string = stringBody.string();
                Charset charset = stringBody.charset();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(string), (Function1 & Serializable)x$1 -> GzipHelper$.MODULE$.gzip(x$1, charset));
            } else if (body2 instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
                Function1<Session, Validation<byte[]>> byteArray = byteArrayBody.bytes();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(byteArray), (Function1 & Serializable)bytes -> GzipHelper$.MODULE$.gzip(bytes));
            } else if (body2 instanceof RawFileBody) {
                RawFileBody rawFileBody = (RawFileBody)body2;
                Function1<Session, Validation<ResourceAndCachedBytes>> resourceAndCachedBytes = rawFileBody.resourceAndCachedBytes();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(resourceAndCachedBytes), (Function1 & Serializable)x0$1 -> {
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                    if (resourceAndCachedBytes != null) {
                        Resource resource = resourceAndCachedBytes.resource();
                        Option<byte[]> cachedBytes = resourceAndCachedBytes.cachedBytes();
                        Option<byte[]> option = cachedBytes;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            byte[] bytes = (byte[])some.value();
                            return GzipHelper$.MODULE$.gzip(bytes);
                        }
                        return GzipHelper$.MODULE$.gzip(resource.inputStream());
                    }
                    throw new MatchError((Object)resourceAndCachedBytes);
                });
            } else if (body2 instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body2;
                Function1<Session, Validation<InputStream>> inputStream = inputStreamBody.is();
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(inputStream), (Function1 & Serializable)in -> GzipHelper$.MODULE$.gzip(in));
            } else if (body2 instanceof ElBody) {
                ElBody elBody = (ElBody)body2;
                function1 = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(elBody.asStream()), (Function1 & Serializable)in -> GzipHelper$.MODULE$.gzip(in));
            } else {
                throw new MatchError((Object)body2);
            }
            Function1 gzippedBytes = function1;
            return new ByteArrayBody(gzippedBytes);
        };
    }

    public Function1<Body, InputStreamBody> stream() {
        return (Function1 & Serializable)body -> {
            Object object;
            Body body2 = body;
            if (body2 instanceof StringBody) {
                StringBody stringBody = (StringBody)body2;
                Function1<Session, Validation<String>> string = stringBody.string();
                Charset charset = stringBody.charset();
                object = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(string), (Function1 & Serializable)s -> new FastByteArrayInputStream(s.getBytes(charset)));
            } else if (body2 instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
                Function1<Session, Validation<byte[]>> byteArray = byteArrayBody.bytes();
                object = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(byteArray), (Function1 & Serializable)x$2 -> new FastByteArrayInputStream(x$2));
            } else if (body2 instanceof RawFileBody) {
                RawFileBody rawFileBody = (RawFileBody)body2;
                Function1<Session, Validation<ResourceAndCachedBytes>> resourceAndCachedBytes = rawFileBody.resourceAndCachedBytes();
                object = package$RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(resourceAndCachedBytes), (Function1 & Serializable)x0$1 -> {
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                    if (resourceAndCachedBytes != null) {
                        Resource resource = resourceAndCachedBytes.resource();
                        Option<byte[]> cachedBytes = resourceAndCachedBytes.cachedBytes();
                        Option<byte[]> option = cachedBytes;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            byte[] bytes = (byte[])some.value();
                            return new FastByteArrayInputStream(bytes);
                        }
                        return resource.inputStream();
                    }
                    throw new MatchError((Object)resourceAndCachedBytes);
                });
            } else if (body2 instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body2;
                Function1<Session, Validation<InputStream>> inputStream = inputStreamBody.is();
                object = inputStream;
            } else if (body2 instanceof ElBody) {
                ElBody elBody = (ElBody)body2;
                object = elBody.asStream();
            } else {
                throw new MatchError((Object)body2);
            }
            Function1 stream = object;
            return new InputStreamBody(stream);
        };
    }

    private BodyProcessors$() {
    }
}

