/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.http.PackagesApiRequests;
import io.gatling.plugin.client.http.PoolsApiRequests;
import io.gatling.plugin.client.http.PrivateApiRequests;
import io.gatling.plugin.client.http.SimulationsApiRequests;
import io.gatling.plugin.client.http.TeamsApiRequests;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import io.gatling.plugin.model.HostByPool;
import io.gatling.plugin.model.MeaningfulTimeWindow;
import io.gatling.plugin.model.PackageCreationPayload;
import io.gatling.plugin.model.Pkg;
import io.gatling.plugin.model.PkgIndex;
import io.gatling.plugin.model.Pool;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationCreationPayload;
import io.gatling.plugin.model.SystemProperty;
import io.gatling.plugin.model.Team;
import io.gatling.plugin.util.checksum.PkgChecksum;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public final class OkHttpEnterpriseClient
implements EnterpriseClient {
    private static final Map<String, String> DEFAULT_SYSTEM_PROPERTIES = Collections.emptyMap();
    private static final MeaningfulTimeWindow DEFAULT_TIME_WINDOW = new MeaningfulTimeWindow(0, 0);
    private final PrivateApiRequests privateApiRequests;
    private final PackagesApiRequests packagesApiRequests;
    private final PoolsApiRequests poolsApiRequests;
    private final SimulationsApiRequests simulationsApiRequests;
    private final TeamsApiRequests teamsApiRequests;

    public static OkHttpEnterpriseClient getInstance(OkHttpClient okHttpClient, URL uRL, String string, String string2, String string3) throws EnterprisePluginException {
        OkHttpEnterpriseClient okHttpEnterpriseClient = new OkHttpEnterpriseClient(okHttpClient, uRL, string);
        okHttpEnterpriseClient.privateApiRequests.checkVersionSupport(string2, string3);
        return okHttpEnterpriseClient;
    }

    public static OkHttpEnterpriseClient getInstance(URL uRL, String string, String string2, String string3) throws EnterprisePluginException {
        return OkHttpEnterpriseClient.getInstance(new OkHttpClient(), uRL, string, string2, string3);
    }

    private OkHttpEnterpriseClient(OkHttpClient okHttpClient, URL uRL, String string) {
        HttpUrl httpUrl = HttpUrl.get((URL)uRL);
        if (httpUrl == null) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid HTTP or HTTPS URL", uRL));
        }
        this.privateApiRequests = new PrivateApiRequests(okHttpClient, httpUrl, string);
        this.packagesApiRequests = new PackagesApiRequests(okHttpClient, httpUrl, string);
        this.poolsApiRequests = new PoolsApiRequests(okHttpClient, httpUrl, string);
        this.simulationsApiRequests = new SimulationsApiRequests(okHttpClient, httpUrl, string);
        this.teamsApiRequests = new TeamsApiRequests(okHttpClient, httpUrl, string);
    }

    @Override
    public List<Simulation> getSimulations() throws EnterprisePluginException {
        return this.simulationsApiRequests.listSimulations().data;
    }

    @Override
    public Simulation getSimulation(UUID uUID) throws EnterprisePluginException {
        return this.simulationsApiRequests.getSimulation(uUID);
    }

    @Override
    public List<Team> getTeams() throws EnterprisePluginException {
        return this.teamsApiRequests.listTeams().data;
    }

    @Override
    public List<Pool> getPools() throws EnterprisePluginException {
        return this.poolsApiRequests.listPools().data;
    }

    @Override
    public List<PkgIndex> getPackages() throws EnterprisePluginException {
        return this.packagesApiRequests.listPackages().data;
    }

    @Override
    public Pkg getPackage(UUID uUID) throws EnterprisePluginException {
        return this.packagesApiRequests.readPackage(uUID);
    }

    @Override
    public long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        return this.packagesApiRequests.uploadPackage(uUID, file);
    }

    @Override
    public RunSummary startSimulation(UUID uUID, Map<String, String> map) throws EnterprisePluginException {
        List<SystemProperty> list = map.entrySet().stream().map(entry -> new SystemProperty((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        return this.simulationsApiRequests.startSimulation(uUID, list);
    }

    private boolean checksumComparison(UUID uUID, File file) throws EnterprisePluginException {
        try {
            Pkg pkg = this.getPackage(uUID);
            return pkg.file != null && PkgChecksum.computeChecksum(file).equals(pkg.file.checksum);
        }
        catch (PackageNotFoundException packageNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw new ApiCallIOException(iOException);
        }
    }

    @Override
    public long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        return this.checksumComparison(uUID, file) ? -1L : this.uploadPackage(uUID, file);
    }

    @Override
    public Simulation createSimulation(String string, UUID uUID, String string2, UUID uUID2, Map<UUID, HostByPool> map) throws EnterprisePluginException {
        return this.simulationsApiRequests.createSimulation(new SimulationCreationPayload(string, uUID, string2, uUID2, null, DEFAULT_SYSTEM_PROPERTIES, false, DEFAULT_TIME_WINDOW, map, false, false));
    }

    @Override
    public Pkg createPackage(String string, UUID uUID) throws EnterprisePluginException {
        return this.packagesApiRequests.createPackage(new PackageCreationPayload(string, uUID));
    }
}

