/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.PluginClient;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SeveralTeamsFoundException;
import io.gatling.plugin.exceptions.SimulationStartException;
import io.gatling.plugin.exceptions.TeamNotFoundException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.HostByPool;
import io.gatling.plugin.model.Pkg;
import io.gatling.plugin.model.Pool;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationStartResult;
import io.gatling.plugin.model.Team;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EnterprisePluginClient
extends PluginClient
implements EnterprisePlugin {
    public EnterprisePluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger) {
        super(enterpriseClient, pluginLogger);
    }

    @Override
    public long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        return this.uploadPackageWithChecksum(uUID, file);
    }

    @Override
    public long uploadPackageWithSimulationId(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(file, "simulationId");
        ObjectsUtil.nonNullParam(file, "file");
        Simulation simulation = this.enterpriseClient.getSimulation(uUID);
        return this.enterpriseClient.uploadPackageWithChecksum(simulation.pkgId, file);
    }

    @Override
    public SimulationStartResult uploadPackageAndStartSimulation(UUID uUID, Map<String, String> map, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "simulationId");
        ObjectsUtil.nonNullParam(map, "systemProperties");
        ObjectsUtil.nonNullParam(file, "file");
        Simulation simulation = this.enterpriseClient.getSimulation(uUID);
        this.uploadPackageWithChecksum(simulation.pkgId, file);
        RunSummary runSummary = this.enterpriseClient.startSimulation(uUID, map);
        return new SimulationStartResult(simulation, runSummary, false);
    }

    @Override
    public SimulationStartResult createAndStartSimulation(UUID uUID, String string, String string2, String string3, UUID uUID2, Map<String, String> map, File file) throws EnterprisePluginException {
        ObjectsUtil.nonEmptyParam(string2, "artifactId");
        ObjectsUtil.nonEmptyParam(string3, "className");
        Team team = this.defaultTeam(uUID);
        Pkg pkg = uUID2 != null ? this.enterpriseClient.getPackage(uUID2) : this.createAndUploadDefaultPackage(team, string, string2, file);
        Map<UUID, HostByPool> map2 = this.defaultHostByPool();
        return this.createAndStartSimulation(team, pkg, string3, map2, map);
    }

    private Team defaultTeam(UUID uUID) throws EnterprisePluginException {
        List<Team> list = this.enterpriseClient.getTeams();
        if (list.isEmpty()) {
            throw new IllegalStateException("Cannot create a simulation: no team was found and a simulation must belong to a team. In order to create a team, see https://gatling.io/docs/enterprise/cloud/reference/admin/teams/");
        }
        if (uUID == null && list.size() != 1) {
            throw new SeveralTeamsFoundException(list, "Cannot configure a team: several teams were found, you must provide a configuration for a single team.");
        }
        if (uUID != null) {
            return list.stream().filter(team -> uUID.equals(team.id)).findFirst().orElseThrow(() -> new TeamNotFoundException(uUID));
        }
        return list.get(0);
    }

    private Pkg createAndUploadDefaultPackage(Team team, String string, String string2, File file) throws EnterprisePluginException {
        String string3 = string != null ? string + ":" + string2 : string2;
        Pkg pkg = this.enterpriseClient.createPackage(string3, team.id);
        this.enterpriseClient.uploadPackage(pkg.id, file);
        return pkg;
    }

    private Map<UUID, HostByPool> defaultHostByPool() throws EnterprisePluginException {
        List<Pool> list = this.enterpriseClient.getPools();
        if (list.isEmpty()) {
            throw new IllegalStateException("Cannot automatically create a simulation if no pool is available");
        }
        Pool pool = list.get(0);
        return Collections.singletonMap(pool.id, new HostByPool(1, 0));
    }

    private SimulationStartResult createAndStartSimulation(Team team, Pkg pkg, String string, Map<UUID, HostByPool> map, Map<String, String> map2) throws EnterprisePluginException {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        Simulation simulation = this.enterpriseClient.createSimulation(string2, team.id, string, pkg.id, map);
        try {
            RunSummary runSummary = this.enterpriseClient.startSimulation(simulation.id, map2);
            return new SimulationStartResult(simulation, runSummary, true);
        }
        catch (EnterprisePluginException enterprisePluginException) {
            throw new SimulationStartException(simulation, (Throwable)enterprisePluginException);
        }
    }
}

