/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.util.UUID;

abstract class PluginClient
implements AutoCloseable {
    protected final EnterpriseClient enterpriseClient;
    protected final PluginLogger logger;

    public PluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
    }

    protected long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        if (this.enterpriseClient.uploadPackageWithChecksum(uUID, file) == -1L) {
            this.logger.info("No code changes detected, skipping package upload");
        } else {
            this.logger.info("Package uploaded");
        }
        return file.length();
    }

    @Override
    public void close() throws Exception {
        this.enterpriseClient.close();
    }
}

