/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import io.gatling.plugin.client.http.AbstractApiRequests;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SimulationNotFoundException;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationCreationPayload;
import io.gatling.plugin.model.Simulations;
import io.gatling.plugin.model.SystemProperty;
import java.util.List;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class SimulationsApiRequests
extends AbstractApiRequests {
    SimulationsApiRequests(OkHttpClient okHttpClient, HttpUrl httpUrl, String string) {
        super(okHttpClient, httpUrl, string);
    }

    Simulation getSimulation(UUID uUID) throws EnterprisePluginException {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegment("simulations").addPathSegment(uUID.toString()).build();
        Request.Builder builder = new Request.Builder().url(httpUrl).get();
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, Simulation.class), response -> {
            if (response.code() == 404) {
                throw new SimulationNotFoundException(uUID);
            }
        });
    }

    Simulations listSimulations() throws EnterprisePluginException {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegment("simulations").build();
        Request.Builder builder = new Request.Builder().url(httpUrl).get();
        return this.executeRequest(builder, response -> {
            List<Simulation> list = this.readResponseJson((Response)response, new TypeReference<List<Simulation>>(){});
            return new Simulations(list);
        });
    }

    Simulation createSimulation(SimulationCreationPayload simulationCreationPayload) throws EnterprisePluginException {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegment("simulations").build();
        RequestBody requestBody = this.jsonRequestBody(simulationCreationPayload);
        Request.Builder builder = new Request.Builder().url(httpUrl).post(requestBody);
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, Simulation.class));
    }

    RunSummary startSimulation(UUID uUID, List<SystemProperty> list) throws EnterprisePluginException {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegments("simulations/start").addQueryParameter("simulation", uUID.toString()).build();
        RequestBody requestBody = this.jsonRequestBody(list);
        Request.Builder builder = new Request.Builder().url(httpUrl).post(requestBody);
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, RunSummary.class));
    }
}

