/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.EnterpriseSimulationScanner;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.ServerInformation;
import io.gatling.plugin.util.ObjectsUtil;
import io.gatling.scanner.HighestJavaVersionClass;
import io.gatling.scanner.SimulationScanResult;
import java.io.File;
import java.util.List;
import java.util.UUID;

abstract class PluginClient
implements AutoCloseable {
    protected final EnterpriseClient enterpriseClient;
    protected final PluginLogger logger;

    public PluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
    }

    protected long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        if (this.enterpriseClient.uploadPackageWithChecksum(uUID, file) == -1L) {
            this.logger.info("No code changes detected, skipping package upload");
        } else {
            this.logger.info("Package uploaded");
        }
        return file.length();
    }

    protected void checkSimulationByteCodeCompatibility(HighestJavaVersionClass highestJavaVersionClass) throws EnterprisePluginException {
        ServerInformation serverInformation = this.enterpriseClient.getServerInformation();
        int n = Integer.parseInt(serverInformation.versions.java.max);
        if (highestJavaVersionClass.javaVersion > n) {
            throw new UnsupportedJavaVersionException(highestJavaVersionClass.clazz, highestJavaVersionClass.javaVersion, n);
        }
    }

    protected List<String> simulationClassesFromCompatibleByteCodeFile(File file) throws EnterprisePluginException {
        SimulationScanResult simulationScanResult = EnterpriseSimulationScanner.simulationFullyQualifiedNamesFromFile(file);
        this.checkSimulationByteCodeCompatibility(simulationScanResult.getHighestJavaVersionClass());
        return simulationScanResult.getSimulationClasses();
    }

    @Override
    public void close() throws Exception {
        this.enterpriseClient.close();
    }
}

