/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.gatling.plugin.client.json.JsonUtil;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.ForbiddenApiCallException;
import io.gatling.plugin.exceptions.InvalidApiCallException;
import io.gatling.plugin.exceptions.JsonRequestProcessingException;
import io.gatling.plugin.exceptions.JsonResponseProcessingException;
import io.gatling.plugin.exceptions.UnauthorizedApiCallException;
import io.gatling.plugin.exceptions.UnhandledApiCallException;
import io.gatling.plugin.util.LambdaExceptionUtil;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

abstract class AbstractApiRequests {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final MediaType OCTET_STREAM_MEDIA_TYPE = MediaType.get((String)"application/octet-stream");
    protected static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json");
    protected final OkHttpClient okHttpClient;
    protected final HttpUrl url;
    protected final String token;

    AbstractApiRequests(OkHttpClient okHttpClient, HttpUrl httpUrl, String string) {
        this.okHttpClient = okHttpClient;
        this.url = httpUrl;
        this.token = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T executeRequest(Request.Builder builder, LambdaExceptionUtil.FunctionWithExceptions<Response, T, EnterprisePluginException> functionWithExceptions, LambdaExceptionUtil.ConsumerWithExceptions<Response, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        Request request = builder.header(AUTHORIZATION_HEADER, this.token).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            consumerWithExceptions.accept(response);
            this.defaultValidateResponse(response);
            Response response2 = functionWithExceptions.apply(response);
            return (T)response2;
        }
        catch (IOException iOException) {
            throw new ApiCallIOException(iOException);
        }
    }

    <T> T executeRequest(Request.Builder builder, LambdaExceptionUtil.FunctionWithExceptions<Response, T, EnterprisePluginException> functionWithExceptions) throws EnterprisePluginException {
        return this.executeRequest(builder, functionWithExceptions, response -> {});
    }

    void defaultValidateResponse(Response response) throws EnterprisePluginException {
        if (!response.isSuccessful()) {
            switch (response.code()) {
                case 401: {
                    throw new UnauthorizedApiCallException();
                }
                case 403: {
                    throw new ForbiddenApiCallException();
                }
                case 400: {
                    throw new InvalidApiCallException(this.readResponseBody(response));
                }
            }
            throw new UnhandledApiCallException(response.code(), this.readResponseBody(response));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readResponseBody(Response response) throws EnterprisePluginException {
        try (ResponseBody responseBody = response.body();){
            String string = responseBody.string();
            return string;
        }
        catch (IOException iOException) {
            throw new JsonResponseProcessingException(iOException);
        }
    }

    <T> T readResponseJson(Response response, Class<T> clazz) throws EnterprisePluginException {
        try {
            return (T)JsonUtil.JSON_MAPPER.readValue(this.readResponseBody(response), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonResponseProcessingException(jsonProcessingException);
        }
    }

    <T> T readResponseJson(Response response, TypeReference<T> typeReference) throws EnterprisePluginException {
        try {
            return (T)JsonUtil.JSON_MAPPER.readValue(this.readResponseBody(response), typeReference);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonResponseProcessingException(jsonProcessingException);
        }
    }

    RequestBody jsonRequestBody(Object object) {
        String string;
        try {
            string = JsonUtil.JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonRequestProcessingException(jsonProcessingException);
        }
        return RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)string);
    }
}

