/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import io.gatling.plugin.client.http.AbstractApiRequests;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidApiCallException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import io.gatling.plugin.model.PackageCreationPayload;
import io.gatling.plugin.model.Packages;
import io.gatling.plugin.model.Pkg;
import java.io.File;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class PackagesApiRequests
extends AbstractApiRequests {
    PackagesApiRequests(OkHttpClient okHttpClient, HttpUrl httpUrl, String string) {
        super(okHttpClient, httpUrl, string);
    }

    Packages listPackages() throws EnterprisePluginException {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegment("artifacts").build();
        Request.Builder builder = new Request.Builder().url(httpUrl).get();
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, Packages.class));
    }

    Pkg readPackage(UUID uUID) throws EnterprisePluginException {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegment("artifacts").addPathSegment(uUID.toString()).build();
        Request.Builder builder = new Request.Builder().url(httpUrl).get();
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, Pkg.class), response -> {
            if (response.code() == 404) {
                throw new PackageNotFoundException(uUID);
            }
        });
    }

    Pkg createPackage(PackageCreationPayload packageCreationPayload) throws EnterprisePluginException {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegment("artifacts").build();
        RequestBody requestBody = this.jsonRequestBody(packageCreationPayload);
        Request.Builder builder = new Request.Builder().url(httpUrl).post(requestBody);
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, Pkg.class));
    }

    long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        Request.Builder builder = this.uploadPackageRequest(uUID, file);
        return this.executeRequest(builder, response -> file.length(), response -> {
            if (response.code() == 413) {
                throw new InvalidApiCallException("Package exceeds maximum allowed size (5 GB)");
            }
            if (response.code() == 404) {
                throw new PackageNotFoundException(uUID);
            }
        });
    }

    private Request.Builder uploadPackageRequest(UUID uUID, File file) {
        HttpUrl httpUrl = this.url.newBuilder().addPathSegment("artifacts").addPathSegment(uUID.toString()).addPathSegment("content").addQueryParameter("filename", file.getName()).build();
        RequestBody requestBody = RequestBody.create((MediaType)OCTET_STREAM_MEDIA_TYPE, (File)file);
        return new Request.Builder().url(httpUrl).put(requestBody);
    }
}

