/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import io.gatling.plugin.client.http.AbstractApiRequests;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SimulationNotFoundException;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationClassName;
import io.gatling.plugin.model.SimulationCreationPayload;
import io.gatling.plugin.model.Simulations;
import io.gatling.plugin.model.StartOptions;
import java.util.List;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class SimulationsApiRequests
extends AbstractApiRequests {
    private final HttpUrl simulationsUrl;

    SimulationsApiRequests(OkHttpClient okHttpClient, HttpUrl httpUrl, String string) {
        super(okHttpClient, httpUrl, string);
        this.simulationsUrl = this.url.newBuilder().addPathSegment("simulations").build();
    }

    Simulation getSimulation(UUID uUID) throws EnterprisePluginException {
        HttpUrl httpUrl = this.simulationsUrl.newBuilder().addPathSegment(uUID.toString()).build();
        Request.Builder builder = new Request.Builder().url(httpUrl).get();
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, Simulation.class), response -> {
            if (response.code() == 404) {
                throw new SimulationNotFoundException(uUID);
            }
        });
    }

    Simulations listSimulations() throws EnterprisePluginException {
        Request.Builder builder = new Request.Builder().url(this.simulationsUrl).get();
        return this.executeRequest(builder, response -> {
            List<Simulation> list = this.readResponseJson((Response)response, new TypeReference<List<Simulation>>(){});
            return new Simulations(list);
        });
    }

    Simulation createSimulation(SimulationCreationPayload simulationCreationPayload) throws EnterprisePluginException {
        RequestBody requestBody = this.jsonRequestBody(simulationCreationPayload);
        Request.Builder builder = new Request.Builder().url(this.simulationsUrl).post(requestBody);
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, Simulation.class));
    }

    RunSummary startSimulation(UUID uUID, StartOptions startOptions) throws EnterprisePluginException {
        HttpUrl httpUrl = this.simulationsUrl.newBuilder().addPathSegment("start").addQueryParameter("simulation", uUID.toString()).build();
        RequestBody requestBody = this.jsonRequestBody(startOptions);
        Request.Builder builder = new Request.Builder().url(httpUrl).post(requestBody);
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, RunSummary.class));
    }

    SimulationClassName updateSimulationClassName(UUID uUID, String string) throws EnterprisePluginException {
        HttpUrl httpUrl = this.simulationsUrl.newBuilder().addPathSegment(uUID.toString()).addPathSegment("classname").build();
        RequestBody requestBody = this.jsonRequestBody(new SimulationClassName(string));
        Request.Builder builder = new Request.Builder().url(httpUrl).put(requestBody);
        return this.executeRequest(builder, response -> this.readResponseJson((Response)response, SimulationClassName.class));
    }
}

