/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.api;

import io.gatling.plugin.client.http.api.AbstractApi;
import io.gatling.plugin.client.http.api.ApiPath;
import io.gatling.plugin.client.http.api.HttpResponse;
import io.gatling.plugin.client.http.requests.ArtifactCreationRequest;
import io.gatling.plugin.client.http.responses.ArtifactIndexesResponse;
import io.gatling.plugin.client.http.responses.ArtifactResponse;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidApiCallException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;

public class ArtifactsApi
extends AbstractApi {
    private static final ApiPath ARTIFACTS_PATH = ApiPath.of("artifacts");

    public ArtifactsApi(URL uRL, String string) {
        super(uRL, string);
    }

    public ArtifactIndexesResponse listPackages() throws EnterprisePluginException {
        return this.getJson(ApiPath.of("artifacts"), ArtifactIndexesResponse.class);
    }

    public ArtifactResponse readPackage(String string) throws EnterprisePluginException {
        return this.getJson(ARTIFACTS_PATH.append(string.toString()), ArtifactResponse.class, (HttpResponse httpResponse) -> {
            if (httpResponse.code == 404) {
                throw new PackageNotFoundException(string);
            }
        });
    }

    public ArtifactResponse createPackage(ArtifactCreationRequest artifactCreationRequest) throws EnterprisePluginException {
        return this.postJson(ARTIFACTS_PATH, (Object)artifactCreationRequest, ArtifactResponse.class);
    }

    public long uploadPackage(String string, File file) throws EnterprisePluginException {
        ApiPath apiPath = ARTIFACTS_PATH.append(string.toString(), "content").addQueryParam("filename", file.getName());
        this.put(apiPath, httpURLConnection -> {
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpURLConnection.setDoOutput(true);
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                Files.copy(file.toPath(), outputStream);
            }
            catch (IOException iOException) {
                throw new ApiCallIOException("Fail to upload managed package", iOException);
            }
        }, httpResponse -> {
            if (httpResponse.code == 413) {
                throw new InvalidApiCallException("Package exceeds maximum allowed size (5 GB)");
            }
            if (httpResponse.code == 404) {
                throw new PackageNotFoundException(string);
            }
        });
        return file.length();
    }
}

