/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.json.JsonUtil;
import io.gatling.plugin.domain.PluginClient;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InterruptedRetryException;
import io.gatling.plugin.exceptions.InvalidConfigFileException;
import io.gatling.plugin.exceptions.SimulationNameNotDeployedException;
import io.gatling.plugin.exceptions.SimulationScannerIOException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.DeployedPkgInfo;
import io.gatling.plugin.model.DeployedSimulationInfo;
import io.gatling.plugin.model.DeploymentInfo;
import io.gatling.plugin.model.RunComment;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.pkg.EnterprisePackager;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class BatchEnterprisePluginClient
extends PluginClient
implements BatchEnterprisePlugin {
    private static final int MAX_RETRIES = 3;
    private static final int SECONDS_BETWEEN_RETRY = 3;

    public BatchEnterprisePluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger, URL uRL) {
        super(enterpriseClient, pluginLogger, uRL);
    }

    @Override
    public DeploymentInfo deployFromDescriptor(File file, File file2, String string, Boolean bl) throws EnterprisePluginException {
        ObjectNode objectNode;
        Object object;
        ObjectsUtil.nonNullParam(file2, "pkg");
        ObjectsUtil.nonNullParam(string, "artifactId");
        ObjectsUtil.nonNullParam(bl, "usePrivateRepository");
        if (file != null && file.exists()) {
            try {
                object = ConfigFactory.parseFile((File)file).resolve();
                objectNode = JsonUtil.JSON_MAPPER.readTree(object.root().render(ConfigRenderOptions.concise()));
            }
            catch (JsonProcessingException | ConfigException throwable) {
                throw new InvalidConfigFileException(file, throwable);
            }
        } else {
            objectNode = JsonUtil.JSON_MAPPER.createObjectNode();
        }
        object = this.deployPkg((JsonNode)objectNode, string, bl);
        this.uploadPackage(object.id, file2);
        List<DeployedSimulationInfo> list = this.deploySimulations(object.id, (JsonNode)objectNode);
        return new DeploymentInfo((DeployedPkgInfo)object, list);
    }

    @Override
    public RunSummary startSimulation(String string, DeploymentInfo deploymentInfo, RunComment runComment) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(string, "simulationName");
        ObjectsUtil.nonNullParam(deploymentInfo, "deploymentInfo");
        DeployedSimulationInfo deployedSimulationInfo2 = deploymentInfo.deployedSimulationInfoList.stream().filter(deployedSimulationInfo -> deployedSimulationInfo.name.equals(string)).findFirst().orElseThrow(() -> new SimulationNameNotDeployedException(string));
        return this.startSimulation(deployedSimulationInfo2, runComment);
    }

    private DeployedPkgInfo deployPkg(JsonNode jsonNode, String string, Boolean bl) throws EnterprisePluginException {
        DeployedPkgInfo deployedPkgInfo = this.enterpriseClient.deployPkg(jsonNode, string, bl);
        this.logger.info(String.format("Package '%s' (id='%s') deployed", deployedPkgInfo.name, deployedPkgInfo.id));
        return deployedPkgInfo;
    }

    private void uploadPackage(String string, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(string, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        this.validateJavaVersion(file);
        this.uploadPackageWithChecksum(string, file);
    }

    private List<DeployedSimulationInfo> deploySimulations(String string, JsonNode jsonNode) throws EnterprisePluginException {
        List<DeployedSimulationInfo> list = this.enterpriseClient.deploySimulations(string, jsonNode);
        for (DeployedSimulationInfo deployedSimulationInfo : list) {
            this.logger.info(String.format("Simulation '%s' (id='%s') deployed", deployedSimulationInfo.name, deployedSimulationInfo.id));
        }
        return list;
    }

    private void validateJavaVersion(File file) throws EnterprisePluginException {
        int n;
        try {
            n = EnterprisePackager.getJavaVersion(file);
        }
        catch (IOException iOException) {
            throw new SimulationScannerIOException(file, iOException);
        }
        int n2 = Integer.parseInt(this.enterpriseClient.getServerInformation().versions.java.max);
        if (n > n2) {
            throw new UnsupportedJavaVersionException(n, n2);
        }
    }

    private void uploadPackageWithChecksum(String string, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(string, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        this.uploadPackageWithRetry(string, file, 3);
    }

    private long uploadPackageWithRetry(String string, File file, int n) throws EnterprisePluginException {
        try {
            if (this.enterpriseClient.uploadPackageWithChecksum(string, file) == -1L) {
                this.logger.info("No code changes detected, skipping package upload");
            } else {
                this.logger.info(String.format("Package uploaded (id='%s')", string));
            }
            return file.length();
        }
        catch (ApiCallIOException apiCallIOException) {
            if (n < 1) {
                throw apiCallIOException;
            }
            try {
                this.logger.info("Upload failed, retrying in 3 seconds");
                TimeUnit.SECONDS.sleep(3L);
                return this.uploadPackageWithRetry(string, file, n - 1);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedRetryException(interruptedException);
            }
        }
    }
}

