/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ConfigurationConstants {
    private ConfigurationConstants() {
    }

    @Nullable
    private static String valueOrSysProp(@Nullable String string, @NonNull String string2) {
        return string != null ? string : System.getProperty(string2);
    }

    @Nullable
    private static String valueOrSysPropOrEnvVar(@Nullable String string, @NonNull String string2, @NonNull String string3) {
        if (string != null) {
            return string;
        }
        String string4 = System.getProperty(string2);
        if (string4 != null) {
            return string4;
        }
        return System.getenv(string3);
    }

    @NonNull
    private static String valueOrSysPropOrDefault(@Nullable String string, @NonNull String string2, @NonNull String string3) {
        return Objects.requireNonNullElseGet(string, () -> Objects.requireNonNullElse(System.getProperty(string2), string3));
    }

    private static boolean booleanValueOrSysProp(@Nullable Boolean bl, @NonNull String string) {
        return bl != null ? bl : Boolean.getBoolean(string);
    }

    public static class StartOptions {

        public static final class WaitForRunEnd {
            public static final String SYS_PROP = "gatling.enterprise.waitForRunEnd";

            public static boolean valueOf(@Nullable Boolean bl) {
                return ConfigurationConstants.booleanValueOrSysProp(bl, SYS_PROP);
            }

            public static boolean value() {
                return WaitForRunEnd.valueOf(null);
            }
        }

        public static final class RunDescription {
            public static final String SYS_PROP = "gatling.enterprise.runDescription";

            @Nullable
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
            }

            @Nullable
            public static String value() {
                return RunDescription.valueOf(null);
            }
        }

        public static final class RunTitle {
            public static final String SYS_PROP = "gatling.enterprise.runTitle";

            @Nullable
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
            }

            @Nullable
            public static String value() {
                return RunTitle.valueOf(null);
            }
        }

        public static final class SimulationName {
            public static final String SYS_PROP = "gatling.enterprise.simulationName";

            @Nullable
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
            }

            @Nullable
            public static String value() {
                return SimulationName.valueOf(null);
            }
        }
    }

    public static class DeployOptions {

        public static final class ValidateSimulationId {
            public static final String SYS_PROP = "gatling.enterprise.validateSimulationId";

            @Nullable
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
            }

            @Nullable
            public static String value() {
                return ValidateSimulationId.valueOf(null);
            }
        }

        public static final class ArtifactId {
            public static final String SYS_PROP = "gatling.enterprise.artifactId";

            @Nullable
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
            }

            @Nullable
            public static String value() {
                return ArtifactId.valueOf(null);
            }
        }

        public static final class PackageFile {
            public static final String SYS_PROP = "gatling.enterprise.packageFile";

            @Nullable
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
            }

            @Nullable
            public static String value() {
                return PackageFile.valueOf(null);
            }
        }

        public static final class PackageDescriptorFilename {
            public static final String SYS_PROP = "gatling.enterprise.packageDescriptorFilename";
            public static final String DEFAULT = "package.conf";

            @NonNull
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysPropOrDefault(string, SYS_PROP, DEFAULT);
            }

            @NonNull
            public static String value() {
                return PackageDescriptorFilename.valueOf(null);
            }
        }

        public static final class BaseDirectory {
            public static final String SYS_PROP = "gatling.enterprise.baseDirectory";

            @Nullable
            public static String valueOf(@Nullable String string) {
                return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
            }

            @Nullable
            public static String value() {
                return BaseDirectory.valueOf(null);
            }
        }
    }

    public static final class BatchMode {
        public static final String SYS_PROP = "gatling.enterprise.batchMode";

        public static boolean valueOf(@Nullable Boolean bl) {
            return ConfigurationConstants.booleanValueOrSysProp(bl, SYS_PROP);
        }

        public static boolean value() {
            return BatchMode.valueOf(null);
        }
    }

    public static final class PluginVersion {
        public static final String SYS_PROP = "gatling.enterprise.pluginVersion";

        @Nullable
        public static String valueOf(@Nullable String string) {
            return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
        }

        @Nullable
        public static String value() {
            return PluginVersion.valueOf(null);
        }
    }

    public static final class BuildTool {
        public static final String SYS_PROP = "gatling.enterprise.buildTool";

        @Nullable
        public static String valueOf(@Nullable String string) {
            return ConfigurationConstants.valueOrSysProp(string, SYS_PROP);
        }

        @Nullable
        public static String value() {
            return BuildTool.valueOf(null);
        }
    }

    public static final class ControlPlaneUrl {
        public static final String SYS_PROP = "gatling.enterprise.controlPlaneUrl";
        public static final String ENV_VAR = "GATLING_CONTROL_PLANE_URL";

        @Nullable
        public static String valueOf(@Nullable String string) {
            return ConfigurationConstants.valueOrSysPropOrEnvVar(string, SYS_PROP, ENV_VAR);
        }

        @Nullable
        public static String value() {
            return ControlPlaneUrl.valueOf(null);
        }
    }

    public static final class ApiToken {
        public static final String SYS_PROP = "gatling.enterprise.apiToken";
        public static final String ENV_VAR = "GATLING_ENTERPRISE_API_TOKEN";

        @Nullable
        public static String valueOf(@Nullable String string) {
            return ConfigurationConstants.valueOrSysPropOrEnvVar(string, SYS_PROP, ENV_VAR);
        }

        @Nullable
        public static String value() {
            return ApiToken.valueOf(null);
        }
    }

    public static final class WebAppUrl {
        public static final String SYS_PROP = "gatling.enterprise.webAppUrl";
        public static final String DEFAULT = "https://cloud.gatling.io";

        @NonNull
        public static String valueOf(@Nullable String string) {
            return ConfigurationConstants.valueOrSysPropOrDefault(string, SYS_PROP, DEFAULT);
        }

        @NonNull
        public static String value() {
            return WebAppUrl.valueOf(null);
        }
    }

    public static final class ApiUrl {
        public static final String SYS_PROP = "gatling.enterprise.apiUrl";
        public static final String DEFAULT = "https://api.gatling.io";

        @NonNull
        public static String valueOf(@Nullable String string) {
            return ConfigurationConstants.valueOrSysPropOrDefault(string, SYS_PROP, DEFAULT);
        }

        @NonNull
        public static String value() {
            return ApiUrl.valueOf(null);
        }
    }
}

