/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum RunStatus {
    Building(0, true, false, "building"),
    Deploying(1, true, false, "deploying"),
    Deployed(2, true, false, "deployed"),
    Injecting(3, true, false, "injecting"),
    Successful(4, false, true, "successful"),
    AssertionsSuccessful(5, false, true, "assertions_successful"),
    AutomaticallyStopped(6, false, false, "automatically_stopped"),
    ManuallyStopped(7, false, false, "stopped"),
    AssertionsFailed(8, false, false, "assertions_failed"),
    Timeout(9, false, false, "timeout"),
    BuildFailed(10, false, false, "build_failed"),
    Broken(11, false, false, "broken"),
    DeploymentFailed(12, false, false, "deployment_failed"),
    InsufficientCredit(13, false, false, "insufficient_credit"),
    StopRequested(15, true, false, "stop_requested"),
    StopCriteriaTriggered(16, false, false, "stop_criteria_triggered");

    public final int value;
    public final boolean running;
    public final boolean successful;
    private final String jsonValue;
    private static final Map<String, RunStatus> JSON_VALUE_MAP;

    private RunStatus(int n2, boolean bl, boolean bl2, String string2) {
        this.value = n2;
        this.running = bl;
        this.successful = bl2;
        this.jsonValue = string2;
    }

    @JsonValue
    public String getJsonValue() {
        return this.jsonValue;
    }

    @JsonCreator
    public static RunStatus fromJsonValue(String string) {
        RunStatus runStatus = JSON_VALUE_MAP.get(string);
        if (runStatus == null) {
            throw new IllegalArgumentException("Unknown RunStatus: " + string);
        }
        return runStatus;
    }

    public static RunStatus valueOf(int n) {
        RunStatus[] runStatusArray = RunStatus.values();
        return Arrays.stream(runStatusArray).filter(runStatus -> runStatus.value == n).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown RunStatus value: " + n));
    }

    static {
        JSON_VALUE_MAP = new HashMap<String, RunStatus>();
        for (RunStatus runStatus : RunStatus.values()) {
            JSON_VALUE_MAP.put(runStatus.jsonValue, runStatus);
        }
    }
}

