/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.domain;

import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.http.responses.GroupNodeResponse;
import io.gatling.plugin.client.http.responses.LiveInformationResponse;
import io.gatling.plugin.client.http.responses.NodeResponse;
import io.gatling.plugin.client.http.responses.RequestNodeResponse;
import io.gatling.plugin.client.http.responses.StatisticsResponse;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.MetricsSummary;
import io.gatling.plugin.model.RunInformation;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.model.SimulationEndResult;
import io.gatling.plugin.util.DurationFormatter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

final class RunStatusTask
extends TimerTask {
    private final EnterpriseClient enterpriseClient;
    private final PluginLogger logger;
    private final String runId;
    private final CountDownLatch latch;
    private int errorCount = 0;
    private RunStatus oldStatus;
    public SimulationEndResult result;
    public Exception exception;

    RunStatusTask(EnterpriseClient enterpriseClient, PluginLogger pluginLogger, String string, CountDownLatch countDownLatch) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
        this.runId = string;
        this.latch = countDownLatch;
    }

    @Override
    public void run() {
        try {
            LiveInformationResponse liveInformationResponse = this.enterpriseClient.getLiveRunInformation(this.runId);
            RunStatus runStatus = liveInformationResponse.status;
            if (runStatus != this.oldStatus) {
                this.logger.info(String.format("Run status is now %s [%s]", new Object[]{runStatus, runStatus.value}));
            }
            this.oldStatus = runStatus;
            if (liveInformationResponse.statistics != null) {
                this.logMetricsSummary(this.getMetricsSummary(liveInformationResponse));
            }
            this.errorCount = 0;
            if (!runStatus.running) {
                RunInformation runInformation = this.enterpriseClient.getRunInformation(this.runId);
                this.setResult(new SimulationEndResult(runStatus, runInformation.assertions));
            }
        }
        catch (Exception exception) {
            ++this.errorCount;
            if (this.errorCount < 5) {
                String string = exception.getCause() != null ? ": " + exception.getCause().getMessage() : "";
                this.logger.info(String.format("Failed to retrieve current run information (attempt %s/5): %s%s", this.errorCount, exception.getMessage(), string));
            }
            this.setException(exception);
        }
    }

    private MetricsSummary getMetricsSummary(LiveInformationResponse liveInformationResponse) {
        Instant instant = Instant.now();
        String string = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC).format(instant);
        StatisticsResponse statisticsResponse = liveInformationResponse.statistics;
        String string2 = DurationFormatter.formatDuration(statisticsResponse.durationInSeconds);
        double d = statisticsResponse.maxConcurrentUsers.intValue();
        double d2 = statisticsResponse.totalNumberOfRequests.longValue();
        double d3 = statisticsResponse.meanRequestPerSecond;
        double d4 = statisticsResponse.koPercentage;
        List<MetricsSummary.ChildMetric> list = this.recursivelyGetChildren(statisticsResponse.children);
        return new MetricsSummary(string, string2, d, d2, d3, d4, list);
    }

    private List<MetricsSummary.ChildMetric> recursivelyGetChildren(List<NodeResponse> list) {
        return list.stream().map(nodeResponse -> {
            if (nodeResponse instanceof RequestNodeResponse) {
                RequestNodeResponse requestNodeResponse = (RequestNodeResponse)nodeResponse;
                return new MetricsSummary.ChildMetric(requestNodeResponse.name, requestNodeResponse.totalNumberOfRequests.doubleValue(), requestNodeResponse.koPercentage, requestNodeResponse.meanRequestsPerSecond);
            }
            if (nodeResponse instanceof GroupNodeResponse) {
                GroupNodeResponse groupNodeResponse = (GroupNodeResponse)nodeResponse;
                return new MetricsSummary.ChildMetric(groupNodeResponse.name, this.recursivelyGetChildren(groupNodeResponse.children));
            }
            throw new IllegalStateException("Unknown node type: " + String.valueOf(nodeResponse));
        }).collect(Collectors.toList());
    }

    private void logMetricsSummary(MetricsSummary metricsSummary) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Time: ").append(metricsSummary.date).append(", ").append(metricsSummary.duration).append(" elapsed\n");
        stringBuilder.append("Number of concurrent users: ").append(metricsSummary.nbUsers).append("\n");
        stringBuilder.append("Number of requests: ").append(metricsSummary.nbRequest).append("\n");
        stringBuilder.append("Number of requests per seconds: ").append(metricsSummary.requestsSeconds).append("\n");
        this.formatListMetrics(stringBuilder, metricsSummary.listMetric, 0);
        this.logger.info(stringBuilder.toString());
    }

    private void formatListMetrics(StringBuilder stringBuilder, List<MetricsSummary.ChildMetric> list, int n) {
        String string = this.pad(2 * n);
        for (MetricsSummary.ChildMetric childMetric : list) {
            if (childMetric.children == null) {
                stringBuilder.append(string).append("> Request ").append(childMetric.name).append("\n");
                stringBuilder.append(string).append("   Counts: ").append(childMetric.nbRequest).append("\n");
                stringBuilder.append(string).append("   Requests per seconds: ").append(childMetric.requestsSeconds).append("\n");
                stringBuilder.append(string).append("   Failure ratio: ").append(childMetric.failureRatio).append("\n");
                continue;
            }
            stringBuilder.append(string).append("> Group ").append(childMetric.name).append("\n");
            this.formatListMetrics(stringBuilder, childMetric.children, n + 1);
        }
    }

    private String pad(int n) {
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private void setResult(SimulationEndResult simulationEndResult) {
        this.result = simulationEndResult;
        this.latch.countDown();
        this.cancel();
    }

    private void setException(Exception exception) {
        this.exception = exception;
        this.latch.countDown();
        this.cancel();
    }
}

